/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import no.esito.jvine.controller.CheckResult;
import no.esito.jvine.controller.FieldData;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.model.CurrentRoleObject;
import no.esito.jvine.model.DisplayableOSRole;
import no.esito.jvine.model.TreeNode;
import no.esito.jvine.model.TreeNodeImpl;
import no.esito.jvine.validation.ValidationManager;
import no.esito.jvine.validation.ValidationManagerFactory;
import no.esito.jvine.view.MessageUtil;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.CheckType;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.Interceptor;
import no.g9.client.core.controller.RoleState;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationPolicy;
import no.g9.client.core.validator.ValidationResult;
import no.g9.client.core.view.ViewModel;
import no.g9.os.AttributeConstant;
import no.g9.os.Key;
import no.g9.os.KeyTool;
import no.g9.os.OSRole;
import no.g9.os.RelationCardinality;
import no.g9.os.RelationType;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.TypeTool;
import no.g9.support.Visitor;

public final class OSNode<T>
implements DisplayableOSRole<T> {
    private static final Logger log = Logger.getLogger(OSNode.class);
    private final DialogController dialogController;
    protected TreeNode<T> treeNode;
    private OSRole<T> delegate;
    private RoleState state = RoleState.CLEARED;
    private boolean stateOverride = false;
    private T lastObtained;
    private Map<CheckType, Interceptor> interceptors = new EnumMap<CheckType, Interceptor>(CheckType.class);
    private final MessageUtil messageUtil = (MessageUtil)ServiceLoader.getService(MessageUtil.class);

    public OSNode(OSNode<?> parent, DialogController dialogController, OSRole<T> osRole) {
        TreeNode<Object> parentTreeNode;
        this.dialogController = dialogController;
        this.delegate = osRole;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating tree node " + osRole.getRoleConstant() + " parent: " + parent));
        }
        if (this.delegate.getRelationCardinality() == RelationCardinality.ROOT) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " getting the tree node sentinel."));
            }
            parentTreeNode = JVineController.getInstance(dialogController).getSentinel();
        } else if (parent != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " setting up tree node impl."));
            }
            parentTreeNode = parent.treeNode;
        } else {
            throw new NullPointerException("Parent cannot be null");
        }
        this.treeNode = new TreeNodeImpl(parentTreeNode, this);
        parentTreeNode.addChild(this.treeNode);
        this.delegate = osRole;
    }

    Collection<AttributeConstant> getChangedAttributes() {
        return this.dialogController.getChangedAttributes(this.getRoleConstant());
    }

    Collection<AttributeConstant> getChangedNoKeyAttributes() {
        Collection<AttributeConstant> allChanged = this.getChangedAttributes();
        HashSet<AttributeConstant> keyAttributes = new HashSet<AttributeConstant>();
        for (Key key : this.getKeys()) {
            keyAttributes.addAll(Arrays.asList(key.getAttributes()));
        }
        allChanged.removeAll(keyAttributes);
        return allChanged;
    }

    public RelationType getRelationType() {
        return this.delegate.getRelationType();
    }

    public RelationCardinality getRelationCardinality() {
        return this.delegate.getRelationCardinality();
    }

    @Override
    public TreeNode<T> getTreeNode() {
        return this.treeNode;
    }

    @Override
    public Collection<OSNode<?>> setCurrentInstance(Object instance) {
        return this.getTreeNode().setCurrentInstance(this.castToType(instance));
    }

    public Collection<OSNode<?>> setCurrentInstances(Collection<?> instances) {
        return this.getTreeNode().setCurrentRootInstances(instances);
    }

    @Override
    public Collection<T> getAllInstances() {
        return this.getTreeNode().getInstances();
    }

    public boolean isCurrent(Object obj) {
        return obj != null && obj.equals(this.treeNode.getCurrentInstance());
    }

    @Override
    public FieldData getFieldData() {
        return JVineController.getInstance(this.dialogController).getFieldData(this.getRoleConstant());
    }

    public AttributeConstant[] getAttributeConstants() {
        return this.delegate.getAttributeConstants();
    }

    public Object getRelation(Object domainObject, RoleConstant role) {
        return this.delegate.getRelation(domainObject, role);
    }

    public void setMainKey(Key mainKey) {
        this.delegate.setMainKey(mainKey);
    }

    public void setRelation(Object domainInstance, Object relation, RoleConstant role) {
        this.delegate.setRelation(domainInstance, relation, role);
    }

    public void setValue(Object domainObject, AttributeConstant attribute, Object value) {
        this.delegate.setValue(domainObject, attribute, value);
    }

    @Override
    public T getCurrentInstance() {
        return this.getTreeNode().getCurrentInstance();
    }

    public void updateRelation(Object domainInstance, Object relation, RoleConstant role) {
        this.delegate.updateRelation(domainInstance, relation, role);
    }

    public List<CurrentRoleObject> getCurrentObjectList() {
        LinkedList<CurrentRoleObject> currentList = new LinkedList<CurrentRoleObject>();
        T current = this.getCurrentInstance();
        if (current != null && this.isMany()) {
            currentList.add(new CurrentRoleObject(this.getRoleConstant(), current));
        }
        if (current != null) {
            for (OSNode<?> child : this.getOSNodeChildren()) {
                currentList.addAll(child.getCurrentObjectList());
            }
        }
        return currentList;
    }

    private void setFieldValue(AttributeConstant attribute, Object value) {
        this.dialogController.setFieldValue(attribute, value);
    }

    private void connectToChildren(Object instance) {
        Collection<OSNode<?>> osNodeChildren = this.getOSNodeChildren();
        for (OSNode<?> child : osNodeChildren) {
            Object childInst = child.peek();
            if (child.isMany()) {
                Collection defaultCollection = TypeTool.getDefaultCollection();
                defaultCollection.add(childInst);
                this.setRelation(instance, defaultCollection, child.getRoleConstant());
            } else {
                this.setRelation(instance, childInst, child.getRoleConstant());
            }
            super.connectToChildren(childInst);
        }
    }

    @Override
    public Collection<OSNode<?>> setCurrent(FieldData data) {
        T instance;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " setting current instance for " + data));
        }
        T mockInstance = this.createInstanceFromFieldData(data);
        if (this.isNavigableToParent()) {
            Object parentObj = this.treeNode.getParent().getCurrentInstance();
            this.setRelation(mockInstance, parentObj, this.getParent().getRoleConstant());
        }
        this.connectToChildren(mockInstance);
        Collection<T> instances = this.treeNode.getInstances();
        Object found = null;
        Iterator<T> instanceIterator = instances.iterator();
        while (instanceIterator.hasNext() && found == null) {
            instance = instanceIterator.next();
            if (instance == null || !instance.equals(mockInstance)) continue;
            found = instance;
        }
        if (found == null) {
            instanceIterator = instances.iterator();
        }
        while (instanceIterator.hasNext() && found == null) {
            instance = instanceIterator.next();
            if (!this.matchUniqueKeys(mockInstance, instance, true)) continue;
            found = instance;
        }
        if (found == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not find instance, making a new one.");
            }
            found = this.createNewInstance(data);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Found instance. Using that as the current");
        }
        return this.treeNode.setCurrentInstance(found);
    }

    private T createInstanceFromFieldData(FieldData data) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating new instance based on " + data));
        }
        T instance = this.createNewInstance();
        for (Map.Entry<AttributeConstant, Object> entry : data.entries()) {
            AttributeConstant attributeConstant = entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeConstant.isForeignAttribute()) {
                String msg = "Can't create instance - expected local attribute but got foreign " + attributeConstant;
                throw new IllegalArgumentException(msg);
            }
            if (attributeConstant.getAttributeRole().equals(this.getRoleConstant()) || this.isRelated(attributeConstant)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Setting attribute " + attributeConstant));
                }
                this.setValue(instance, attributeConstant, attributeValue);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Ignoring unknown attribute " + attributeConstant + ". It is neither local or related."));
        }
        return instance;
    }

    public Collection<OSNode<?>> clearKeepKeys() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " clear keep keys."));
        }
        ArrayList changed = new ArrayList();
        this.getTreeNode().removeCurrent();
        AttributeConstant[] allAttributes = this.getAttributeConstants();
        HashSet<AttributeConstant> keyAttribute = new HashSet<AttributeConstant>();
        if (this.getMainKey() != null) {
            for (AttributeConstant attributeConstant : this.getMainKey().getAttributes()) {
                keyAttribute.add(attributeConstant);
            }
        }
        for (AttributeConstant attributeConstant : allAttributes) {
            if (keyAttribute.contains(attributeConstant)) continue;
            this.setFieldValue(attributeConstant, null);
        }
        for (OSNode oSNode : this.getOSNodeChildren()) {
            changed.addAll(oSNode.clear(true));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " cleared kept keys. Changed nodes: " + changed));
        }
        return changed;
    }

    @Override
    public Collection<OSNode<?>> clear(boolean intercept) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " clearing"));
        }
        return this.getTreeNode().clear(intercept);
    }

    @Override
    public Collection<OSNode<?>> clearCurrent(boolean intercept) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " clearing current"));
        }
        return this.getTreeNode().clearCurrent(intercept);
    }

    private boolean isChanged() {
        return this.dialogController.isChanged(this.getRoleConstant());
    }

    public T obtain(boolean clearCurrent) {
        T self;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " obtaining."));
        }
        if ((self = this.obtainCurrent(true)) == null) {
            return self;
        }
        Collection<OSNode<?>> children = this.getOSNodeChildren();
        for (OSNode<?> child : children) {
            if (!child.hasValue()) continue;
            Object obtainedChild = super.obtainWideAsChild();
            if (child.isMany()) {
                this.addToCollection(child, self, obtainedChild);
                continue;
            }
            this.setRelation(self, obtainedChild, child.getRoleConstant());
        }
        OSNode<?> parentOSNode = this.getParentOSNode();
        if (parentOSNode != null && (this.isNavigableToParent() || clearCurrent)) {
            Object obtainedParentWithKey = super.obtainToGetKey(super.isPartOfKey(this) ? this : null);
            if (this.isNavigableToParent()) {
                this.setRelation(self, obtainedParentWithKey, this.getParentRoleConstant());
            }
            if (clearCurrent) {
                Object relationFromParentToThis = parentOSNode.getRelation(obtainedParentWithKey, this.getRoleConstant());
                if (relationFromParentToThis instanceof Collection) {
                    ((Collection)relationFromParentToThis).remove(self);
                } else {
                    parentOSNode.setRelation(obtainedParentWithKey, null, this.getRoleConstant());
                }
            }
        }
        JVineController.getInstance(this.dialogController).checkValidationAndConvert(true);
        return self;
    }

    private void addToCollection(OSNode<?> child, Object domainObject, Object obtainedChild) {
        assert (child.isMany());
        HashSet<Object> childCollection = (HashSet<Object>)this.getRelation(domainObject, child.getRoleConstant());
        if (childCollection == null) {
            childCollection = new HashSet<Object>();
            this.setRelation(domainObject, childCollection, child.getRoleConstant());
        }
        childCollection.add(obtainedChild);
    }

    private T obtainWideAsChild() {
        if (!this.hasValue()) {
            return null;
        }
        log.debug((Object)(this + " obtaining wide as child"));
        T obtainedCurrent = this.obtainCurrent(false);
        Collection<OSNode<?>> children = this.getOSNodeChildren();
        for (OSNode<?> child : children) {
            Object obtainedChild = super.obtainWideAsChild();
            log.debug((Object)(this + " setting relation to obtained " + child));
            if (child.isMany()) {
                this.addToCollection(child, obtainedCurrent, obtainedChild);
                continue;
            }
            this.setRelation(obtainedCurrent, obtainedChild, child.getRoleConstant());
        }
        return obtainedCurrent;
    }

    private T obtainToGetKey(OSNode invokingChildNode) {
        OSNode<?> parentNode;
        T obtainedCurrent = this.obtainCurrent(true);
        log.debug((Object)(this + " obtained to get complete key of " + invokingChildNode + " or to enable removal of " + invokingChildNode));
        List<OSNode<?>> upRelatedChildren = this.getUpRelatedChildren();
        for (OSNode<?> upRelatedchildNode : upRelatedChildren) {
            if (upRelatedchildNode.equals(invokingChildNode) || !super.isPartOfKey(this)) continue;
            Object obtainedChildWithKey = super.obtainToGetKey(null);
            log.debug((Object)(this + " setting relation to obtained " + upRelatedchildNode + " in order to ensure a complete key"));
            this.setRelation(obtainedCurrent, obtainedChildWithKey, upRelatedchildNode.getRoleConstant());
        }
        if (invokingChildNode != null && (parentNode = this.getParentOSNode()) != null && super.isPartOfKey(this)) {
            Object obtainedParentKey = super.obtainToGetKey(this);
            this.setRelation(obtainedCurrent, obtainedParentKey, this.getParentRoleConstant());
        }
        return obtainedCurrent;
    }

    private boolean isPartOfKey(OSNode node) {
        List<Key> keys = node.getKeys();
        for (Key key : keys) {
            AttributeConstant[] attributes;
            for (AttributeConstant attributeConstant : attributes = key.getAttributes()) {
                if (!attributeConstant.isForeignAttribute()) continue;
                RoleConstant foreignAttributeRole = attributeConstant.getForeignAttributeRole();
                if (!this.getRoleConstant().equals(foreignAttributeRole)) continue;
                return true;
            }
        }
        return false;
    }

    public CheckResult checkSave(ActionType action) {
        boolean checkOK;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Check save " + this));
        }
        CheckResult csr = new CheckResult();
        Interceptor.DIRECTIVE directive = this.checkNode(CheckType.SAVE, this.getRoleConstant(), action, csr);
        boolean bl = checkOK = directive != Interceptor.DIRECTIVE.CHANGED;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check save " + this + (checkOK ? " passed" : " failed") + "."));
        }
        csr.setCheckResult(checkOK);
        return csr;
    }

    private Interceptor.DIRECTIVE checkNode(CheckType checkType, RoleConstant target, ActionType action, CheckResult csr) {
        Interceptor.DIRECTIVE directive = this.checkNodeAsParent(checkType, target, this, action, csr);
        switch (directive) {
            case CHANGED: 
            case UNCHANGED: {
                return directive;
            }
        }
        directive = this.checkSelfAndChildren(checkType, target, null, false, false, action, csr);
        return directive;
    }

    private Interceptor.DIRECTIVE checkNodeAsParent(CheckType checkType, RoleConstant target, OSNode<?> ignoredChild, ActionType action, CheckResult csr) {
        Interceptor.DIRECTIVE directive = Interceptor.DIRECTIVE.DEFAULT;
        if (this.getParent() != null) {
            OSNode parentNode = (OSNode)this.dialogController.getOSRole(this.getParent().getRoleConstant());
            directive = parentNode.checkNodeAsParent(checkType, target, this, action, csr);
        }
        switch (directive) {
            case CHANGED: 
            case UNCHANGED: {
                return directive;
            }
        }
        directive = this.checkSelfAndChildren(checkType, target, ignoredChild, true, true, action, csr);
        return directive;
    }

    private Interceptor.DIRECTIVE checkSelfAndChildren(CheckType checkType, RoleConstant target, OSNode<?> ignoreChild, boolean asUprelated, boolean selfCheck, ActionType action, CheckResult csr) {
        Interceptor.DIRECTIVE directive = Interceptor.DIRECTIVE.DEFAULT;
        if (selfCheck) {
            Interceptor interceptor;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invoking check " + (Object)((Object)checkType) + " interceptor on " + this));
            }
            if ((interceptor = this.getInterceptor(checkType)) != null) {
                directive = interceptor.intercept(target);
            }
        }
        switch (directive) {
            case CHANGED: 
            case UNCHANGED: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Interceptor stopped iteration.");
                }
                return directive;
            }
        }
        if (directive == Interceptor.DIRECTIVE.DEFAULT && selfCheck) {
            Map<ValidationResult, ValidateContext> validateResult = this.validate(action, target, ValidationPolicy.Policy.ON_SAVE);
            for (Map.Entry entry : validateResult.entrySet()) {
                ValidationResult key = (ValidationResult)entry.getKey();
                if (key.succeeded()) continue;
                csr.addValidationResult(key, (ValidateContext)entry.getValue());
            }
            if (this.hasConversionErrors()) {
                Map<DialogObjectConstant, Collection<?>> ccm = this.getConversionContextMessages();
                csr.addConversionError(ccm);
            }
        }
        if (selfCheck && log.isTraceEnabled()) {
            log.trace((Object)("Check " + (Object)((Object)checkType) + " of " + this + " done. Continuing with children."));
        }
        Collection<OSNode<?>> children = asUprelated ? this.getUpRelatedChildren() : this.getOSNodeChildren();
        if (ignoreChild != null) {
            children.remove(ignoreChild);
        }
        for (OSNode oSNode : children) {
            Interceptor.DIRECTIVE childDirective = oSNode.checkSelfAndChildren(checkType, target, null, asUprelated, true, action, csr);
            if (childDirective != Interceptor.DIRECTIVE.CHANGED) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Check " + (Object)((Object)checkType) + " of " + oSNode + " is " + (Object)((Object)childDirective)));
            }
            directive = childDirective;
            break;
        }
        return directive;
    }

    public Map<ValidationResult, ValidateContext> validate(ActionType actionType, RoleConstant actionTarget, ValidationPolicy.Policy policy) {
        ValidationManager valMngr = ValidationManagerFactory.create(actionType, this.dialogController);
        LinkedHashMap<ValidationResult, ValidateContext> results = new LinkedHashMap<ValidationResult, ValidateContext>();
        for (AttributeConstant attribute : this.getAttributeConstants()) {
            results.putAll(valMngr.validate(attribute, actionTarget, policy));
        }
        return results;
    }

    public boolean checkClose() {
        return this.checkChanged(CheckType.CLOSE, null).getCheckResult();
    }

    public CheckResult checkChanged(CheckType checkType, RoleConstant target) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Check " + (Object)((Object)checkType) + ": " + this));
        }
        boolean checkOK = true;
        Interceptor.DIRECTIVE directive = Interceptor.DIRECTIVE.DEFAULT;
        Interceptor interceptor = this.getInterceptor(checkType);
        if (interceptor != null) {
            directive = interceptor.intercept(target);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Check " + (Object)((Object)checkType) + " directive: " + (Object)((Object)directive)));
            }
        }
        CheckResult cr = new CheckResult();
        switch (directive) {
            case CHANGED: {
                cr.setCheckResult(Boolean.FALSE);
                return cr;
            }
            case UNCHANGED: {
                cr.setCheckResult(Boolean.TRUE);
                return cr;
            }
            case DEFAULT: {
                checkOK = this.isCleanOrCleared();
                Map<DialogObjectConstant, Collection<?>> convMessages = this.getConversionContextMessages();
                if (convMessages.isEmpty()) break;
                cr.addConversionError(convMessages);
                break;
            }
            case CONTINUE: {
                checkOK = true;
            }
        }
        cr.setCheckResult(checkOK);
        if (checkOK) {
            CheckResult child = this.checkChildren(checkType, target);
            cr.addConversionError(child.getConversionError());
            if (!child.getCheckResult().booleanValue()) {
                cr.setCheckResult(child.getCheckResult());
            }
        }
        return cr;
    }

    private Interceptor getInterceptor(CheckType checkType) {
        return this.interceptors.get((Object)checkType);
    }

    public void addInterceptor(CheckType checkType, Interceptor interceptor) {
        this.interceptors.put(checkType, interceptor);
    }

    CheckResult checkChildren(CheckType checkType, RoleConstant target) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cheking children of " + this));
        }
        CheckResult cr = new CheckResult();
        cr.setCheckResult(Boolean.TRUE);
        Iterator<OSNode<?>> childIterator = this.getOSNodeChildren().iterator();
        while (childIterator.hasNext() && cr.getCheckResult().booleanValue()) {
            OSNode<?> childNode = childIterator.next();
            CheckResult childResult = childNode.checkChanged(checkType, target);
            cr.addConversionError(childResult.getConversionError());
            if (childResult.getCheckResult().booleanValue()) continue;
            cr.setCheckResult(childResult.getCheckResult());
        }
        return cr;
    }

    private boolean isCleanOrCleared() {
        boolean isUnchanged;
        RoleState roleState = this.getState();
        boolean bl = isUnchanged = roleState == RoleState.CLEAN || roleState == RoleState.CLEARED;
        if (log.isTraceEnabled()) {
            String msg = "Check change - calculated state of " + this + " is: ";
            if (isUnchanged) {
                msg = msg + "un";
            }
            msg = msg + "changed.";
            log.trace((Object)msg);
        }
        return isUnchanged;
    }

    public CheckResult checkFind() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Check find: " + this));
        }
        boolean checkOK = true;
        CheckType checkType = CheckType.FIND;
        Interceptor.DIRECTIVE directive = Interceptor.DIRECTIVE.DEFAULT;
        Interceptor interceptor = this.getInterceptor(checkType);
        if (interceptor != null) {
            directive = interceptor.intercept(this.getRoleConstant());
            if (log.isTraceEnabled()) {
                log.trace((Object)("Check " + (Object)((Object)checkType) + " directive: " + (Object)((Object)directive)));
            }
        }
        CheckResult checkResult = new CheckResult();
        switch (directive) {
            case CHANGED: {
                checkResult.setCheckResult(Boolean.FALSE);
                return checkResult;
            }
            case UNCHANGED: {
                checkResult.setCheckResult(Boolean.TRUE);
                return checkResult;
            }
            case DEFAULT: {
                checkOK = this.getChangedNoKeyAttributes().isEmpty();
                Map<DialogObjectConstant, Collection<?>> convMsg = this.getConversionContextMessages();
                checkResult.addConversionError(convMsg);
                break;
            }
            case CONTINUE: {
                checkOK = true;
            }
        }
        if (log.isTraceEnabled()) {
            String msg = "Check find " + this + " is ";
            msg = checkOK ? msg + "unchanged. Continuing to check children." : msg + "changed.";
            log.trace((Object)msg);
        }
        checkOK = checkOK && this.checkChildren(CheckType.FIND, this.getRoleConstant()).getCheckResult() != false;
        checkResult.setCheckResult(checkOK);
        return checkResult;
    }

    public boolean hasConversionErrors() {
        JVineController jCtrl = JVineController.getInstance(this.dialogController);
        if (this.messageUtil.hasContextMessages(jCtrl)) {
            Collection<DialogObjectConstant> dialogObjects = this.getDialogObjects();
            for (DialogObjectConstant dialogObjectConstant : dialogObjects) {
                if (!this.messageUtil.hasContextMessages(jCtrl, dialogObjectConstant)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<DialogObjectConstant> getDialogObjects() {
        ArrayList<DialogObjectConstant> fields = new ArrayList<DialogObjectConstant>();
        AttributeConstant[] attributeConstants = this.getAttributeConstants();
        ViewModel viewModel = this.dialogController.getDialogView().getViewModel();
        for (AttributeConstant attribute : attributeConstants) {
            Collection<DialogObjectConstant> dialogObjects = viewModel.getAttributeFields(attribute);
            fields.addAll(dialogObjects);
        }
        return fields;
    }

    public Map<DialogObjectConstant, Collection<?>> getConversionContextMessages() {
        JVineController jCtrl = JVineController.getInstance(this.dialogController);
        HashMap cm = new HashMap();
        if (this.messageUtil.hasContextMessages(jCtrl)) {
            Collection<DialogObjectConstant> dialogObjects = this.getDialogObjects();
            for (DialogObjectConstant dialogObjectConstant : dialogObjects) {
                List<Object> contextMessages = this.messageUtil.getContextMessages(jCtrl, dialogObjectConstant);
                if (contextMessages == null || contextMessages.isEmpty()) continue;
                cm.put(dialogObjectConstant, contextMessages);
            }
        }
        return cm;
    }

    private RoleConstant getParentRoleConstant() {
        return this.getParent() != null ? this.getParent().getRoleConstant() : null;
    }

    private T obtainCurrent(boolean conditional) {
        Object[] create;
        Object instance;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Obtaining current " + this));
        }
        if ((instance = (create = this.conditionalCreateInstance(conditional))[0]) != null && !this.isCleanOrCleared()) {
            this.setFields(instance, (Boolean)create[1]);
        }
        this.lastObtained = instance;
        return (T)instance;
    }

    private void setFields(T instance, Boolean newObject) {
        if (newObject.booleanValue()) {
            this.setAllFields(instance);
        } else {
            this.setChangedFields(instance);
        }
    }

    private void setAllFields(T instance) {
        FieldData fieldData = this.getFieldData();
        for (Map.Entry<AttributeConstant, Object> entry : fieldData.entries()) {
            this.logSetAttribute(entry.getKey(), entry.getValue());
            this.setValue(instance, entry.getKey(), entry.getValue());
        }
    }

    private void logSetAttribute(AttributeConstant attribute, Object value) {
        if (log.isTraceEnabled()) {
            String msg = "Setting value for field : " + attribute;
            msg = msg + ", value: " + value;
            if (value != null) {
                msg = msg + ", type " + value.getClass();
            }
            log.trace((Object)msg);
        }
    }

    private void setChangedFields(T instance) {
        FieldData fieldData = this.getFieldData();
        Collection<AttributeConstant> changedAttributes = this.getChangedAttributes();
        for (AttributeConstant changedField : changedAttributes) {
            Object value = fieldData.getFieldValue(changedField);
            this.logSetAttribute(changedField, value);
            this.setValue(instance, changedField, value);
        }
    }

    public T peek() {
        T obj = this.createNewInstance();
        this.setAllFields(obj);
        return obj;
    }

    private Object[] conditionalCreateInstance(boolean conditional) {
        Object[] retVals = new Object[]{this.getCurrentInstance(), Boolean.FALSE};
        if (retVals[0] == null) {
            boolean createNew = false;
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " has no current instance."));
            }
            if (conditional) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " Checking condition..."));
                }
                createNew = this.hasValue();
                if (log.isTraceEnabled()) {
                    if (createNew) {
                        log.trace((Object)(this + " has value - creating new instance."));
                    } else {
                        log.trace((Object)(this + " has no value - no new instance " + "will be created."));
                    }
                }
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " unconditionally creating new instance."));
                }
                createNew = true;
            }
            if (createNew) {
                retVals[0] = this.createNewInstance();
                retVals[1] = Boolean.TRUE;
                this.setCurrentInstance(retVals[0]);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)(this + " has no value. No instance is created."));
            }
        }
        return retVals;
    }

    public T createNewInstance(FieldData data) {
        T instance = this.createNewInstance();
        for (Map.Entry<AttributeConstant, Object> entries : data.entries()) {
            this.setValue(instance, entries.getKey(), entries.getValue());
        }
        return instance;
    }

    public boolean matchUniqueKeys(T instanceToSearchFor, T possibleMatch, boolean failOnMissingKey) {
        Key uniqueKey;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " matching unique keys."));
        }
        if ((uniqueKey = KeyTool.getCompleteUniqueKey(instanceToSearchFor, (OSRole)this)) == null) {
            if (failOnMissingKey) {
                String msg = "Missing unique key for " + this.getRoleConstant() + ". Can't find a complete key in instance field data.";
                throw new RuntimeException(msg);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using " + uniqueKey + " as the unique key"));
        }
        return this.equalsUsingKey(uniqueKey, instanceToSearchFor, possibleMatch);
    }

    public void addChild(OSRole<?> child) {
        this.delegate.addChild(child);
    }

    public T castToType(Object obj) {
        return (T)this.delegate.castToType(obj);
    }

    public T createNewInstance() {
        return (T)this.delegate.createNewInstance();
    }

    public Map<AttributeConstant, Object> getAttributeValues(Object type) {
        return this.delegate.getAttributeValues(type);
    }

    public List<OSRole<?>> getChildren() {
        return this.delegate.getChildren();
    }

    public Collection<OSNode<?>> getOSNodeChildren() {
        ArrayList childrenOS = new ArrayList();
        List<OSRole<?>> children = this.getChildren();
        for (OSRole<?> role : children) {
            OSNode child = (OSNode)this.dialogController.getOSRole(role.getRoleConstant());
            childrenOS.add(child);
        }
        return childrenOS;
    }

    public List<OSNode<?>> getUpRelatedChildren() {
        List<OSRole<?>> allChildren = this.getChildren();
        ArrayList upRelated = new ArrayList();
        for (OSRole<?> child : allChildren) {
            if (RelationType.UP_RELATED != child.getRelationType()) continue;
            OSNode node = (OSNode)this.dialogController.getOSRole(child.getRoleConstant());
            upRelated.add(node);
        }
        return upRelated;
    }

    public OSRole<?> getChild(RoleConstant childRole) {
        return this.delegate.getChild(childRole);
    }

    public Class<T> getDomainClass() {
        return this.delegate.getDomainClass();
    }

    public Key getMainKey() {
        return this.delegate.getMainKey();
    }

    public OSRole<?> getParent() {
        return this.delegate.getParent();
    }

    private OSNode<?> getParentOSNode() {
        if (this.getParent() != null) {
            OSNode parent = (OSNode)this.dialogController.getOSRole(this.getParentRoleConstant());
            return parent;
        }
        return null;
    }

    public OSRole<?> getRoot() {
        return this.delegate.getRoot();
    }

    public RoleConstant getRoleConstant() {
        return this.delegate.getRoleConstant();
    }

    public List<Key> getKeys() {
        return this.delegate.getKeys();
    }

    public Object getValue(Object domainObject, AttributeConstant attribute) {
        return this.delegate.getValue(domainObject, attribute);
    }

    public Map<AttributeConstant, Object> getValues(Object instance, AttributeConstant[] attributes) {
        return this.delegate.getValues(instance, attributes);
    }

    public boolean isNavigableToParent() {
        return this.delegate.isNavigableToParent();
    }

    public RelationCardinality getCardinality() {
        return this.delegate.getRelationCardinality();
    }

    public boolean equalsUsingKey(Key keyToUse, Object anObject, Object anOtherObject) {
        return this.delegate.equalsUsingKey(keyToUse, anObject, anOtherObject);
    }

    public boolean isAncestorOf(RoleConstant possibleHeir) {
        return this.delegate.isAncestorOf(possibleHeir);
    }

    public boolean isRelated(AttributeConstant attribute) {
        return this.delegate.isRelated(attribute);
    }

    public boolean isUpRelated() {
        return this.delegate.isUpRelated();
    }

    public boolean isParentMany() {
        return this.delegate.isParentMany();
    }

    public boolean isPersistent() {
        return this.delegate.isPersistent();
    }

    public final RoleState getState() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " getting state"));
        }
        if (!this.stateOverride) {
            this.state = this.calculateState(this.state);
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " calculated state is: " + (Object)((Object)this.state)));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)(this + " using state override: " + (Object)((Object)this.state)));
        }
        return this.state;
    }

    public final void setState(RoleState state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " setting state to " + (Object)((Object)state)));
        }
        this.stateOverride = true;
        this.state = state;
    }

    @Override
    public boolean hasValue() {
        boolean hasValue;
        boolean bl = hasValue = this.getState() != RoleState.CLEARED;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " internal state is " + (hasValue ? "changed." : "unchanged.")));
        }
        Iterator<OSNode<?>> childIterator = this.getOSNodeChildren().iterator();
        while (!hasValue && childIterator.hasNext()) {
            OSNode<?> child = childIterator.next();
            hasValue = hasValue || child.hasValue();
        }
        return hasValue;
    }

    public final void resetState() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " resetting state override."));
        }
        this.stateOverride = false;
    }

    private RoleState calculateState(RoleState currentState) {
        boolean isChanged = this.isChanged();
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " calculating state. Currents state is " + (Object)((Object)currentState) + ". Node is " + (isChanged ? " changed." : " unchanged.")));
        }
        RoleState calculated = null;
        if (isChanged) {
            switch (currentState) {
                case CLEARED: {
                    calculated = RoleState.EDITED;
                    break;
                }
                case CLEAN: {
                    calculated = RoleState.DIRTY;
                    break;
                }
                default: {
                    calculated = currentState;
                    break;
                }
            }
        } else {
            switch (currentState) {
                case EDITED: {
                    calculated = RoleState.CLEARED;
                    break;
                }
                case DIRTY: {
                    calculated = RoleState.CLEAN;
                    break;
                }
                default: {
                    calculated = currentState;
                }
            }
        }
        return calculated;
    }

    public String toString() {
        return this.getRoleConstant().toString();
    }

    public boolean isMany() {
        return this.delegate.isMany();
    }

    public boolean isRoot() {
        return this.delegate.isRoot();
    }

    public final T getLastObtained() {
        return this.lastObtained;
    }

    public void visitBranch(Visitor<OSRole<?>> visitor) {
        this.delegate.visitBranch(visitor);
    }

    public void accept(Visitor<OSRole<?>> visitor) {
        this.delegate.accept(visitor);
    }

    public AttributeConstant getAttributeConstant(String attributeName) {
        return this.delegate.getAttributeConstant(attributeName);
    }
}

