/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.rpc.ActualParameter;
import no.g9.client.core.action.Parameter;
import no.g9.client.core.action.ParameterBinding;
import no.g9.client.core.action.RemoteServiceTarget;
import no.g9.client.core.controller.DialogController;
import no.g9.os.OSRole;

public class RoleLocator {
    public static OSNode<?>[] getNodesToCheck(DialogController dialogController, RemoteServiceTarget target) {
        Collection<OSNode<?>> extractNodes = RoleLocator.extractNodes(dialogController, target);
        List<OSNode<?>> topRoles = RoleLocator.getTopRoles(dialogController, extractNodes);
        return topRoles.toArray(new OSNode[0]);
    }

    private static Collection<OSNode<?>> extractNodes(DialogController dialogController, RemoteServiceTarget target) {
        ArrayList nodes = new ArrayList();
        JVineController ctrl = JVineController.getInstance(dialogController);
        List<ParameterBinding<?>> parameterBindings = target.getParameterBindings();
        for (ParameterBinding<?> parameterBinding : parameterBindings) {
            RoleLocator.fillNodeList(nodes, ctrl, parameterBinding);
        }
        ParameterBinding returnParameter = target.getReturnParameter();
        RoleLocator.fillNodeList(nodes, ctrl, returnParameter);
        return nodes;
    }

    private static void fillNodeList(List<OSNode<?>> nodes, JVineController ctrl, ParameterBinding<?> parameterBinding) {
        ActualParameter ap;
        Parameter<?> actualParameter = parameterBinding.getActualParameter();
        if (actualParameter instanceof ActualParameter && (ap = (ActualParameter)actualParameter).getRole() != null) {
            nodes.add(ctrl.getOSNode(ap.getRole()));
        }
    }

    private static List<OSNode<?>> getTopRoles(DialogController dialogController, Collection<OSNode<?>> roles) {
        JVineController ctrl = JVineController.getInstance(dialogController);
        HashSet allRoles = new HashSet();
        allRoles.addAll(roles);
        HashSet roots = new HashSet();
        for (OSNode<?> osNode : roles) {
            OSRole<?> oSRole = osNode.getRoot();
            roots.add(ctrl.getOSNode(oSRole.getRoleConstant()));
        }
        ArrayList found = new ArrayList();
        for (OSNode oSNode : roots) {
            found.addAll(RoleLocator.locateRole(allRoles, oSNode));
        }
        return found;
    }

    private static List<OSNode<?>> locateRole(Set<OSNode<?>> allRoles, OSNode<?> node) {
        ArrayList found = new ArrayList();
        if (allRoles.contains(node)) {
            found.add(node);
            return found;
        }
        Collection<OSNode<?>> children = node.getOSNodeChildren();
        for (OSNode<?> osNode : children) {
            List<OSNode<?>> locateRole = RoleLocator.locateRole(allRoles, osNode);
            found.addAll(locateRole);
        }
        return found;
    }
}

