/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.model.TreeNode;
import no.esito.jvine.model.TreeNodeImpl;
import no.esito.log.Logger;

public class TreeNodeSentinel
extends TreeNodeImpl<Object> {
    private static final Logger log = Logger.getLogger(TreeNodeSentinel.class);
    private final Map<OSNode<?>, Collection<?>> childInstanceMap = new HashMap();
    private final Enum<?> objectSelectionName;

    public TreeNodeSentinel(Enum<?> objectSelectionName) {
        super(null, null);
        this.objectSelectionName = objectSelectionName;
    }

    public TreeNodeSentinel() {
        this(null);
    }

    void addRootInstances(OSNode<?> osNode, Collection<?> instances) {
        LinkedHashSet tmpSet = new LinkedHashSet();
        tmpSet.addAll(instances);
        this.childInstanceMap.put(osNode, tmpSet);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " adding instances for " + osNode));
        }
    }

    @Override
    public Object getChildRelation(OSNode<?> child) {
        return this.childInstanceMap.get(child);
    }

    @Override
    public Object getCurrentInstance() {
        String msg = this + " cannot get current from sentinel.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Collection<Object> getInstances() {
        String msg = this + " cannot get instances from sentinel.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public OSNode<Object> getOSNode() {
        String msg = this + " cannot get os node from sentinel.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public TreeNode<?> getParent() {
        return null;
    }

    @Override
    public Collection<OSNode<?>> setCurrentInstance(Object current) {
        String msg = this + " cannot set current on sentinel.";
        throw new UnsupportedOperationException(msg);
    }

    void clearRootInstance(OSNode<?> rootRole) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " Removing instances of " + rootRole));
        }
        this.childInstanceMap.remove(rootRole);
    }

    @Override
    public String toString() {
        return "TreeNodeSentinel [" + this.objectSelectionName + "]";
    }
}

