/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.view;

import java.util.HashMap;
import java.util.Map;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.ViewConstant;
import no.g9.client.core.view.BooleanProperty;
import no.g9.client.core.view.EffectProperty;
import no.g9.client.core.view.Property;
import no.g9.client.core.view.PropertyManager;
import no.g9.client.core.view.StringProperty;

public final class DefaultPropertyManager
implements PropertyManager {
    private final Map<DialogObjectConstant, Map<Property<?>, Object>> dialogObjectProperties = new HashMap();

    @Override
    public final <T> void setProperty(DialogObjectConstant dialogObject, Property<T> property, T value) {
        Map<Property<?>, Object> propMap = this.dialogObjectProperties.get(dialogObject);
        if (propMap == null) {
            propMap = new HashMap();
            this.dialogObjectProperties.put(dialogObject, propMap);
        }
        propMap.put(property, value);
    }

    public final void setProperty(DialogObjectConstant dialogObject, String property, Object value) {
        StringProperty stringProperty = StringProperty.getInstance(dialogObject, property);
        this.setProperty(dialogObject, stringProperty, value);
    }

    @Override
    public final <T> T getProperty(DialogObjectConstant dialogObject, Property<T> property) {
        if (dialogObject != null && this.isRecursiveBooleanProperty(property)) {
            return (T)this.getRecursiveBooleanProperty(dialogObject, property);
        }
        return this.getPropertyInternal(dialogObject, property);
    }

    private <T> T getPropertyInternal(DialogObjectConstant dialogObject, Property<T> property) {
        Object object;
        Map<Property<?>, Object> propMap = this.dialogObjectProperties.get(dialogObject);
        if (propMap != null && (object = propMap.get(property)) != null) {
            return (T)object;
        }
        return property.getDefaultValue();
    }

    private boolean isRecursiveBooleanProperty(Property<?> property) {
        return property == BooleanProperty.ENABLED || property == BooleanProperty.SHOWN;
    }

    private Boolean getRecursiveBooleanProperty(DialogObjectConstant dialogObject, Property<Boolean> property) {
        Boolean value = this.getPropertyInternal(dialogObject, property);
        DialogObjectConstant parent = this.getParent(dialogObject);
        while (parent != null && value.booleanValue()) {
            value = this.getPropertyInternal(parent, property);
            parent = this.getParent(parent);
        }
        return value;
    }

    private DialogObjectConstant getParent(DialogObjectConstant dialogObject) {
        ViewConstant parent = dialogObject.getParent();
        if (parent instanceof DialogObjectConstant) {
            return (DialogObjectConstant)parent;
        }
        return null;
    }

    public final Object getProperty(DialogObjectConstant dialogObject, String property) {
        StringProperty stringProperty = StringProperty.getInstance(dialogObject, property);
        return this.getProperty(dialogObject, stringProperty);
    }

    @Override
    public final boolean isPropertySet(DialogObjectConstant dialogObject, Property<?> property) {
        Map<Property<?>, Object> propMap = this.dialogObjectProperties.get(dialogObject);
        if (propMap != null) {
            return propMap.containsKey(property);
        }
        return false;
    }

    public final boolean isPropertySet(DialogObjectConstant dialogObject, String property) {
        StringProperty stringProperty = StringProperty.getInstance(dialogObject, property);
        return this.isPropertySet(dialogObject, stringProperty);
    }

    @Override
    public final void clearAll() {
        this.dialogObjectProperties.clear();
    }

    @Override
    public final void clearAll(DialogObjectConstant dialogConstant) {
        this.dialogObjectProperties.remove(dialogConstant);
    }

    @Override
    public final void clear(DialogObjectConstant dialogObject, Property<?> property) {
        Map<Property<?>, Object> propMap = this.dialogObjectProperties.get(dialogObject);
        if (propMap != null) {
            propMap.remove(property);
        }
    }

    public final void setEditable(DialogObjectConstant dialogObject, boolean editable) {
        this.setProperty(dialogObject, BooleanProperty.EDITABLE, editable);
    }

    public final boolean isEditable(DialogObjectConstant dialogObject) {
        Boolean property = this.getProperty(dialogObject, BooleanProperty.EDITABLE);
        return property;
    }

    public final void setEnabled(DialogObjectConstant dialogObject, boolean enabled) {
        this.setProperty(dialogObject, BooleanProperty.ENABLED, enabled);
    }

    public final boolean isEnabled(DialogObjectConstant dialogObject) {
        Boolean property = this.getProperty(dialogObject, BooleanProperty.ENABLED);
        return property;
    }

    public final void setMandatory(DialogObjectConstant dialogObject, boolean mandatory) {
        this.setProperty(dialogObject, BooleanProperty.MANDATORY, mandatory);
    }

    public final boolean getMandatory(DialogObjectConstant dialogObject) {
        return this.getProperty(dialogObject, BooleanProperty.MANDATORY);
    }

    public final boolean isMandatory(DialogObjectConstant dialogObject) {
        return this.getProperty(dialogObject, BooleanProperty.MANDATORY);
    }

    public final void setShown(DialogObjectConstant dialogObject, boolean shown) {
        this.setProperty(dialogObject, BooleanProperty.SHOWN, shown);
    }

    public final boolean isExpanded(DialogObjectConstant dialogObject) {
        return this.getProperty(dialogObject, BooleanProperty.EXPANDED);
    }

    public final void setExpanded(DialogObjectConstant dialogObject, boolean expanded) {
        this.setProperty(dialogObject, BooleanProperty.EXPANDED, expanded);
    }

    public final boolean isShown(DialogObjectConstant dialogObject) {
        return this.getProperty(dialogObject, BooleanProperty.SHOWN);
    }

    public final void setEffect(DialogObjectConstant dialogObject, Object effect) {
        this.setProperty(dialogObject, EffectProperty.STD_EFFECT, effect);
    }

    public final Object getEffect(DialogObjectConstant dialogObject) {
        return this.getProperty(dialogObject, EffectProperty.STD_EFFECT);
    }

    @Override
    public final String listProperties(DialogObjectConstant dialogObject) {
        Map<Property<?>, Object> propMap = this.dialogObjectProperties.get(dialogObject);
        return propMap != null ? propMap.toString() : "<none>";
    }

    @Override
    public final String listProperties() {
        String s = "[";
        for (DialogObjectConstant dialogObject : this.dialogObjectProperties.keySet()) {
            s = s + dialogObject + ": ";
            s = s + this.listProperties(dialogObject) + ", ";
        }
        s = s.substring(0, s.lastIndexOf(44));
        s = s + "]";
        return s;
    }

    public String toString() {
        return DefaultPropertyManager.class.getSimpleName() + ", # properties: " + this.dialogObjectProperties.size();
    }
}

