/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;
import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.g9.client.core.action.ActionStage;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.Checkable;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.action.ThreadType;
import no.g9.support.ActionType;

class Checking<V>
extends ActionStage<V>
implements Callable<Void> {
    Checking(G9Action<V> g9Action) {
        super(g9Action);
    }

    Boolean checked(final Boolean checkResult) throws Exception {
        if (this.ga.shouldInvokeHook() && !this.ga.getCheckableHooks().isEmpty()) {
            String methodName = "checked";
            Class[] params = new Class[]{Boolean.class};
            ThreadType threadType = this.ga.getThreadType(methodName, params);
            HookMethod<Boolean> checkHook = new HookMethod<Boolean>(methodName){

                @Override
                public Boolean call() throws Exception {
                    boolean result = checkResult;
                    for (Checkable hook : Checking.this.ga.getCheckableHooks()) {
                        result = hook.checked(result);
                    }
                    return result;
                }
            };
            return this.ga.getHookInvoker().execute(this.ga.getApplicationController(), threadType, checkHook);
        }
        return checkResult;
    }

    @Override
    public Void call() throws Exception {
        ActionType checkActionType = this.getCheckActionType();
        ActionTask<Boolean> checkActionTask = JVineController.getInstance(this.ga.getController()).getCheckDialogTask(checkActionType, this.ga.getActionTarget());
        checkActionTask.FLAG = this.ga.getFlag();
        Boolean checkResult = (Boolean)checkActionTask.call();
        if (checkResult == null) {
            checkResult = Boolean.FALSE;
            G9Action.getLog().info((Object)(this.ga + " check action failed. " + "Using default value false"));
        }
        if (!this.checked(checkResult).booleanValue()) {
            this.ga.cancel();
        }
        G9Action.getLog().info((Object)(this.ga + " checked"));
        return null;
    }

    private ActionType getCheckActionType() {
        switch (this.ga.getActionType()) {
            case FIND: 
            case FINDALL: 
            case INVOKE: {
                return ActionType.CHECK_FIND;
            }
            case INSERT: {
                return ActionType.INSERT;
            }
            case UPDATE: {
                return ActionType.UPDATE;
            }
            case SAVE: {
                return ActionType.SAVE;
            }
            case DELETE: {
                return ActionType.CHECK_DELETE;
            }
            case CLOSE: {
                return ActionType.CHECK_CLOSE;
            }
            case SELECT: {
                return ActionType.SELECT;
            }
            case UNSELECT: {
                return ActionType.UNSELECT;
            }
            case CLEAR: {
                return ActionType.CHECK_CLEAR;
            }
            case OPEN: {
                return ActionType.OPEN;
            }
        }
        return null;
    }
}

