/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.HashMap;
import java.util.Map;

public final class PaginatorEvent {
    private static Map<String, NavigationButton> descrToButton = new HashMap<String, NavigationButton>();
    private final int currentPage;
    private final NavigationButton navigationButton;
    private final Object sourceEvent;
    private final int pageCount;
    private final int maxPages;

    public static NavigationButton getNavigationButton(String buttonDescription) {
        return descrToButton.get(buttonDescription);
    }

    public PaginatorEvent(NavigationButton navigationButton, int currentPage, int pageCount, int maxPages, Object sourceEvent) {
        this.navigationButton = navigationButton;
        this.currentPage = currentPage;
        this.pageCount = pageCount;
        this.maxPages = maxPages;
        this.sourceEvent = sourceEvent;
    }

    public PaginatorEvent(String navigationButton, int currentPage, int pageCount, int maxPages, Object sourceEvent) {
        this(PaginatorEvent.getNavigationButton(navigationButton), currentPage, pageCount, maxPages, sourceEvent);
    }

    public Object getSourceEvent() {
        return this.sourceEvent;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public NavigationButton getNavigationButton() {
        return this.navigationButton;
    }

    public String toString() {
        return "PaginatorEvent [currentPage=" + this.currentPage + ", navigationButton=" + (Object)((Object)this.navigationButton) + ", sourceEvent=" + this.sourceEvent + "]";
    }

    static {
        descrToButton.put("next", NavigationButton.NEXT_PAGE);
        descrToButton.put("fastf", NavigationButton.FAST_FORWARD);
        descrToButton.put("last", NavigationButton.LAST_PAGE);
        descrToButton.put("previous", NavigationButton.PREVOIOUS_PAGE);
        descrToButton.put("fastr", NavigationButton.FAST_BACKWARDS);
        descrToButton.put("first", NavigationButton.FIRST_PAGE);
    }

    public static enum NavigationButton {
        NEXT_PAGE,
        FAST_FORWARD,
        LAST_PAGE,
        PREVOIOUS_PAGE,
        FAST_BACKWARDS,
        FIRST_PAGE;

    }
}

