/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.esito.jvine.action.ThreadManager;
import no.esito.jvine.communication.ActionMessageCompilation;
import no.esito.jvine.communication.CallBackWrapper;
import no.esito.jvine.communication.ExternalDialogCallBackValue;
import no.esito.jvine.communication.SystemMessagePipe;
import no.esito.jvine.communication.SystemMessageUtils;
import no.esito.jvine.controller.DialogInteractionBroker;
import no.esito.jvine.controller.JVineAppController;
import no.esito.jvine.controller.JVineApplicationController;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.ActionFactory;
import no.g9.client.core.action.ActionHook;
import no.g9.client.core.action.ActionHookList;
import no.g9.client.core.action.EventContext;
import no.g9.client.core.communication.CommunicationError;
import no.g9.client.core.communication.G9ActionPayload;
import no.g9.client.core.communication.MessageReceiver;
import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.communication.SystemMessageContext;
import no.g9.client.core.controller.CallBack;
import no.g9.client.core.controller.DialogCallBackValue;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogInstanceManager;
import no.g9.client.core.controller.ExternalDialogConstant;
import no.g9.client.core.view.ApplicationView;
import no.g9.client.core.view.DialogView;
import no.g9.client.core.view.ViewModel;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageReply;
import no.g9.message.MessageReplyType;
import no.g9.message.MessageSystem;
import no.g9.service.G9Spring;
import no.g9.service.JGrapeService;
import no.g9.support.ActionType;
import no.g9.support.ClientContext;
import no.g9.support.action.ActionTarget;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.StringUtils;

public abstract class ApplicationController
extends JVineApplicationController
implements SystemMessagePipe {
    private final ClientContext clientContext;
    private JGrapeService serviceProxy;
    private final String applicationName;
    private ApplicationView applicationView;
    private final ActionFactory actionFactory = new ActionFactory();
    private final Logger log = Logger.getLogger(ApplicationController.class);
    private DialogInstanceManager dialogInstanceManager = null;
    private Map<String, CallBackWrapper> pendingCallBacks = new HashMap<String, CallBackWrapper>();

    protected DialogInstanceManager getDialogInstanceManager() {
        return this.dialogInstanceManager;
    }

    public ApplicationController(String applicationName) {
        this.clientContext = new ClientContext();
        this.clientContext.setApplicationName(applicationName);
        this.applicationName = applicationName;
        this.dialogInstanceManager = new DialogInstanceManager(this);
    }

    public final synchronized <T extends DialogConstant> T getDialogConst(String dialogInternalName) {
        return (T)this.dialogInstanceManager.getDialogConstant(dialogInternalName);
    }

    public final DialogInstance getCurrentDialogInstance(DialogConstant dialogConstant) {
        return this.dialogInstanceManager.getCurrentDialogInstance(dialogConstant);
    }

    public final DialogController setActiveDialogInstance(DialogInstance dialogInstanceKey) {
        return this.dialogInstanceManager.setActiveDialogInstance(dialogInstanceKey);
    }

    public void removeDialogInstance(DialogInstance dialogInstance) {
        this.dialogInstanceManager.removeDialogInstance(dialogInstance);
    }

    public synchronized boolean closeDialogInstance(DialogInstance dialogInstance) {
        DialogController dialogController = this.dialogInstanceManager.getDialogController(dialogInstance);
        boolean checkClose = JVineController.getInstance(dialogController).checkClose();
        if (!checkClose) {
            String msgID = "-1608";
            String dialogTitle = this.getApplicationView().getDialogTitle(dialogInstance);
            MessageReply reply = dialogController.dispatchMessage(msgID, dialogTitle);
            checkClose = MessageReplyType.REPLY_OK.equals((Object)reply);
        }
        if (checkClose) {
            AbstractApplicationView applicationView = (AbstractApplicationView)this.getApplicationView();
            applicationView.removeInstance(dialogInstance);
            return true;
        }
        return false;
    }

    public boolean hasAvailableDialogInstance(DialogConstant dialogConstant) {
        return this.dialogInstanceManager.hasAvailableDialogInstance(dialogConstant);
    }

    public List<DialogInstance> getActiveDialogInstances(DialogConstant dialogConstant) {
        return this.dialogInstanceManager.getActiveDialogInstances(dialogConstant);
    }

    public List<DialogInstance> getOpenDialogInstanceList(DialogConstant dialogConstant) {
        return this.dialogInstanceManager.getOpenDialogList(dialogConstant);
    }

    public List<DialogController> getOpenDialogs() {
        return this.dialogInstanceManager.getOpenDialogList();
    }

    public void registerController(int instanceNumber, DialogController newController) {
        this.dialogInstanceManager.registerController(instanceNumber, newController);
    }

    public final synchronized <T extends DialogController> T getDialogController(DialogConstant dialogConstant) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting current dialog controller for: " + dialogConstant));
        }
        return this.dialogInstanceManager.getDialogController(dialogConstant);
    }

    public final synchronized <T extends DialogController> T getDialogController(DialogInstance dialogInstance) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting dialog controller for: " + dialogInstance));
        }
        return (T)this.dialogInstanceManager.getDialogController(dialogInstance);
    }

    public DialogInstance createDialogInstance(DialogConstant dialogConstant, int instanceNumber) {
        return this.dialogInstanceManager.createDialogInstance(dialogConstant, instanceNumber);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationId() {
        return StringUtils.uncapitalize((String)this.getApplicationName());
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public synchronized JGrapeService getServiceProxy() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Getting JGrapeService");
        }
        if (this.serviceProxy == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Creating a new instance of JGrapeService");
            }
            this.serviceProxy = (JGrapeService)ServiceLoader.getService(JGrapeService.class);
        }
        return this.serviceProxy;
    }

    public final ApplicationView getApplicationView() {
        return this.applicationView;
    }

    public final <T extends DialogView> T getDialogView(DialogConstant dialogConstant) {
        return this.getApplicationView().getDialogView(dialogConstant);
    }

    public final void setApplicationView(ApplicationView applicationView) {
        this.applicationView = applicationView;
    }

    public final void performAction(ActionType action, DialogConstant target, boolean flag) {
        if (target instanceof ExternalDialogConstant) {
            this.performExternalAction(action, target);
        } else {
            this.handleCloseAction(action, target);
            this.getApplicationView().performAction(action, target, flag);
        }
    }

    public final void performActionFromExternal(ActionType action, DialogConstant target, boolean flag) {
        if (target instanceof ExternalDialogConstant) {
            this.performExternalAction(action, target);
        } else {
            this.handleCloseAction(action, target);
            ((AbstractApplicationView)this.getApplicationView()).performAction(action, target, flag, true);
        }
    }

    private void handleCloseAction(ActionType action, DialogConstant target) {
        if (action == ActionType.CLOSE) {
            Object dialogController = this.getDialogController(target);
            JVineController.getInstance(dialogController).closeDialogController();
            this.getApplicationView().performAction(ActionType.CLEAROBJECT, target, false);
        }
    }

    private void performExternalAction(ActionType action, DialogConstant target) {
        G9ActionPayload actionPayload = new G9ActionPayload(action, "");
        if (actionPayload.isValid) {
            SystemMessage message = SystemMessageUtils.createSystemMessage("", target, actionPayload.code());
            ExternalDialogConstant externalTarget = (ExternalDialogConstant)target;
            ActionMessageCompilation actionMessageCompilation = new ActionMessageCompilation(message, actionPayload, this);
            externalTarget.setReactor(actionMessageCompilation);
        }
    }

    public final void performAction(ActionType action, DialogConstant target) {
        this.performAction(action, target, false);
    }

    public final void registerHook(ActionTarget actionTarget, ActionType actionType, ActionHook<?> hook) {
        this.actionFactory.registerHook(actionTarget, actionType, hook);
    }

    protected final ActionHookList<?> getActionHookList(ActionTarget actionTarget, ActionType actionType) {
        return this.actionFactory.getActionHookList(actionTarget, actionType);
    }

    public final ViewModel getViewModel(DialogConstant dialog) {
        return this.getApplicationView().getViewModel(dialog);
    }

    final ViewModel getViewModel(DialogInstance instance) {
        AbstractApplicationView appView = (AbstractApplicationView)this.getApplicationView();
        return appView.getViewModel(instance);
    }

    public final void invokeOnGui(Runnable task) throws InvocationTargetException {
        if (ThreadManager.isWorkerThread()) {
            JVineAppController.getInstance(this).getActionQueue().perform(task);
        } else {
            task.run();
        }
    }

    public abstract <T extends DialogConstant> T getApplicationDialogConstant();

    public void forward(String codedMessage) {
        SystemMessage decodedMessage = new SystemMessage(codedMessage);
        this.forward(decodedMessage);
    }

    @Override
    public void forward(SystemMessage decodedMessage) {
        if (this.getApplicationName().equalsIgnoreCase(decodedMessage.receiver)) {
            HashMap handlers;
            try {
                handlers = (HashMap)G9Spring.getBean((String)"gva.ports.userdefined");
            }
            catch (Exception e) {
                handlers = new HashMap();
            }
            MessageReceiver handler = (MessageReceiver)handlers.get(decodedMessage.port);
            if (handler != null) {
                final ApplicationController thisApplicationController = this;
                handler.receive(decodedMessage, new SystemMessageContext(){

                    @Override
                    public ApplicationController getApplicationController() {
                        return thisApplicationController;
                    }
                });
                return;
            }
            if ("_call_back".equals(decodedMessage.port)) {
                this.dispatchCallBack(decodedMessage);
                return;
            }
            if ("_error_handler".equals(decodedMessage.port)) {
                CommunicationError communicationError = new CommunicationError(decodedMessage.payload);
                this.handleCommunicationError(communicationError);
                return;
            }
            try {
                Object dialogConstant = this.getDialogConst(decodedMessage.port);
                if (dialogConstant != null) {
                    this.forwardToDialog(decodedMessage, (DialogConstant)dialogConstant);
                    return;
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        } else {
            this.forwardToExternal(decodedMessage);
            return;
        }
        this.log.info((Object)("No handler for message \"" + decodedMessage.code() + "\". Ignoring it."));
    }

    public void handleCommunicationError(CommunicationError commErr) {
        Object[] args = new Object[]{commErr.failingMessage.code(), commErr.statusCode, commErr.description};
        Message msg = MessageSystem.getMessageFactory().getMessage("-2201", args);
        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
        this.forwardToExternal(SystemMessage.ALERT_TEMPLATE.payload(msg.getMessageText()));
    }

    public String addCallBack(DialogController actionInvoker, DialogConstant callee, CallBack callBack) {
        String key = actionInvoker.getDialogConstant().getInternalName() + "_" + actionInvoker.getDialogInstanceNumber();
        this.pendingCallBacks.put(key, new CallBackWrapper(actionInvoker.getDialogConstant(), callee, callBack));
        return key;
    }

    private void dispatchCallBack(SystemMessage callBackMessage) {
        SystemMessage tmpMsg = new SystemMessage(callBackMessage.payload);
        String key = tmpMsg.receiver;
        CallBackWrapper wrapper = this.pendingCallBacks.remove(key);
        if (wrapper != null) {
            Object caller = this.getDialogController(wrapper.actionInvoker);
            DialogConstant callee = wrapper.callee;
            ExternalDialogCallBackValue ecbValue = ExternalDialogCallBackValue.fromJson(tmpMsg.payload);
            DialogCallBackValue callBackValue = ecbValue.asDialogCallBackValue();
            Object applicationDialogConstant = this.getApplicationDialogConstant();
            callBackValue.setSource((DialogController)this.getDialogController((DialogConstant)applicationDialogConstant));
            DialogInteractionBroker broker = DialogInteractionBroker.getInstance();
            DialogCallBackValue returnValue = broker.doCallback(callBackValue, (DialogController)caller, callee);
            if (wrapper.callBack != null) {
                wrapper.callBack.callBack(returnValue);
            }
        }
    }

    public CallBack getExternalCallBack(final SystemMessage callBackMessage) {
        return new CallBack(){

            @Override
            public void callBack(DialogCallBackValue callBackValue) {
                String cbPayload = ExternalDialogCallBackValue.toJson(new ExternalDialogCallBackValue(callBackValue));
                SystemMessage forwardMessage = callBackMessage.payload(callBackMessage.payload + "//" + cbPayload);
                if (ApplicationController.this.log.isTraceEnabled()) {
                    ApplicationController.this.log.trace((Object)("External call back, message: " + forwardMessage));
                }
                ApplicationController.this.forwardToExternal(forwardMessage);
            }
        };
    }

    protected void forwardToDialog(SystemMessage decodedMessage, DialogConstant dialogConstant) {
        EventContext eventMethod = new EventContext("_perform_message_action", "", decodedMessage);
        Object applicationDialogConstant = this.getApplicationDialogConstant();
        Object applicationDialog = this.getDialogController((DialogConstant)applicationDialogConstant);
        JVineController.getInstance(applicationDialog).dispatch(eventMethod);
    }

    protected void forwardToExternal(SystemMessage decodedMessage) {
        ((AbstractApplicationView)this.getApplicationView()).forward(decodedMessage);
    }

    public static final ApplicationController getCurrentApplicationController() {
        return JVineApplicationController.getCurrentApplicationController();
    }
}

