/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import no.esito.jvine.controller.DialogInstanceKey;
import no.esito.jvine.controller.DialogInteractionBroker;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.controller.StateController;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.log.Logger;
import no.g9.client.core.action.ActionHook;
import no.g9.client.core.action.ActionHookList;
import no.g9.client.core.action.CheckType;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.CallBack;
import no.g9.client.core.controller.DialogCallBackValue;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.DialogSetupValue;
import no.g9.client.core.controller.Interceptor;
import no.g9.client.core.controller.RoleState;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationPolicy;
import no.g9.client.core.validator.ValidationResult;
import no.g9.client.core.view.DialogView;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.table.TableModel;
import no.g9.client.spreadsheet.SpreadsheetExporter;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageDispatcher;
import no.g9.message.MessageReply;
import no.g9.message.MessageSystem;
import no.g9.os.AttributeConstant;
import no.g9.os.OSRole;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.Visitor;
import no.g9.support.action.ActionTarget;

public abstract class DialogController
extends StateController {
    private static final Logger log = Logger.getLogger(DialogController.class);
    private ApplicationController applicationController;
    private CallBack callBack;
    private DialogSetupValue<?> setupValue;
    private SpreadsheetExporter spreadsheetExporter;
    private final JVineController jController;
    public final String dialogName;

    public DialogController(String dialogName, ApplicationController applicationController) {
        super(dialogName);
        if (dialogName == null) {
            throw new IllegalArgumentException("Dialog name can not be null");
        }
        this.dialogName = dialogName;
        this.applicationController = applicationController;
        this.jController = JVineController.getInstance(this);
    }

    public final Collection<AttributeConstant> getChangedAttributes(RoleConstant role) {
        return this.getViewModel().getChangedAttributes(role);
    }

    public final void setFieldValue(AttributeConstant attribute, Object value) {
        for (DialogObjectConstant doc : this.getViewModel().getAttributeFields(attribute)) {
            this.setFieldValue(doc, value);
        }
    }

    public final void setFieldValue(AttributeConstant attribute, Object value, boolean changed) {
        for (DialogObjectConstant doc : this.getViewModel().getAttributeFields(attribute)) {
            this.setFieldValue(doc, value, changed);
        }
    }

    final void setApplicationController(ApplicationController applicationController) {
        this.applicationController = applicationController;
        this.init();
    }

    public void init() {
    }

    public void setup(DialogSetupValue<?> setupValue) {
    }

    public final synchronized <T extends DialogView> T getDialogView() {
        return JVineController.getInstance(this).getDialogView();
    }

    @Override
    public final synchronized ViewModel getViewModel() {
        DialogInstanceKey instance = new DialogInstanceKey(this.getDialogConstant(), this.getDialogInstanceNumber());
        return this.getApplicationController().getViewModel(instance);
    }

    public final <T extends OSRole<?>> T getOSRole(RoleConstant role) {
        return (T)this.jController.getOSNode(role);
    }

    public final <T> T getFieldValue(DialogObjectConstant dataItem) {
        return (T)this.getViewModel().getFieldValue(dataItem);
    }

    public final <T> T getFieldValue(AttributeConstant attribute) {
        Iterator<DialogObjectConstant> iterator = this.getViewModel().getAttributeFields(attribute).iterator();
        if (iterator.hasNext()) {
            DialogObjectConstant doc = iterator.next();
            return this.getFieldValue(doc);
        }
        String msg = "Missing dialog object for attribute " + attribute;
        throw new IllegalArgumentException(msg);
    }

    public final void setFieldValue(DialogObjectConstant field, Object value) {
        this.getViewModel().setFieldValue(field, value);
    }

    public final void setFieldValue(DialogObjectConstant field, Object fieldValue, boolean changed) {
        this.getViewModel().setFieldValue(field, fieldValue);
        this.getViewModel().setChanged(field, changed);
    }

    public String toString() {
        return "DialogController: " + this.dialogName;
    }

    public final void registerHook(ActionTarget actionTarget, ActionType actionType, ActionHook<?> hook) {
        this.jController.getActionFactory().registerHook(actionTarget, actionType, hook);
    }

    public ActionHookList<?> getActionHookList(ActionTarget actionTarget, ActionType actionType) {
        return this.jController.getActionFactory().getActionHookList(actionTarget, actionType);
    }

    public final void clear(RoleConstant role, boolean intercept) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " clearing role: " + role));
        }
        Collection<OSNode<?>> cleared = this.jController.getOSNode(role).clear(intercept);
        Collection<OSNode<?>> includeNodes = this.jController.getOneRelatedChildren(role);
        includeNodes.add(this.jController.getOSNode(role));
        this.jController.reportToView(cleared, includeNodes, null);
    }

    public final void clearCurrent(RoleConstant role, boolean intercept) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " clearing current of role: " + role));
            Collection<OSNode<?>> cleared = this.jController.getOSNode(role).clearCurrent(intercept);
            Collection<OSNode<?>> includeNodes = this.jController.getOneRelatedChildren(role);
            includeNodes.add(this.jController.getOSNode(role));
            this.jController.reportToView(cleared, includeNodes, null);
        }
    }

    public final void clearKeepKeys(RoleConstant role) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " clear keep keys for role: " + role));
        }
        Collection<OSNode<?>> cleared = this.jController.getOSNode(role).clearKeepKeys();
        Collection<OSNode<?>> oneRelatedChildren = this.jController.getOneRelatedChildren(role);
        this.jController.reportToView(cleared, oneRelatedChildren, null);
    }

    @Override
    public final ApplicationController getApplicationController() {
        return this.applicationController;
    }

    public final void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    public DialogSetupValue<?> getSetupValue() {
        return this.setupValue;
    }

    public void setSetupValue(DialogSetupValue<?> setupValue) {
        this.setupValue = setupValue;
    }

    public final boolean isChanged(RoleConstant role) {
        boolean isChanged;
        ViewModel viewModel = this.getViewModel();
        boolean bl = isChanged = !viewModel.getChangedAttributes(role).isEmpty();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Changed attributes of " + role + " are: " + viewModel.getChangedAttributes(role)));
        }
        return isChanged;
    }

    public final boolean hasConversionErrors(RoleConstant role) {
        return this.jController.getOSNode(role).hasConversionErrors();
    }

    public final Map<DialogObjectConstant, Collection<?>> getConversionMessages(RoleConstant role) {
        return this.jController.getOSNode(role).getConversionContextMessages();
    }

    public abstract String getObjectSelectionName();

    public abstract List<RoleConstant> getRoleConstants();

    public abstract <T extends RoleConstant> T getOSConst(String var1);

    public final void doCallBack(Object value) {
        this.doCallBack(value, null);
    }

    public final void doCallBack(DialogCallBackValue callBackValue) {
        JVineController jCtrl = JVineController.getInstance(this);
        DialogController caller = jCtrl.getCaller();
        DialogInteractionBroker broker = DialogInteractionBroker.getInstance();
        DialogCallBackValue returnValue = broker.doCallback(callBackValue, caller, this.getDialogConstant());
        if (this.callBack != null) {
            this.callBack.callBack(returnValue);
        }
        jCtrl.setCaller(null);
        this.callBack = null;
    }

    public final void doCallBack(Object value, Integer opCode) {
        DialogCallBackValue callBackValue = new DialogCallBackValue(this, value, opCode);
        this.doCallBack(callBackValue);
    }

    public final void registerInterceptor(CheckType checkType, Interceptor interceptor) {
        OSNode node = this.jController.getOSNode(interceptor.getRole());
        node.addInterceptor(checkType, interceptor);
    }

    public final boolean checkChange(RoleConstant role, CheckType checkType) {
        OSNode node = this.jController.getOSNode(role);
        return node.checkChanged(checkType, role).getCheckResult();
    }

    public final <T> T peek(RoleConstant role) {
        Object instance = this.jController.getOSNode(role).peek();
        this.jController.checkValidationAndConvert(true);
        return instance;
    }

    public final void display(RoleConstant role, Object instance) {
        this.display(role, instance, false);
    }

    public final <T> Collection<T> getAllInstances(RoleConstant role) {
        OSNode node = this.jController.getOSNode(role);
        return this.jController.getAllInstances(node);
    }

    public final void display(RoleConstant role, Object instance, boolean changed) {
        Collection<DialogObjectConstant> roleFields = this.getViewModel().getRoleFields(role);
        for (DialogObjectConstant field : roleFields) {
            AttributeConstant attribute = field.getAttribute();
            Object value = this.getOSRole(role).getValue(instance, attribute);
            this.setFieldValue(field, value, changed);
        }
    }

    public final void setCurrentInstance(RoleConstant role, Object instance) {
        OSNode node = this.jController.getOSNode(role);
        Collection<OSNode<?>> changedNodes = node.setCurrentInstance(instance);
        ArrayList includeNodes = new ArrayList();
        includeNodes.add(node);
        this.jController.reportToView(changedNodes, includeNodes, null);
    }

    public final <T> void setCurrentInstances(RoleConstant role, Collection<T> instances) {
        OSNode node = this.jController.getOSNode(role);
        Collection<OSNode<?>> changedNodes = node.setCurrentInstances(instances);
        ArrayList includeNodes = new ArrayList();
        includeNodes.add(node);
        this.jController.reportToView(changedNodes, includeNodes, null);
        TableModel tableModel = this.getDialogView().getViewModel().getTableModel(role);
        if (tableModel != null) {
            tableModel.filterTableView();
            tableModel.sortTableView();
        }
    }

    public final <T> T getCurrentInstance(RoleConstant role) {
        OSNode node = this.jController.getOSNode(role);
        return node.getCurrentInstance();
    }

    public final RoleState getState(RoleConstant role) {
        return this.jController.getOSNode(role).getState();
    }

    public final void setState(RoleConstant role, RoleState state) {
        this.jController.getOSNode(role).setState(state);
    }

    public final String getRoleStates() {
        return new RoleStateVisitor().getRoleStates();
    }

    public final void invokeOnGui(Runnable guiMethod) throws InvocationTargetException {
        this.jController.invokeOnGui(guiMethod);
    }

    public final <V> V invokeOnGui(Callable<V> guiMethod) throws InvocationTargetException {
        return this.jController.invokeOnGui(guiMethod);
    }

    public final Map<ValidationResult, ValidateContext> validate(RoleConstant osRole, ValidationPolicy.Policy validationPolicy) {
        OSNode osNode = this.jController.getOSNode(osRole);
        return osNode.validate(null, null, validationPolicy);
    }

    public Map<ValidationResult, ValidateContext> failedOnChangeValidator(Map<ValidationResult, ValidateContext> failedResult) {
        return failedResult;
    }

    public DispatcherContext getDispatcherContext() {
        AbstractApplicationView appView = (AbstractApplicationView)this.getApplicationController().getApplicationView();
        return appView.getDispatcherContext();
    }

    @Override
    public MessageDispatcher getMessageDispatcher() {
        return MessageSystem.getMessageDispatcher((DispatcherContext)this.getDispatcherContext());
    }

    public MessageReply dispatchMessage(String messageID, Object ... args) {
        return this.getMessageDispatcher().dispatch(messageID, args);
    }

    public MessageReply dispatchMessage(Message message) {
        return this.getMessageDispatcher().dispatch(message);
    }

    public MessageReply dispatchMessage(String messageID, Throwable exception, Object ... args) {
        return this.getMessageDispatcher().dispatch(messageID, exception, args);
    }

    public abstract Map<RoleConstant, OSRole<?>> getRoleMap();

    public SpreadsheetExporter getSpreadsheetExporter() {
        return this.spreadsheetExporter;
    }

    public void setSpreadsheetExporter(SpreadsheetExporter spreadsheetExporter) {
        this.spreadsheetExporter = spreadsheetExporter;
    }

    private class RoleStateVisitor
    implements Visitor<OSRole<?>> {
        private String result = "";

        private RoleStateVisitor() {
        }

        public void visit(OSRole<?> visitable) {
            RoleConstant roleConstant = visitable.getRoleConstant();
            RoleState state = DialogController.this.getState(roleConstant);
            this.result = this.result + visitable.toString() + ": " + (Object)((Object)state) + ", " + DialogController.this.getChangedAttributes(roleConstant) + "\n";
        }

        String getRoleStates() {
            OSNode<?>[] rootNodes;
            for (OSNode<?> node : rootNodes = DialogController.this.jController.getRootNodes()) {
                node.visitBranch(this);
            }
            int lastNewLine = this.result.lastIndexOf("\n");
            return this.result.substring(0, lastNewLine);
        }
    }
}

