/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import no.esito.jvine.action.ActionMethodRunner;
import no.esito.jvine.controller.DialogInstanceKey;
import no.esito.jvine.controller.DialogKey;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.StateController;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.InstanceNumberOutOfBoundsException;
import no.g9.service.G9Spring;
import org.springframework.util.Assert;

public class DialogInstanceManager {
    private static final String CONTROLLER = "Controller";
    private static final String CONSTANT = "Constant";
    private Logger log = Logger.getLogger(DialogInstanceManager.class);
    private ApplicationController applicationController;
    private Map<DialogKey, Stack<DialogController>> dialogMap = Collections.synchronizedMap(new HashMap());
    private Map<DialogKey, List<DialogController>> dialogLists = Collections.synchronizedMap(new HashMap());

    public DialogInstanceManager(ApplicationController applicationController) {
        Assert.notNull((Object)applicationController, (String)"applicationController must not be null");
        this.applicationController = applicationController;
    }

    synchronized <T extends DialogController> T createDialogControllerInternal(String beanID) {
        DialogController dialogController = this.getDialogControllerBeanInternal(beanID);
        return (T)dialogController;
    }

    synchronized <T extends DialogController> T getDialogController(DialogConstant dialogConstant) {
        DialogController firstController;
        Stack<DialogController> dcStack = this.dialogMap.get(new DialogKey(dialogConstant));
        if (dcStack != null && !dcStack.isEmpty() && (firstController = dcStack.peek()) != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Got first controller from stack, instance " + firstController.getDialogInstanceNumber() + " of " + dialogConstant.getInternalName() + ", g9Name " + dialogConstant.getG9Name()));
            }
            return (T)firstController;
        }
        DialogController newController = this.createAndRegisterDialogController(dialogConstant.getInternalName(), 1);
        return (T)newController;
    }

    synchronized <T extends DialogController> T createDialogController(DialogConstant dialogConstant) {
        return this.createDialogController(dialogConstant, -1);
    }

    private synchronized <T extends DialogController> T createDialogController(DialogConstant dialogConstant, int instanceNumber) {
        T newController = this.createDialogControllerInternal(dialogConstant.getInternalName());
        return this.registerController(instanceNumber, (DialogController)newController);
    }

    <T extends DialogController> T registerController(int instanceNumber, DialogController newController) {
        int dialogInstanceNumber;
        DialogConstant dialogConstant = newController.getDialogConstant();
        int n = dialogInstanceNumber = instanceNumber > 0 ? instanceNumber : this.getNextAvailableInstanceNumber(dialogConstant);
        if (!this.validateInstanceNumber(dialogConstant, dialogInstanceNumber)) {
            throw new InstanceNumberOutOfBoundsException("Cannot create new instance with instanceNumber " + dialogInstanceNumber);
        }
        newController.setDialogInstanceNumber(dialogInstanceNumber);
        this.registerDialog(newController);
        return (T)newController;
    }

    DialogInstance createDialogInstance(DialogConstant dialogConstant, int instanceNumber) {
        Assert.notNull((Object)dialogConstant, (String)"dialogConstant must not be null");
        if (instanceNumber > 0 && this.checkForInstanceInUse(dialogConstant, instanceNumber)) {
            throw new IllegalStateException("Instance " + instanceNumber + " of " + dialogConstant + " is in use");
        }
        Object dialogController = this.createDialogController(dialogConstant, instanceNumber);
        return new DialogInstanceKey(dialogConstant, ((StateController)dialogController).getDialogInstanceNumber());
    }

    synchronized DialogConstant getDialogConstant(String dialogInternalName) {
        return this.getDialogConstantBeanInternal(dialogInternalName);
    }

    synchronized DialogController setActiveDialogInstance(DialogInstance dialogInstanceKey) {
        Assert.notNull((Object)dialogInstanceKey, (String)"dialogInstanceKey must not be null");
        Stack<DialogController> dcStack = this.dialogMap.get(new DialogKey(dialogInstanceKey.getDialogConstant()));
        if (dcStack == null || dcStack.isEmpty()) {
            return null;
        }
        DialogController newNumberOne = this.locateInstance(dialogInstanceKey, dcStack);
        if (newNumberOne != null) {
            dcStack.remove(newNumberOne);
            dcStack.push(newNumberOne);
        }
        return newNumberOne;
    }

    synchronized DialogController getDialogController(DialogInstance dialogInstanceKey) {
        Assert.notNull((Object)dialogInstanceKey, (String)"dialogInstanceKey must not be null");
        Stack<DialogController> dcStack = this.dialogMap.get(new DialogKey(dialogInstanceKey.getDialogConstant()));
        if (dcStack == null || dcStack.isEmpty()) {
            return null;
        }
        for (DialogController dialogController : dcStack) {
            if (dialogInstanceKey.getDialogInstanceNumber() != dialogController.getDialogInstanceNumber()) continue;
            return dialogController;
        }
        return null;
    }

    DialogController getDialogControllerBeanInternal(String dialogInternalName) {
        String beanID = dialogInternalName + CONTROLLER;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new controller using beanID " + beanID));
        }
        DialogController dialogController = (DialogController)G9Spring.getBean(DialogController.class, (String)beanID);
        return dialogController;
    }

    DialogConstant getDialogConstantBeanInternal(String dialogInternalName) {
        String beanID = dialogInternalName + CONSTANT;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting dialog constant using beanID " + beanID));
        }
        DialogConstant dialogConstant = (DialogConstant)G9Spring.getBean(DialogConstant.class, (String)beanID);
        return dialogConstant;
    }

    <T> T getBeanInternal(Class<T> clazz) {
        return (T)ServiceLoader.getService(clazz);
    }

    synchronized int getNextAvailableInstanceNumber(DialogConstant dialogConstant) {
        Assert.notNull((Object)dialogConstant, (String)"dialogConstant must not be null");
        int start = 1;
        DialogKey dialogKey = new DialogKey(dialogConstant);
        Stack<DialogController> dialogControllers = this.dialogMap.get(dialogKey);
        if (dialogControllers != null && !dialogControllers.isEmpty()) {
            ArrayList<DialogController> sortedList = new ArrayList<DialogController>(dialogControllers);
            Collections.sort(sortedList, new Comparator<DialogController>(){

                @Override
                public int compare(DialogController o1, DialogController o2) {
                    return o1.getDialogInstanceNumber() - o2.getDialogInstanceNumber();
                }
            });
            for (DialogController dialogController : sortedList) {
                if (dialogController.getDialogInstanceNumber() != start) continue;
                ++start;
            }
        }
        return start;
    }

    synchronized void removeDialogInstance(DialogInstance dialogInstanceKey) {
        Assert.notNull((Object)dialogInstanceKey, (String)"dialogInstanceKey must not be null");
        this.removeFromStack(dialogInstanceKey);
        this.removeFromList(dialogInstanceKey);
    }

    private void removeFromStack(DialogInstance dialogInstanceKey) {
        Stack<DialogController> dcStack = this.dialogMap.get(new DialogKey(dialogInstanceKey.getDialogConstant()));
        if (dcStack == null || dcStack.isEmpty()) {
            return;
        }
        DialogController instanceToClose = this.locateInstance(dialogInstanceKey, dcStack);
        if (instanceToClose != null) {
            dcStack.remove(instanceToClose);
        }
    }

    private synchronized void removeFromList(DialogInstance dialogInstanceKey) {
        DialogConstant dialogConstant = dialogInstanceKey.getDialogConstant();
        List<DialogController> dcList = this.dialogLists.get(new DialogKey(dialogConstant));
        if (dcList == null || dcList.isEmpty()) {
            return;
        }
        DialogController instanceToClose = this.locateInstance(dialogInstanceKey, dcList);
        if (instanceToClose != null) {
            dcList.remove(instanceToClose);
        }
    }

    private DialogController locateInstance(DialogInstance dialogInstanceKey, List<DialogController> dcStack) {
        DialogController instanceToClose = null;
        for (DialogController dialogController : dcStack) {
            if (dialogInstanceKey.getDialogInstanceNumber() != dialogController.getDialogInstanceNumber()) continue;
            instanceToClose = dialogController;
            break;
        }
        return instanceToClose;
    }

    boolean hasAvailableDialogInstance(DialogConstant dialogConstant) {
        Assert.notNull((Object)dialogConstant, (String)"dialogConstant must not be null");
        int nextAvailableInstanceNumber = this.getNextAvailableInstanceNumber(dialogConstant);
        boolean isValid = this.validateInstanceNumber(dialogConstant, nextAvailableInstanceNumber);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("hasAvailableDialogInstances: " + dialogConstant.getG9Name() + ", max: " + dialogConstant.getMaximumNumberOfInstances() + ", next: " + nextAvailableInstanceNumber + ", isValid: " + isValid));
        }
        return isValid;
    }

    synchronized List<DialogInstance> getActiveDialogInstances(DialogConstant dialogConstant) {
        Stack<DialogController> dcStack = this.dialogMap.get(new DialogKey(dialogConstant));
        if (dcStack == null || dcStack.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createDialogInstanceList(dcStack);
    }

    synchronized List<DialogInstance> getOpenDialogList(DialogConstant dialogConstant) {
        List<DialogController> dcList = this.dialogLists.get(new DialogKey(dialogConstant));
        if (dcList == null || dcList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createDialogInstanceList(dcList);
    }

    synchronized List<DialogController> getOpenDialogList() {
        ArrayList<DialogController> dcList = new ArrayList<DialogController>();
        for (DialogKey dk : this.dialogLists.keySet()) {
            dcList.addAll((Collection<DialogController>)this.dialogLists.get(dk));
        }
        return dcList;
    }

    private List<DialogInstance> createDialogInstanceList(List<DialogController> dcList) {
        ArrayList<DialogInstance> activeDialogInstances = new ArrayList<DialogInstance>();
        for (DialogController dialogController : dcList) {
            activeDialogInstances.add(this.createDialogInstanceKey(dialogController));
        }
        return Collections.unmodifiableList(activeDialogInstances);
    }

    private DialogInstance createDialogInstanceKey(DialogController controller) {
        Assert.notNull((Object)controller, (String)"controller must not be null");
        return new DialogInstanceKey(controller.getDialogConstant(), controller.getDialogInstanceNumber());
    }

    private DialogController createAndRegisterDialogController(String internalName, int instanceNumber) {
        Object newController = this.createDialogControllerInternal(internalName);
        ((StateController)newController).setDialogInstanceNumber(instanceNumber);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating new controller for instance " + ((StateController)newController).getDialogInstanceNumber() + " of " + internalName));
        }
        this.registerDialog((DialogController)newController);
        return newController;
    }

    synchronized DialogInstance getCurrentDialogInstance(DialogConstant dialogConstant) {
        Assert.notNull((Object)dialogConstant, (String)"dialogConstant must not be null");
        Stack<DialogController> dcStack = this.dialogMap.get(new DialogKey(dialogConstant));
        if (dcStack != null && !dcStack.isEmpty()) {
            return new DialogInstanceKey(dialogConstant, dcStack.peek().getDialogInstanceNumber());
        }
        return null;
    }

    private synchronized void registerDialog(DialogController controller) {
        ActionMethodRunner actionMethodRunner = this.getBeanInternal(ActionMethodRunner.class);
        JVineController.getInstance(controller).setActionMethodRunner(actionMethodRunner);
        actionMethodRunner.setDialogController(controller);
        this.addToStack(controller);
        this.addToList(controller);
        controller.setApplicationController(this.applicationController);
    }

    private synchronized void addToStack(DialogController controller) {
        JVineController jvc = JVineController.getInstance(controller);
        DialogKey dialogKey = jvc.getDialogKey();
        Stack<DialogController> stack = this.dialogMap.get(dialogKey);
        if (stack == null) {
            stack = new Stack();
            this.dialogMap.put(dialogKey, stack);
        }
        stack.push(controller);
    }

    private synchronized void addToList(DialogController controller) {
        JVineController jvc = JVineController.getInstance(controller);
        DialogKey dialogKey = jvc.getDialogKey();
        List<DialogController> list = this.dialogLists.get(dialogKey);
        if (list == null) {
            list = new LinkedList<DialogController>();
            this.dialogLists.put(dialogKey, list);
        }
        list.add(controller);
    }

    private boolean validateInstanceNumber(DialogConstant dialogConstant, int dialogInstanceNumber) {
        if (dialogConstant.getMaximumNumberOfInstances() <= 0) {
            return dialogInstanceNumber == 1;
        }
        return dialogInstanceNumber <= dialogConstant.getMaximumNumberOfInstances();
    }

    private boolean checkForInstanceInUse(DialogConstant dialogConstant, int dialogInstanceNumber) {
        Stack<DialogController> dcStack = this.dialogMap.get(new DialogKey(dialogConstant));
        if (dcStack == null || dcStack.isEmpty()) {
            return false;
        }
        for (DialogController dialogController : dcStack) {
            if (dialogController.getDialogInstanceNumber() != dialogInstanceNumber) continue;
            return true;
        }
        return false;
    }
}

