/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view;

import java.security.SecureRandom;

public final class Resource {
    private final String id = Resource.createID();
    private final String resourceName;
    private final String mimeType;
    private final byte[] resource;

    private static String createID() {
        long nextLong = Lazy.random.nextLong();
        nextLong = nextLong == Long.MIN_VALUE ? 0L : Math.abs(nextLong);
        return Long.toString(nextLong);
    }

    public Resource(String resourceName, String mimeType, byte[] resource) {
        this.resourceName = resourceName;
        this.mimeType = mimeType;
        this.resource = (byte[])resource.clone();
    }

    public final String getId() {
        return this.id;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final byte[] getResource() {
        return (byte[])this.resource.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.id == null && other.id != null) {
            return false;
        }
        return this.id == null || this.id.equals(other.id);
    }

    public String toString() {
        return "Resource [id=" + this.id + ", resourceName=" + this.resourceName + ", mimeType=" + this.mimeType + "]";
    }

    private static class Lazy {
        static SecureRandom random = new SecureRandom();

        private Lazy() {
        }
    }
}

