/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.table;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.ListRow;
import no.g9.os.AttributeConstant;

public abstract class RowFilter<U, T extends ListRow> {
    private static final Logger log = Logger.getLogger(RowFilter.class);
    private final DialogObjectConstant column;
    private U filterValue;

    protected RowFilter(DialogObjectConstant column, U filterValue) {
        this.column = column;
        this.filterValue = filterValue;
        this.paramCheck(column, filterValue);
    }

    private void paramCheck(DialogObjectConstant column, U filterValue) {
        String msg = null;
        if (column == null) {
            msg = "Column";
        } else if (filterValue == null) {
            msg = "filterValue";
        }
        if (msg != null) {
            msg = msg + " cannot be null!";
            throw new IllegalArgumentException(msg);
        }
    }

    public abstract boolean passFilter(T var1);

    public final U getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(U filterValue) {
        this.filterValue = filterValue;
    }

    public DialogObjectConstant getColumn() {
        return this.column;
    }

    public static <U extends Comparable<U>, T extends ListRow> RowFilter<U, T> comparableFilter(DialogObjectConstant column, U filterValue, FilterType filterType) {
        return new ComparableFilter(column, filterValue, filterType);
    }

    public static <T extends ListRow> RowFilter<String, T> regexpFilter(DialogObjectConstant column, String regexp) {
        return new RegexpFilter(column, regexp);
    }

    private static class ComparableFilter<U, T extends ListRow>
    extends RowFilter<U, T> {
        private final FilterType filterType;

        private ComparableFilter(DialogObjectConstant column, U filterValue, FilterType filterType) {
            super(column, filterValue);
            this.paramCheck(column);
            this.filterType = filterType;
        }

        private void paramCheck(DialogObjectConstant column) throws RuntimeException {
            AttributeConstant attribute = column.getAttribute();
            Class attributeType = attribute.getAttributeType();
            if (!Comparable.class.isAssignableFrom(attributeType)) {
                String msg = null;
                msg = "Column " + column + " does not contain java.lang.Comparable values";
                log.error((Object)("Cant create comparable filter for " + column + ":"));
                throw new IllegalArgumentException(msg);
            }
        }

        @Override
        public boolean passFilter(T row) {
            Comparable value = (Comparable)((ListRow)row).getValue(this.getColumn());
            log.trace((Object)("Testing " + row + " column " + this.getColumn() + " against " + this.getFilterValue() + " using " + (Object)((Object)this.filterType) + " filter"));
            if (value == null) {
                return false;
            }
            boolean pass = false;
            switch (this.filterType) {
                case EQUAL: {
                    pass = value.compareTo(this.getFilterValue()) == 0;
                    break;
                }
                case NOT_EQUAL: {
                    pass = value.compareTo(this.getFilterValue()) != 0;
                    break;
                }
                case GREATER_THAN: {
                    pass = value.compareTo(this.getFilterValue()) > 0;
                    break;
                }
                case LESS_THAN: {
                    pass = value.compareTo(this.getFilterValue()) < 0;
                    break;
                }
                default: {
                    pass = false;
                }
            }
            log.trace((Object)(pass ? "passed " : "did not pass "));
            return pass;
        }
    }

    private static class RegexpFilter<T extends ListRow>
    extends RowFilter<String, T> {
        private Matcher matcher;

        private RegexpFilter(DialogObjectConstant column, String regexp) {
            super(column, regexp);
            this.updateMathcer(regexp);
        }

        private void updateMathcer(String regexp) {
            Pattern pattern = Pattern.compile(regexp);
            this.matcher = pattern.matcher("");
        }

        @Override
        public boolean passFilter(T row) {
            Object obj = ((ListRow)row).getValue(this.getColumn());
            if (obj == null) {
                obj = "";
            }
            String value = String.valueOf(obj);
            this.matcher.reset(value);
            return this.matcher.find();
        }

        @Override
        public void setFilterValue(String filterValue) {
            super.setFilterValue(filterValue);
            this.updateMathcer(filterValue);
        }
    }

    public static enum FilterType {
        LESS_THAN,
        GREATER_THAN,
        EQUAL,
        NOT_EQUAL;

    }
}

