/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.action;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import no.esito.jvine.action.ActionMethodRunner;
import no.esito.jvine.action.ActionQueue;
import no.esito.jvine.action.ThreadManager;
import no.esito.jvine.controller.JVineAppController;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogController;

public class BlockingActionMethodRunner
implements ActionMethodRunner {
    private static final Logger log = Logger.getLogger(BlockingActionMethodRunner.class);
    private ActionQueue guiActionQueue;
    private final ThreadManager threadManager = new ThreadManager();
    private ExecutorService singleThreadedExecutor = null;
    private DialogController dialogController;

    private ExecutorService getExecutor() {
        if (this.singleThreadedExecutor == null || this.singleThreadedExecutor.isShutdown()) {
            if (log.isTraceEnabled()) {
                String msg = "Creating a new method executor.";
                if (this.singleThreadedExecutor != null) {
                    msg = "Previous executor was shut down. " + msg;
                }
                log.trace((Object)msg);
            }
            this.singleThreadedExecutor = Executors.newSingleThreadExecutor(this.threadManager);
        }
        return this.singleThreadedExecutor;
    }

    @Override
    public synchronized void shutDown() {
        if (this.singleThreadedExecutor != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Shutting down executor " + this.threadManager));
            }
            this.singleThreadedExecutor.shutdown();
        }
    }

    @Override
    public void doMethod(Runnable eventMethod) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Submitting action method for execution");
        }
        ExecutorService service = this.getExecutor();
        service.execute(eventMethod);
        this.getActionQueue().ready();
    }

    @Override
    public void setThreadNamePrefix(String threadName) {
        this.threadManager.setThreadNamePrefix(threadName);
    }

    @Override
    public synchronized ActionQueue getActionQueue() {
        if (this.guiActionQueue == null) {
            JVineAppController appCtrl = JVineAppController.getInstance(this.dialogController.getApplicationController());
            this.guiActionQueue = appCtrl.getActionQueue();
        }
        return this.guiActionQueue;
    }

    @Override
    public void releaseGui() {
        this.getActionQueue().release();
    }

    @Override
    public <V> V invokeOnGui(Callable<V> guiMethod) throws InvocationTargetException {
        return this.getActionQueue().perform(guiMethod);
    }

    @Override
    public void invokeOnGui(Runnable guiMethod) throws InvocationTargetException {
        this.getActionQueue().perform(guiMethod);
    }

    @Override
    public synchronized void setDialogController(DialogController controller) {
        this.dialogController = controller;
    }
}

