/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.communication;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import no.esito.jvine.communication.SystemMessageDialogSetupValue;
import no.g9.client.core.communication.G9ActionPayload;
import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogSetupValue;

public class SystemMessageUtils {
    public static List<SystemMessage> fromJSon(String inputMessagesInJson) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<SystemMessage> decodedMessages = new ArrayList<SystemMessage>();
        try {
            if (inputMessagesInJson != null) {
                List codedMessages = (List)mapper.readValue(inputMessagesInJson, (TypeReference)new TypeReference<List<String>>(){});
                for (String codedMessage : codedMessages) {
                    decodedMessages.add(new SystemMessage(codedMessage));
                }
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return decodedMessages;
    }

    public static String toJson(List<SystemMessage> inputMessages) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (SystemMessage systemMessage : inputMessages) {
            stringList.add(systemMessage.code());
        }
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, stringList);
            return writer.getBuffer().toString();
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static SystemMessage createSystemMessage(String receiver, DialogConstant target, String payload) {
        return new SystemMessage(receiver, target.getInternalName(), payload);
    }

    public static String codeSetupValue(Object setupValue) {
        if (setupValue instanceof String) {
            return (String)setupValue;
        }
        return "";
    }

    public static DialogSetupValue<?> extractActionSetupValue(SystemMessage message, ApplicationController applicationController) {
        G9ActionPayload actionPayload = new G9ActionPayload(message.payload);
        if (!actionPayload.payload.isEmpty()) {
            return new SystemMessageDialogSetupValue(actionPayload.payload, applicationController);
        }
        return null;
    }
}

