/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import no.esito.jvine.controller.CheckResult;
import no.esito.jvine.controller.CtrlObservable;
import no.esito.jvine.controller.DialogInstanceKey;
import no.esito.jvine.controller.ExportAction;
import no.esito.jvine.controller.GrapeActionTask;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.controller.RoleLocator;
import no.esito.jvine.controller.SpreadsheetAction;
import no.esito.jvine.rpc.ActualParameter;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.log.Logger;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.CheckType;
import no.g9.client.core.action.Parameter;
import no.g9.client.core.action.ParameterBinding;
import no.g9.client.core.action.RemoteServiceTarget;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.converter.FrameworkConversionException;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationException;
import no.g9.client.core.validator.ValidationResult;
import no.g9.client.core.view.Resource;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.table.TableModel;
import no.g9.exception.G9BaseException;
import no.g9.message.MessageReply;
import no.g9.message.MessageReplyType;
import no.g9.os.AttributeConstant;
import no.g9.os.Key;
import no.g9.os.KeyTool;
import no.g9.os.OSRole;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.ObjectSelection;
import no.g9.support.action.ActionTarget;

class ActionTaskFactory {
    private static final Logger log = Logger.getLogger(ActionTaskFactory.class);

    ActionTaskFactory() {
    }

    static ActionTask<Object> createGrapeAction(DialogController controller, ActionType action) {
        switch (action) {
            case INSERT: 
            case UPDATE: 
            case SAVE: 
            case FIND: 
            case FINDALL: 
            case DELETE: {
                return new GrapeActionTask(controller, action);
            }
        }
        String msg = "Excpected grape action, got " + action;
        throw new IllegalArgumentException(msg);
    }

    static ActionTask<Resource> createExportAction(DialogConstant target, ApplicationController ctrl) {
        return new ExportAction(target, ctrl);
    }

    static ActionTask<Resource> createSpreadsheetAction(DialogConstant target, ApplicationController ctrl) {
        return new SpreadsheetAction(target, ctrl);
    }

    static ActionTask<Void> createClearTask(final Enum<?> target, final DialogController dialogController) {
        ActionTask<Void> actionTask = new ActionTask<Void>(){

            @Override
            public Void call() throws Exception {
                OSNode<?>[] nodeTargets;
                JVineController jVineController = JVineController.getInstance(dialogController);
                RoleConstant targetRoleConstant = (RoleConstant)target;
                if (targetRoleConstant.isObjectSelection()) {
                    nodeTargets = jVineController.getRootNodes();
                } else {
                    OSNode node = (OSNode)dialogController.getOSRole((RoleConstant)target);
                    nodeTargets = new OSNode[]{node};
                }
                for (OSNode<?> targetNode : nodeTargets) {
                    jVineController.reportToView(targetNode.clear(true), jVineController.getOneRelatedChildren(targetNode.getRoleConstant()), null);
                }
                return null;
            }
        };
        return actionTask;
    }

    static ActionTask<ActionTarget> createActivateTask(final ActionTarget target) {
        ActionTask<ActionTarget> actionTask = new ActionTask<ActionTarget>(){

            @Override
            public ActionTarget call() throws Exception {
                return target;
            }
        };
        return actionTask;
    }

    static ActionTask<Void> createDisplayDialogTask(Object target, ActionType actionType, DialogController dialogController) {
        if (target instanceof Enum) {
            return ActionTaskFactory.createDisplayDialogTask((Enum)target, actionType, dialogController);
        }
        if (target instanceof RemoteServiceTarget) {
            return ActionTaskFactory.createDisplayRemoteServiceResult((RemoteServiceTarget)target, dialogController);
        }
        String msg = "Unknown target " + target;
        throw new RuntimeException(msg);
    }

    private static ActionTask<Void> createDisplayRemoteServiceResult(final RemoteServiceTarget target, final DialogController dialogController) {
        return new ActionTask<Void>(){

            @Override
            public Void call() throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " displaying " + target));
                }
                ParameterBinding returnParameter = target.getReturnParameter();
                Object value = this.getTaskObject();
                Parameter parameter = returnParameter.getActualParameter();
                if (parameter instanceof ActualParameter) {
                    ActualParameter actualParameter = (ActualParameter)parameter;
                    ActualParameter.ParameterType parameterType = actualParameter.getParameterType();
                    switch (parameterType) {
                        case UNBOUND: {
                            break;
                        }
                        case ATTRIBUTE: {
                            AttributeConstant attribute = actualParameter.getAttribute();
                            dialogController.setFieldValue(attribute, value);
                            break;
                        }
                        case ROLE: {
                            RoleConstant role = actualParameter.getRole();
                            OSNode node = (OSNode)dialogController.getOSRole(role);
                            Collection<OSNode<?>> changedNodes = null;
                            changedNodes = value instanceof Collection ? node.setCurrentInstances((Collection)value) : node.setCurrentInstance(value);
                            HashSet include = new HashSet();
                            include.add(node);
                            JVineController.getInstance(dialogController).reportToView(changedNodes, include, null);
                            break;
                        }
                        default: {
                            String msg = "Can't display actual parameter " + actualParameter;
                            throw new RuntimeException(msg);
                        }
                    }
                }
                return null;
            }
        };
    }

    private static ActionTask<Void> createDisplayDialogTask(final Enum<?> target, final ActionType actionType, final DialogController dialogController) {
        final OSNode targetNode = (OSNode)dialogController.getOSRole((RoleConstant)target);
        return new ActionTask<Void>(){

            @Override
            public Void call() throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " displaying " + target));
                }
                Collection result = (Collection)this.getTaskObject();
                this.newDisplay(targetNode, actionType, result);
                return null;
            }

            private void newDisplay(OSNode<?> actionTarget, ActionType actionType2, Collection<?> result) {
                if (actionType2 == ActionType.FINDALL) {
                    Collection<OSNode<?>> changedNodes = actionTarget.setCurrentInstances(result);
                    HashSet include = new HashSet();
                    include.add(targetNode);
                    JVineController.getInstance(dialogController).reportToView(changedNodes, include, null);
                    this.sortAndFilter(dialogController, changedNodes, include);
                } else {
                    Object newCurrent = this.wash(result);
                    if (newCurrent != null) {
                        Collection<OSNode<?>> changedNodes = null;
                        if (ActionTaskFactory.isSaveParentAction(actionType2, targetNode)) {
                            changedNodes = actionTarget.setCurrentInstance(null);
                            this.getRootNode(targetNode).setCurrentInstance(newCurrent);
                            changedNodes.addAll(this.getRootPathNodes(targetNode));
                        } else {
                            changedNodes = actionTarget.setCurrentInstance(newCurrent);
                        }
                        HashSet include = new HashSet();
                        include.add(targetNode);
                        JVineController.getInstance(dialogController).reportToView(changedNodes, include, null);
                        this.sortAndFilter(dialogController, changedNodes, include);
                    }
                }
            }

            private <R> R wash(Collection<R> collection) {
                if (collection == null) {
                    return null;
                }
                if (collection.isEmpty()) {
                    return null;
                }
                return collection.iterator().next();
            }

            private void sortAndFilter(DialogController dialogController2, Collection<OSNode<?>> changedNodes, Collection<OSNode<?>> includeNodes) {
                Collection<OSNode<?>> washedList = CtrlObservable.washList(changedNodes, includeNodes, null);
                ViewModel viewModel = dialogController2.getDialogView().getViewModel();
                for (OSNode<?> node : washedList) {
                    TableModel tableModel = viewModel.getTableModel(node.getRoleConstant());
                    if (tableModel == null) continue;
                    tableModel.filterTableView();
                    tableModel.sortTableView();
                }
            }

            private Collection<OSNode<?>> getRootPathNodes(OSNode<?> target2) {
                HashSet rootPathNodes = new HashSet();
                OSNode<Object> rootRole = target2;
                JVineController jctrl = JVineController.getInstance(dialogController);
                while (rootRole.getParent() != null) {
                    OSRole<?> parent = rootRole.getParent();
                    rootRole = jctrl.getOSNode(parent.getRoleConstant());
                    rootPathNodes.add(rootRole);
                }
                return rootPathNodes;
            }

            private OSNode<?> getRootNode(OSNode<?> target2) {
                OSNode<Object> rootRole = target2;
                JVineController jctrl = JVineController.getInstance(dialogController);
                while (rootRole.getParent() != null) {
                    OSRole<?> parent = rootRole.getParent();
                    rootRole = jctrl.getOSNode(parent.getRoleConstant());
                }
                return rootRole;
            }
        };
    }

    static ActionTask<ObjectSelection> createObtainDialogTask(Object target, DialogController dialogController, ActionType actionType) {
        if (target instanceof Enum) {
            return ActionTaskFactory.createObtainDialogTask((Enum)target, dialogController, actionType);
        }
        if (target instanceof RemoteServiceTarget) {
            return ActionTaskFactory.createObtainDialogTask((RemoteServiceTarget)target, dialogController);
        }
        String msg = "Unknown target " + target;
        throw new RuntimeException(msg);
    }

    private static OSNode<?>[] getObtainTarget(DialogController dialogController, Enum<?> target) {
        if (target instanceof RoleConstant) {
            return new OSNode[]{(OSNode)dialogController.getOSRole((RoleConstant)target)};
        }
        if (target instanceof DialogConstant) {
            return JVineController.getInstance(dialogController).getRootNodes();
        }
        throw new G9BaseException("Can't obtain target: " + target);
    }

    private static ActionTask<ObjectSelection> createObtainDialogTask(final Enum<?> target, final DialogController dialogController, final ActionType actionType) {
        final OSNode[] node = ActionTaskFactory.getObtainTarget(dialogController, target);
        final boolean clearCurrent = !ActionTaskFactory.isSaveParentAction(actionType, node[0]) && ActionType.DELETE == actionType;
        return new ActionTask<ObjectSelection>(){

            @Override
            public ObjectSelection call() throws Exception {
                Object actionTarget = node[0].obtain(clearCurrent);
                OSNode[] root = new OSNode[node.length];
                for (int i = 0; i < node.length; ++i) {
                    root[i] = node[i];
                }
                JVineController jctrl = JVineController.getInstance(dialogController);
                for (int i = 0; i < root.length; ++i) {
                    OSNode rootRole = root[i];
                    while (rootRole.getParent() != null) {
                        OSRole<?> parent = rootRole.getParent();
                        RoleConstant roleConstant = parent.getRoleConstant();
                        rootRole = jctrl.getOSNode(roleConstant);
                    }
                    root[i] = rootRole;
                }
                String targetName = node[0].getRoleConstant().toString();
                String applicationName = dialogController.getApplicationController().getApplicationName();
                String objectSelectionName = dialogController.getObjectSelectionName();
                ObjectSelection os = new ObjectSelection(actionTarget, targetName, targetName, applicationName, objectSelectionName);
                Key key = KeyTool.getCompleteUniqueKey(actionTarget, (OSRole)node[0]);
                if (key != null) {
                    os.setTargetMainKey(key.getKeyName());
                }
                if (target instanceof DialogConstant) {
                    for (int i = 0; i < root.length; ++i) {
                        List<Object> rootInstances = this.getRootInstances(root[i]);
                        os.putRootObjects(root[i].toString(), rootInstances);
                    }
                } else if (ActionTaskFactory.isSaveParentAction(actionType, node[0])) {
                    List<Object> rootInstances = this.getRootInstances(root[0]);
                    if (actionTarget == null) {
                        rootInstances.clear();
                        rootInstances.add(root[0].obtain(false));
                    }
                    String rootName = root[0].getRoleConstant().toString();
                    os.removeAllRootObjects();
                    os.putRootObjects(rootName, rootInstances);
                    os.setCurrentRootName(rootName);
                    HashMap targetActions = new HashMap();
                    if (actionTarget != null) {
                        targetActions.put(actionTarget, actionType);
                    }
                    os.setActions(targetActions);
                }
                return os;
            }

            private List<Object> getRootInstances(OSNode<?> node2) {
                ArrayList<Object> list = new ArrayList<Object>();
                Collection<?> allInstances = node2.getAllInstances();
                if (allInstances.size() > 0) {
                    list.addAll(allInstances);
                } else {
                    list.add(node2.obtain(false));
                }
                return list;
            }
        };
    }

    private static ActionTask<ObjectSelection> createObtainDialogTask(final RemoteServiceTarget target, final DialogController dialogController) {
        return new ActionTask<ObjectSelection>(){

            @Override
            public ObjectSelection call() throws Exception {
                ObjectSelection os = new ObjectSelection();
                String applicationName = dialogController.getApplicationController().getApplicationName();
                os.setApplicationName(applicationName);
                String targetName = target.getService().toString();
                os.setTargetRoleName(targetName);
                os.putRootObject(targetName, (Object)target);
                List<ParameterBinding<?>> parameterBindings = target.getParameterBindings();
                for (ParameterBinding<?> parameterBinding : parameterBindings) {
                    parameterBinding.obtainParameterValue();
                }
                return os;
            }
        };
    }

    static ActionTask<Void> createDialogActionTask(final ActionType action, final DialogConstant target, final DialogController controller) {
        ActionTask<Void> actionTask = new ActionTask<Void>(){

            @Override
            public Void call() throws Exception {
                Object taskObject = this.getTaskObject();
                boolean tmp = false;
                try {
                    tmp = (Boolean)taskObject;
                }
                catch (NullPointerException npe) {
                    tmp = false;
                }
                catch (ClassCastException cce) {
                    tmp = false;
                }
                controller.getApplicationController().performAction(action, target, tmp);
                if (this.canTriggerShownHiddenEvent()) {
                    this.getApplicationView().triggerShownHiddenEvent(target, action);
                }
                return null;
            }

            private boolean canTriggerShownHiddenEvent() {
                return controller.getDialogConstant() != target;
            }

            private AbstractApplicationView getApplicationView() {
                return (AbstractApplicationView)controller.getApplicationController().getApplicationView();
            }
        };
        return actionTask;
    }

    static ActionTask<Void> createDialogActionTaskFromExternal(final ActionType action, final DialogConstant target, final DialogController controller) {
        ActionTask<Void> actionTask = new ActionTask<Void>(){

            @Override
            public Void call() throws Exception {
                Object taskObject = this.getTaskObject();
                boolean tmp = false;
                try {
                    tmp = (Boolean)taskObject;
                }
                catch (NullPointerException npe) {
                    tmp = false;
                }
                catch (ClassCastException cce) {
                    tmp = false;
                }
                controller.getApplicationController().performActionFromExternal(action, target, tmp);
                return null;
            }
        };
        return actionTask;
    }

    static ActionTask<Void> createGuiActionTask(final ActionType action, final ActionTarget target, final DialogController dialogController) {
        ActionTask<Void> actionTask = new ActionTask<Void>(){

            @Override
            public Void call() throws Exception {
                dialogController.getDialogView().performAction(action, (DialogObjectConstant)target);
                return null;
            }
        };
        return actionTask;
    }

    static ActionTask<Boolean> createCheckDialogTask(ActionType checkType, final Object target, final DialogController dialogController) {
        RoleConstant targetRole;
        if (checkType == ActionType.OPEN) {
            return new ActionTask<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean shouldTest = this.FLAG;
                    if (!shouldTest) {
                        log.debug((Object)("Possible reuse of " + target + " instance - no test for avilability needed."));
                        return true;
                    }
                    log.debug((Object)("Testing that application allows opening of " + target));
                    boolean hasAvailableDialogInstance = true;
                    hasAvailableDialogInstance = dialogController.getApplicationController().hasAvailableDialogInstance((DialogConstant)target);
                    log.debug((Object)("Application controller has available dialog instance for " + target + " = " + hasAvailableDialogInstance));
                    return hasAvailableDialogInstance;
                }
            };
        }
        if (target instanceof DialogConstant) {
            return new CheckTask(dialogController, (DialogConstant)target, checkType);
        }
        if (target instanceof RoleConstant && (targetRole = (RoleConstant)target).isObjectSelection()) {
            return new CheckTask(dialogController, targetRole, checkType);
        }
        if (target instanceof RemoteServiceTarget) {
            return new CheckTask(dialogController, (RemoteServiceTarget)target);
        }
        return new CheckTask(dialogController, (Enum)target, checkType);
    }

    private static boolean isSaveParentAction(ActionType actionType, OSNode<?> targetNode) {
        if (targetNode.isRoot()) {
            return false;
        }
        switch (actionType) {
            case INSERT: 
            case UPDATE: 
            case SAVE: 
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    private static final class CheckTask
    extends ActionTask<Boolean> {
        private final DialogController dialogController;
        private final ActionType checkType;
        final OSNode<?>[] targetNode;
        final RoleConstant targetRoleConstant;
        final DialogController targetDialog;

        private CheckTask(DialogController dialogController, Enum<?> target, ActionType checkType) {
            this.dialogController = dialogController;
            this.checkType = checkType;
            this.targetNode = new OSNode[1];
            if (target instanceof RoleConstant) {
                this.targetNode[0] = (OSNode)dialogController.getOSRole((RoleConstant)target);
                this.targetRoleConstant = (RoleConstant)target;
            } else if (target instanceof DialogObjectConstant) {
                DialogObjectConstant doc = (DialogObjectConstant)((Object)target);
                this.targetNode[0] = (OSNode)dialogController.getOSRole(doc.getRole());
                this.targetRoleConstant = doc.getRole();
            } else {
                this.targetNode[0] = null;
                this.targetRoleConstant = null;
            }
            this.targetDialog = null;
        }

        private CheckTask(DialogController dialogController, DialogConstant target, ActionType checkType) {
            this.dialogController = dialogController;
            this.checkType = checkType;
            this.targetNode = null;
            this.targetRoleConstant = null;
            this.targetDialog = dialogController.getApplicationController().getDialogController(target);
        }

        private CheckTask(DialogController dialogController, RoleConstant target, ActionType checkType) {
            this.dialogController = dialogController;
            this.checkType = checkType;
            this.targetNode = JVineController.getInstance(dialogController).getRootNodes();
            this.targetRoleConstant = target;
            this.targetDialog = null;
        }

        private CheckTask(DialogController dialogController, RemoteServiceTarget target) {
            this.dialogController = dialogController;
            this.checkType = ActionType.INVOKE;
            this.targetNode = RoleLocator.getNodesToCheck(dialogController, target);
            this.targetRoleConstant = null;
            this.targetDialog = dialogController;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.checkType == null) {
                return Boolean.TRUE;
            }
            String msgID = null;
            String msgDesc = null;
            boolean checkOK = true;
            CheckResult checkResult = null;
            switch (this.checkType) {
                case CHECK_FIND: {
                    for (OSNode<?> target : this.targetNode) {
                        CheckResult tmp = target.checkFind();
                        if (checkResult == null) {
                            checkResult = tmp;
                        } else {
                            checkResult.addConversionError(tmp.getConversionError());
                            if (!tmp.getCheckResult().booleanValue()) {
                                checkResult.setCheckResult(tmp.getCheckResult());
                            }
                        }
                        checkOK = checkOK && checkResult.getCheckResult() != false;
                    }
                    if (checkResult != null && !checkResult.getConversionError().isEmpty()) {
                        throw new FrameworkConversionException(checkResult.getConversionError());
                    }
                    msgID = "-1601";
                    msgDesc = "Dialog changed, continue with find?";
                    break;
                }
                case CHECK_DELETE: {
                    for (OSNode<?> target : this.targetNode) {
                        CheckResult cr = target.checkChanged(CheckType.DELETE, this.targetRoleConstant);
                        if (checkResult == null) {
                            checkResult = cr;
                        }
                        checkOK = checkOK && cr.getCheckResult() != false;
                        checkResult.addConversionError(cr.getConversionError());
                        checkResult.setCheckResult(checkOK);
                    }
                    msgID = "-1603";
                    msgDesc = "Dialog changed, continue with delete?";
                    if (checkResult == null || checkResult.getConversionError().isEmpty()) break;
                    throw new FrameworkConversionException(checkResult.getConversionError());
                }
                case INSERT: 
                case UPDATE: 
                case SAVE: {
                    boolean retVal = true;
                    for (OSNode<?> target : this.targetNode) {
                        CheckResult checkSaveResult = target.checkSave(this.checkType);
                        Map<ValidationResult, ValidateContext> validationResult = checkSaveResult.getValidationResult();
                        if (!validationResult.isEmpty()) {
                            throw new ValidationException(validationResult);
                        }
                        Map<DialogObjectConstant, Collection<?>> conversionError = checkSaveResult.getConversionError();
                        if (!conversionError.isEmpty()) {
                            throw new FrameworkConversionException(conversionError);
                        }
                        retVal = retVal && checkSaveResult.getCheckResult() != false;
                    }
                    return retVal;
                }
                case CHECK_CLOSE: {
                    checkOK = JVineController.getInstance(this.targetDialog).checkClose();
                    msgID = "-1602";
                    DialogInstanceKey instance = new DialogInstanceKey(this.targetDialog.getDialogConstant(), this.targetDialog.getDialogInstanceNumber());
                    msgDesc = this.dialogController.getApplicationController().getApplicationView().getDialogTitle(instance);
                    break;
                }
                case SELECT: {
                    for (OSNode<?> target : this.targetNode) {
                        checkOK = checkOK && target.checkChanged(CheckType.CLEAR, this.targetRoleConstant).getCheckResult() != false;
                    }
                    msgID = "-1605";
                    msgDesc = "Unsaved data will be lost! Select new row?";
                    break;
                }
                case UNSELECT: {
                    for (OSNode<?> target : this.targetNode) {
                        checkOK = checkOK && target.checkChanged(CheckType.CLEAR, this.targetRoleConstant).getCheckResult() != false;
                    }
                    msgID = "-1606";
                    msgDesc = "Unsaved data will be lost! Unselect row?";
                    break;
                }
                case CHECK_CLEAR: {
                    for (OSNode<?> target : this.targetNode) {
                        checkOK = checkOK && target.checkChanged(CheckType.CLEAR, this.targetRoleConstant).getCheckResult() != false;
                    }
                    msgID = "-1604";
                    msgDesc = "Dialog changed, continue with clear?";
                    break;
                }
                case INVOKE: {
                    for (OSNode<?> target : this.targetNode) {
                        CheckResult cr = target.checkChanged(CheckType.INVOKE, target.getRoleConstant());
                        checkOK = cr.getCheckResult();
                        Map<DialogObjectConstant, Collection<?>> messages = cr.getConversionError();
                        if (messages.isEmpty()) continue;
                        throw new FrameworkConversionException(messages);
                    }
                    msgID = "-1607";
                    msgDesc = "Dialog changed, continue?";
                    break;
                }
                default: {
                    checkOK = true;
                }
            }
            return checkOK || this.interact(msgID, msgDesc);
        }

        boolean interact(String msgID, String msgDesc) {
            MessageReply reply = this.dialogController.dispatchMessage(msgID, msgDesc);
            return MessageReplyType.REPLY_OK.equals((Object)reply);
        }
    }
}

