/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import no.esito.jvine.controller.OSNode;
import no.esito.log.Logger;
import no.g9.client.core.view.DialogView;

class CtrlObservable
extends Observable {
    private static final Logger log = Logger.getLogger(CtrlObservable.class);
    private Map<DialogView, Observer> viewToObserver = new HashMap<DialogView, Observer>();

    CtrlObservable() {
    }

    @Override
    protected synchronized void setChanged() {
        super.setChanged();
    }

    void registerView(final DialogView dialogView) {
        Observer observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                dialogView.update((Collection)arg);
            }
        };
        this.viewToObserver.put(dialogView, observer);
        this.addObserver(observer);
    }

    void removeView(DialogView dialogView) {
        this.deleteObserver(this.viewToObserver.get(dialogView));
    }

    void reportToView(Collection<OSNode<?>> changedNodes, Collection<OSNode<?>> includeNodes, OSNode<?> excludeNode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Reporting changed nodes to view.");
            log.trace((Object)("Complete list before washing is: " + changedNodes));
            log.trace((Object)("Included nodes are: " + includeNodes));
            log.trace((Object)("Exclude node is: " + excludeNode));
        }
        Collection<OSNode<?>> changedManyNodes = CtrlObservable.washList(changedNodes, includeNodes, excludeNode);
        this.setChanged();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Notifying observers about changed nodes: " + changedManyNodes));
        }
        this.notifyObservers(changedManyNodes);
    }

    static Collection<OSNode<?>> washList(Collection<OSNode<?>> changedNodes, Collection<OSNode<?>> includeNodes, OSNode<?> excludeNode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Washing list of changed nodes reported to view.");
        }
        HashSet changedManyNodes = new HashSet();
        for (OSNode<?> node : changedNodes) {
            switch (node.getRelationCardinality()) {
                case MANY: 
                case ROOT: {
                    changedManyNodes.add(node);
                    break;
                }
            }
        }
        if (includeNodes != null) {
            changedManyNodes.addAll(includeNodes);
        }
        if (excludeNode != null && changedManyNodes.contains(excludeNode)) {
            changedManyNodes.remove(excludeNode);
        }
        return changedManyNodes;
    }
}

