/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.io.Serializable;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogInstance;
import org.springframework.util.Assert;

public class DialogInstanceKey
implements DialogInstance,
Serializable {
    private final DialogConstant dialogConstant;
    private final int dialogInstanceNumber;

    public DialogInstanceKey(DialogConstant dialogConstant, int dialogInstanceNumber) {
        int maxNumberOfInstances = dialogConstant.getMaximumNumberOfInstances() <= 0 ? 1 : dialogConstant.getMaximumNumberOfInstances();
        Assert.notNull((Object)dialogConstant, (String)"dialogConstant must not be null");
        Assert.isTrue((dialogInstanceNumber >= 1 && dialogInstanceNumber <= maxNumberOfInstances ? 1 : 0) != 0, (String)("dialogInstanceNumber must be >= 1 and <= " + maxNumberOfInstances + ", was: " + dialogInstanceNumber));
        this.dialogConstant = dialogConstant;
        this.dialogInstanceNumber = dialogInstanceNumber <= 0 ? 1 : dialogInstanceNumber;
    }

    @Override
    public DialogConstant getDialogConstant() {
        return this.dialogConstant;
    }

    @Override
    public int getDialogInstanceNumber() {
        return this.dialogInstanceNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dialogConstant == null ? 0 : this.dialogConstant.hashCode());
        result = 31 * result + this.dialogInstanceNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DialogInstanceKey)) {
            return false;
        }
        DialogInstanceKey other = (DialogInstanceKey)obj;
        if (this.dialogConstant == null ? other.dialogConstant != null : !this.dialogConstant.equals(other.dialogConstant)) {
            return false;
        }
        return this.dialogInstanceNumber == other.dialogInstanceNumber;
    }

    public String toString() {
        return "DialogInstanceKey [dialogConstant=" + this.dialogConstant + ", dialogInstanceNumber=" + this.dialogInstanceNumber + "]";
    }
}

