/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.view.Resource;
import no.g9.client.core.view.ResourceStore;
import no.g9.service.print.ExportService;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;
import no.g9.support.xml.XmlConverter;
import org.w3c.dom.Document;

final class ExportAction
extends ActionTask<Resource> {
    private static final Logger log = Logger.getLogger(ExportAction.class);
    private static final String PDF = ".pdf";
    private static final String MIME_TYPE = "application/pdf";
    private static final boolean PURGE = true;
    private final DialogConstant targetDialog;
    private final ByteArrayOutputStream pdfBytes;
    private final XmlConverter xmlConverter = (XmlConverter)ServiceLoader.getService(XmlConverter.class);
    private final ExportService exportService = (ExportService)ServiceLoader.getService(ExportService.class);
    private final ResourceStore resourceStore = (ResourceStore)ServiceLoader.getService(ResourceStore.class);
    private final ApplicationController appCtrl;

    ExportAction(DialogConstant target, ApplicationController appCtrl) {
        this.targetDialog = target;
        this.appCtrl = appCtrl;
        this.pdfBytes = new ByteArrayOutputStream();
    }

    @Override
    public Resource call() throws Exception {
        Object[] taskObject = (Object[])this.getTaskObject();
        ObjectSelection os = (ObjectSelection)taskObject[0];
        ClientContext ctx = (ClientContext)taskObject[1];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting " + this + " to pdf file"));
        }
        Document data = this.xmlConverter.convert(os, ctx);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Converted to xml");
        }
        this.exportService.exportToPDF(data, this.targetDialog.getG9Name(), (OutputStream)this.pdfBytes);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exported to pdf");
        }
        Resource pdfResource = new Resource(this.targetDialog.getG9Name() + PDF, MIME_TYPE, this.pdfBytes.toByteArray());
        this.resourceStore.putResource(pdfResource);
        this.appCtrl.getApplicationView().openResource(pdfResource.getId(), true);
        return pdfResource;
    }

    @Override
    public String toString() {
        return "ExportAction [targetDialog=" + this.targetDialog + "]";
    }
}

