/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import no.esito.log.Logger;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.controller.DialogController;
import no.g9.service.JGrapeService;
import no.g9.support.ActionType;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

final class GrapeActionTask
extends ActionTask<Object> {
    private static final Logger log = Logger.getLogger(GrapeActionTask.class);
    private final DialogController dialogController;
    private final ActionType action;

    GrapeActionTask(DialogController dialogController, ActionType action) {
        this.dialogController = dialogController;
        this.action = action;
    }

    @Override
    public Object call() throws Exception {
        Object[] taskObject = (Object[])this.getTaskObject();
        ObjectSelection os = (ObjectSelection)taskObject[0];
        ClientContext ctx = (ClientContext)taskObject[1];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking " + this.action + "."));
            log.debug((Object)("Object selection target is: " + os.getTargetRoleName()));
            log.debug((Object)("Object selection root is: " + os.getRootObject(os.getTargetRoleName())));
        }
        Object result = this.invokeService(os, ctx);
        this.setTaskObject(result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result from action " + this.action + " is " + result));
        }
        return result;
    }

    private Object invokeService(ObjectSelection os, ClientContext ctx) {
        JGrapeService service = this.dialogController.getApplicationController().getServiceProxy();
        switch (this.action) {
            case FIND: {
                return service.find(os, ctx);
            }
            case FINDALL: {
                return service.findAll(os, ctx);
            }
            case INSERT: {
                if (os.getActions() != null) {
                    return service.save(os, ctx);
                }
                return service.insert(os, ctx);
            }
            case UPDATE: {
                if (os.getActions() != null) {
                    return service.save(os, ctx);
                }
                return service.update(os, ctx);
            }
            case SAVE: {
                return service.save(os, ctx);
            }
            case DELETE: {
                if (os.getActions() != null) {
                    return service.save(os, ctx);
                }
                return service.delete(os, ctx);
            }
        }
        return null;
    }
}

