/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import no.esito.jvine.action.ActionHelper;
import no.esito.jvine.action.ActionMethod;
import no.esito.jvine.action.ActionMethodRunner;
import no.esito.jvine.action.SimpleActionExecutor;
import no.esito.jvine.action.UAMessageCallback;
import no.esito.jvine.communication.SystemMessageUtils;
import no.esito.jvine.controller.ActionTaskFactory;
import no.esito.jvine.controller.CtrlObservable;
import no.esito.jvine.controller.DialogInstanceKey;
import no.esito.jvine.controller.DialogKey;
import no.esito.jvine.controller.FieldData;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.model.TreeNode;
import no.esito.jvine.model.TreeNodeSentinel;
import no.esito.jvine.validation.ValidationMessageHelper;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.jvine.view.ViewModelImpl;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.ActionExecutor;
import no.g9.client.core.action.ActionFactory;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.EventContext;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.action.RemoteServiceTarget;
import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.DialogSetupValue;
import no.g9.client.core.controller.DisplayException;
import no.g9.client.core.controller.ObtainException;
import no.g9.client.core.message.BlockingMessageCallback;
import no.g9.client.core.message.FieldMessageContext;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationResult;
import no.g9.client.core.view.DialogView;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.Resource;
import no.g9.client.core.view.ViewModel;
import no.g9.exception.G9ClientException;
import no.g9.message.Message;
import no.g9.message.MessageContext;
import no.g9.message.MessageDispatcher;
import no.g9.message.MessageSystem;
import no.g9.os.OSRole;
import no.g9.os.RelationCardinality;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.ObjectSelection;
import no.g9.support.action.ActionTarget;
import no.g9.support.convert.ConvertException;

public abstract class StateController {
    private static final Logger log = Logger.getLogger(StateController.class);
    private TreeNodeSentinel treeNodeSentinel;
    private boolean invokeHooks = true;
    private final List<ValidationResult> validationResult = new ArrayList<ValidationResult>();
    private final List<ConvertException> convertExceptions = new ArrayList<ConvertException>();
    private final CtrlObservable observable = new CtrlObservable();
    private final Map<RoleConstant, OSNode<?>> nodes = new HashMap();
    private final Map<RoleConstant, OSNode<?>> roots = new HashMap();
    private final Map<String, ActionMethod> eventMethods = new HashMap<String, ActionMethod>();
    private ActionMethodRunner actionMethodRunner;
    private final ActionFactory actionFactory = new ActionFactory();
    private final ActionExecutor executor = new SimpleActionExecutor();
    private DialogController caller;
    private int dialogInstanceNumber;
    private final String DIALOG_NAME;
    private DialogKey dialogKey;
    private DialogInstance dialogInstance;

    final FieldData getFieldData(RoleConstant roleConstant) {
        return this.getViewModel().getCurrentFieldData(roleConstant);
    }

    public abstract ViewModel getViewModel();

    public abstract DialogConstant getDialogConstant();

    public StateController(String dialogName) {
        if (dialogName == null) {
            throw new IllegalArgumentException("Dialog name can not be null");
        }
        this.DIALOG_NAME = dialogName;
    }

    final boolean isInvokeHooksOn() {
        return this.invokeHooks;
    }

    final void setInvokeHooks(boolean invokeHooks) {
        this.invokeHooks = invokeHooks;
    }

    final synchronized DialogKey getDialogKey() {
        if (this.dialogKey == null) {
            this.dialogKey = new DialogKey(this.getDialogConstant());
        }
        return this.dialogKey;
    }

    final synchronized DialogInstance getDialogInstance() {
        if (this.dialogInstance == null) {
            this.dialogInstance = new DialogInstanceKey(this.getDialogConstant(), this.getDialogInstanceNumber());
        }
        return this.dialogInstance;
    }

    final ActionTask<ObjectSelection> getObtainDialogTask(ActionTarget target, ActionType actionType) {
        return ActionTaskFactory.createObtainDialogTask(target, (DialogController)this, actionType);
    }

    final synchronized <T extends DialogView> T getDialogViewInternal() {
        ApplicationController applicationController = this.getApplicationController();
        AbstractApplicationView applicationView = (AbstractApplicationView)applicationController.getApplicationView();
        return applicationView.getDialogView(this.getDialogInstance());
    }

    protected abstract ApplicationController getApplicationController();

    final ActionTask<Void> getDisplayDialogTask(ActionTarget target, ActionType actionType) {
        return ActionTaskFactory.createDisplayDialogTask(target, actionType, (DialogController)this);
    }

    final Collection<OSNode<?>> getOneRelatedChildren(RoleConstant role) {
        HashSet oneRelatedChildren = new HashSet();
        for (OSRole<?> child : this.getOSNode(role).getChildren()) {
            if (child.getRelationCardinality() != RelationCardinality.ONE) continue;
            oneRelatedChildren.add(this.getOSNode(child.getRoleConstant()));
        }
        return oneRelatedChildren;
    }

    public final void performAction(ActionType action, EventContext event, ActionTarget target) {
        G9Action<Object> g9Action = null;
        if (action == ActionType.PRINT) {
            g9Action = this.getAction(action, target, Resource.class, ActionTaskFactory.createExportAction((DialogConstant)target, this.getApplicationController()));
        } else if (action == ActionType.EXPORTTOSPREADSHEET) {
            g9Action = this.getAction(action, target, Resource.class, ActionTaskFactory.createSpreadsheetAction((DialogConstant)target, this.getApplicationController()));
        } else if (target instanceof DialogConstant) {
            DialogSetupValue<String> setupValue = null;
            ActionTask<Void> dialogActionTask = null;
            if (event.getEvent() instanceof SystemMessage) {
                dialogActionTask = ActionTaskFactory.createDialogActionTaskFromExternal(action, (DialogConstant)target, (DialogController)this);
                SystemMessage message = (SystemMessage)event.getEvent();
                if (((DialogConstant)target).getInternalName().equals(message.port)) {
                    try {
                        setupValue = SystemMessageUtils.extractActionSetupValue(message, this.getApplicationController());
                        this.setExternalActionActiveInstance(action, (DialogConstant)target, setupValue);
                    }
                    catch (Exception exception) {}
                }
            } else {
                dialogActionTask = ActionTaskFactory.createDialogActionTask(action, (DialogConstant)target, (DialogController)this);
            }
            g9Action = this.getAction(action, target, Void.class, dialogActionTask);
            g9Action.setActionSetupValue(setupValue);
        } else if (ActionHelper.isGuiAction(action)) {
            g9Action = this.getAction(action, target, Void.class, ActionTaskFactory.createGuiActionTask(action, target, (DialogController)this));
        } else if (ActionHelper.isGrapeAction(action)) {
            g9Action = this.getAction(action, target, Object.class, ActionTaskFactory.createGrapeAction((DialogController)this, action));
        } else if (action == ActionType.CLEAR) {
            g9Action = this.getAction(action, target, Void.class, ActionTaskFactory.createClearTask((Enum)target, (DialogController)this));
        } else if (action == ActionType.INVOKE) {
            RemoteServiceTarget rst = (RemoteServiceTarget)target;
            g9Action = this.getAction(rst);
        } else if (action == ActionType.ACTIVATE) {
            g9Action = this.getAction(action, target, ActionTarget.class, ActionTaskFactory.createActivateTask(target));
        }
        if (g9Action != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing " + g9Action));
            }
        } else {
            String msg = "Cannot perform action. Unknown action type: " + action;
            throw new RuntimeException(msg);
        }
        g9Action.setEvent(event);
        this.executor.execute(g9Action);
    }

    private void setExternalActionActiveInstance(ActionType action, DialogConstant dialog, DialogSetupValue<String> setupValue) {
        if (setupValue != null) {
            SystemMessage msg = new SystemMessage(setupValue.getSetupValue());
            if ("_active_instance".equals(msg.port)) {
                switch (action) {
                    case CLOSE: 
                    case SHOW: 
                    case HIDE: {
                        int instanceNumber = Integer.parseInt(msg.payload);
                        DialogInstanceKey instance = new DialogInstanceKey(dialog, instanceNumber);
                        this.getApplicationController().setActiveDialogInstance(instance);
                        break;
                    }
                }
            }
        }
    }

    private ActionMethod getEventMethod(String eventMethodName) {
        return this.eventMethods.get(eventMethodName);
    }

    final void closeDialogController() {
        for (OSNode<?> rootNode : this.getRoots().values()) {
            rootNode.clear(false);
        }
        this.actionMethodRunner.shutDown();
    }

    final ActionMethodRunner getActionMethodRunner() {
        return this.actionMethodRunner;
    }

    final BlockingMessageCallback getMessageCallback() {
        BlockingMessageCallback msgCallback = (BlockingMessageCallback)ServiceLoader.getService(BlockingMessageCallback.class);
        if (msgCallback instanceof UAMessageCallback) {
            UAMessageCallback uaMsgCb = (UAMessageCallback)msgCallback;
            uaMsgCb.setGuiActionQueue(this.actionMethodRunner.getActionQueue());
        }
        return msgCallback;
    }

    final <T> G9Action<T> getAction(ActionType actionType, ActionTarget target, Class<T> targetType, ActionTask<T> actionTask) {
        return this.actionFactory.getAction(actionType, target, targetType, actionTask, (DialogController)this);
    }

    final G9Action<?> getAction(RemoteServiceTarget target) {
        return this.actionFactory.getInvokeAction(target, (DialogController)this);
    }

    final void setActionMethodRunner(ActionMethodRunner actionMethodRunner) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting action method runner: " + actionMethodRunner.getClass().getName()));
        }
        this.actionMethodRunner = actionMethodRunner;
        actionMethodRunner.setThreadNamePrefix(this.DIALOG_NAME);
    }

    final void dispatch(EventContext event) {
        log.debug((Object)("Dispaching event: " + event));
        ActionMethod actionMethod = this.getEventMethod(event.getMethodName());
        if (actionMethod != null) {
            try {
                actionMethod.setEvent(event);
                this.actionMethodRunner.doMethod(actionMethod);
            }
            finally {
                actionMethod.setEvent(null);
            }
        } else {
            String msg = "No such action method: " + event.getMethodName();
            throw new IllegalArgumentException(msg);
        }
    }

    final synchronized void registerView(DialogView view) {
        this.observable.registerView(view);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " registering " + view + " as an observer."));
        }
    }

    final <T> Collection<T> getAllInstances(OSNode<T> role) {
        return role.getAllInstances();
    }

    final boolean isCurrent(Object inst, OSNode<?> role) {
        return role.isCurrent(inst);
    }

    final void addOSNode(OSNode<?> node) {
        this.nodes.put(node.getRoleConstant(), node);
        if (node.getParent() == null) {
            this.getRoots().put(node.getRoleConstant(), node);
        }
    }

    final synchronized TreeNode<?> getSentinel() {
        if (this.treeNodeSentinel == null) {
            this.treeNodeSentinel = new TreeNodeSentinel();
        }
        return this.treeNodeSentinel;
    }

    final void addValidationResult(ValidationResult result) {
        this.validationResult.add(result);
    }

    final void addConverterException(ConvertException converterException) {
        this.convertExceptions.add(converterException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkValidationAndConvert(boolean isObtain) throws G9ClientException {
        try {
            ArrayList<ValidationResult> failedValidations = new ArrayList<ValidationResult>();
            ArrayList<ConvertException> failedConverters = new ArrayList<ConvertException>();
            boolean failed = false;
            if (!this.validationResult.isEmpty()) {
                failedValidations.addAll(this.validationResult);
                failed = true;
            }
            if (!this.convertExceptions.isEmpty()) {
                failedConverters.addAll(this.convertExceptions);
                failed = true;
            }
            if (failed) {
                if (isObtain) {
                    throw new ObtainException(failedValidations, failedConverters);
                }
                throw new DisplayException(failedValidations, failedConverters);
            }
        }
        finally {
            this.validationResult.clear();
            this.convertExceptions.clear();
        }
    }

    final List<ValidationResult> getValidationResult() {
        return this.validationResult;
    }

    final void clearCurrent(RoleConstant role) {
        OSNode currentRole = this.getOSNode(role);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing current for " + currentRole));
        }
        Collection<OSNode<?>> changed = currentRole.clearCurrent(false);
        this.reportToView(changed, null, currentRole);
    }

    final <T> OSNode<T> getOSNode(RoleConstant role) {
        OSNode<?> node = this.nodes.get(role);
        if (node == null) {
            String msg = "No such role " + role;
            throw new IllegalArgumentException(msg);
        }
        return node;
    }

    final void reportToView(Collection<OSNode<?>> changedNodes, Collection<OSNode<?>> includeNodes, OSNode<?> excludeNode) {
        this.observable.reportToView(changedNodes, includeNodes, excludeNode);
        this.checkValidationAndConvert(false);
    }

    final OSNode<?>[] getRootNodes() {
        return this.getRoots().values().toArray(new OSNode[this.getRoots().size()]);
    }

    final boolean checkClose() {
        boolean checkOK = true;
        for (OSNode<?> rootNode : this.getRootNodes()) {
            if (rootNode.checkClose()) continue;
            checkOK = false;
            break;
        }
        return checkOK;
    }

    final Map<RoleConstant, OSNode<?>> getRoots() {
        return this.roots;
    }

    final void setCurrent(FieldData instanceFieldData) {
        OSNode currentRole = this.getOSNode(instanceFieldData.getRole());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting current for " + currentRole));
        }
        Collection<OSNode<?>> changed = currentRole.setCurrent(instanceFieldData);
        this.reportToView(changed, null, currentRole);
    }

    final void registerEventMethod(String eventMethodName, ActionMethod eventMethodInvoker) {
        this.eventMethods.put(eventMethodName, eventMethodInvoker);
    }

    final ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    final ActionTask<Boolean> getCheckDialogTask(ActionType checkType, ActionTarget target) {
        return ActionTaskFactory.createCheckDialogTask(checkType, target, (DialogController)this);
    }

    void setCaller(DialogController dialogController) {
        this.caller = dialogController;
    }

    public int getDialogInstanceNumber() {
        return this.dialogInstanceNumber;
    }

    public void setDialogInstanceNumber(int dialogInstanceNumber) {
        this.dialogInstanceNumber = dialogInstanceNumber;
    }

    DialogController getCaller() {
        return this.caller;
    }

    public boolean validateField(ListRow listRow, DialogObjectConstant field, Object newValue) {
        ViewModelImpl model = (ViewModelImpl)this.getDialogViewInternal().getViewModel();
        Map<ValidationResult, ValidateContext> result = model.validateField(listRow, field, newValue);
        if (ValidationMessageHelper.succeeded(result)) {
            return true;
        }
        this.actionMethodRunner.doMethod(new ValidationTask(field, result));
        return false;
    }

    public abstract MessageDispatcher getMessageDispatcher();

    class ValidationTask
    implements Runnable {
        private final DialogObjectConstant field;
        private final Map<ValidationResult, ValidateContext> result;

        private ValidationTask(DialogObjectConstant field, Map<ValidationResult, ValidateContext> result) {
            this.field = field;
            this.result = result;
        }

        private MessageContext getFieldMessageContext(final DialogObjectConstant field) {
            return new FieldMessageContext(){

                @Override
                public DialogObjectConstant getField() {
                    return field;
                }

                public String toString() {
                    return "FieldMessageContext [" + field + "]";
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object[] messageArgs = ValidationMessageHelper.getMessageArgs(this.result);
                Message message = MessageSystem.getMessageFactory().getMessage("-1528", messageArgs);
                message.setContext(this.getFieldMessageContext(this.field));
                for (Map.Entry<ValidationResult, ValidateContext> entry : this.result.entrySet()) {
                    ValidateContext validateContext = entry.getValue();
                    if (this.result.size() > 1) {
                        Message childMessage = MessageSystem.getMessageFactory().getMessage(entry.getKey().getMsgNumber(), entry.getKey().getMsgArgs());
                        childMessage.setContext((MessageContext)validateContext);
                        message.addMessage(childMessage);
                        continue;
                    }
                    message = MessageSystem.getMessageFactory().getMessage(entry.getKey().getMsgNumber(), entry.getKey().getMsgArgs());
                    message.setContext((MessageContext)validateContext);
                }
                MessageDispatcher dispatcher = StateController.this.getMessageDispatcher();
                dispatcher.dispatch(message);
            }
            finally {
                StateController.this.getActionMethodRunner().releaseGui();
            }
        }
    }
}

