/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.rpc;

import no.esito.jvine.rpc.ActualParameter;
import no.esito.log.Logger;
import no.g9.client.core.action.ParameterBinding;
import no.g9.support.convert.ConvertException;
import no.g9.support.convert.Converter;

public class ParameterBindingImpl<A>
implements ParameterBinding<A> {
    private final Converter<A, ?> converter;
    private final ActualParameter<A> actualParameter;
    private final boolean isReturnValue;
    private final String formalParameterName;
    private static final Logger log = Logger.getLogger(ParameterBinding.class);

    public static <A> ParameterBinding<A> getBinding(String formalParameterName, ActualParameter<A> actualParameter, Converter<A, ?> converter, boolean isReturnValue) {
        return new ParameterBindingImpl<A>(formalParameterName, actualParameter, converter, isReturnValue);
    }

    public static <A> ParameterBinding<A> getBinding(String formalParameterName, ActualParameter<A> actualParameter, Converter<A, ?> converter) {
        return new ParameterBindingImpl<A>(formalParameterName, actualParameter, converter, false);
    }

    public ParameterBindingImpl(String formalParameterName, ActualParameter<A> actualParameter, Converter<A, ?> converter, boolean isReturnValue) {
        this.formalParameterName = formalParameterName;
        this.actualParameter = actualParameter;
        this.converter = converter;
        this.isReturnValue = isReturnValue;
    }

    @Override
    public final Converter<A, ?> getConverter() {
        return this.converter;
    }

    @Override
    public final boolean hasConverter() {
        return this.converter != null;
    }

    @Override
    public ActualParameter<A> getActualParameter() {
        return this.actualParameter;
    }

    @Override
    public boolean isReturnValue() {
        return this.isReturnValue;
    }

    @Override
    public String getFormalParameterName() {
        return this.formalParameterName;
    }

    @Override
    public <F> F getFormalParameterValue() throws ConvertException {
        Object actualParameterValue = ((ActualParameter)this.getActualParameter()).getParameterValue();
        if (this.hasConverter()) {
            Converter<A, ?> conv = this.getConverter();
            return (F)conv.fromModel(actualParameterValue, null);
        }
        return (F)actualParameterValue;
    }

    @Override
    public <F> A getActualParameterValue(F formalParameterValue) throws ConvertException {
        log.debug((Object)("Getting actual parameter value from formal value: " + formalParameterValue + " (class: " + formalParameterValue.getClass() + ")"));
        if (this.hasConverter()) {
            Converter<A, ?> conv = this.getConverter();
            log.debug((Object)("Using " + conv + " to convert formal value."));
            return (A)conv.toModel(formalParameterValue, null);
        }
        log.debug((Object)"No converter - attemting a cast.");
        return (A)formalParameterValue;
    }

    @Override
    public A obtainParameterValue() {
        if (!((ActualParameter)this.getActualParameter()).isObtained()) {
            ((ActualParameter)this.getActualParameter()).setParameterValue(((ActualParameter)this.getActualParameter()).obtainValue());
        }
        return (A)((ActualParameter)this.getActualParameter()).getParameterValue();
    }

    public String toString() {
        return "ParameterBindingImpl [" + (this.actualParameter != null ? "actualParameter=" + this.actualParameter + ", " : "") + (this.converter != null ? "converter=" + this.converter + ", " : "") + (this.formalParameterName != null ? "formalParameterName=" + this.formalParameterName + ", " : "") + "isReturnValue=" + this.isReturnValue + "]";
    }

    @Override
    public void setActualParameterValue(A actualParameterValue) {
        ((ActualParameter)this.getActualParameter()).setParameterValue(actualParameterValue);
    }

    @Override
    public <F> void setFormalParameterValue(F formalParameterValue) throws ConvertException {
        A actualParameterValue = null;
        if (formalParameterValue != null) {
            actualParameterValue = this.getActualParameterValue(formalParameterValue);
        }
        this.setActualParameterValue(actualParameterValue);
    }
}

