/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.HashMap;
import java.util.Map;
import no.g9.client.core.action.ActionHook;
import no.g9.client.core.action.ActionHookList;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.action.RemoteServiceTarget;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogController;
import no.g9.support.ActionType;
import no.g9.support.action.ActionTarget;

public class ActionFactory {
    private Map<ActionHookKey, ActionHookList<?>> hookMap = new HashMap();

    public <T> G9Action<T> getAction(ActionType actionType, ActionTarget target, Class<T> targetType, ActionTask<T> actionTask, DialogController dialogController) {
        G9Action<T> action = new G9Action<T>(actionType, target, actionTask, targetType, dialogController);
        ActionHookKey hookKey = new ActionHookKey(actionType, target);
        ActionHookList<?> actionHookList = this.hookMap.get(hookKey);
        action.setActionHookList(actionHookList);
        return action;
    }

    public G9Action<?> getInvokeAction(RemoteServiceTarget rst, DialogController dialogController) {
        G9Action<Object> action = new G9Action<Object>(ActionType.INVOKE, (ActionTarget)rst, rst.getActionTask(), Object.class, dialogController);
        ActionHookKey hookKey = new ActionHookKey(ActionType.INVOKE, rst.getService());
        ActionHookList<?> actionHooks = this.hookMap.get(hookKey);
        action.setActionHookList(actionHooks);
        return action;
    }

    public <T> G9Action<T> getAction(ActionType actionType, ActionTarget target, Class<T> targetType, ActionTask<T> actionTask, ApplicationController applicationController) {
        G9Action<T> action = new G9Action<T>(actionType, target, actionTask, targetType, applicationController);
        ActionHookKey hookKey = new ActionHookKey(actionType, target);
        ActionHookList<?> actionHooks = this.hookMap.get(hookKey);
        action.setActionHookList(actionHooks);
        return action;
    }

    public <T> void registerHook(ActionTarget actionTarget, ActionType actionType, ActionHook<T> hook) {
        ActionHookKey key = new ActionHookKey(actionType, actionTarget);
        ActionHookList<Object> hooks = this.hookMap.get(key);
        if (hooks == null) {
            hooks = new ActionHookList();
            this.hookMap.put(key, hooks);
        }
        hooks.getHooks().add(hook);
    }

    public ActionHookList<?> getActionHookList(ActionTarget actionTarget, ActionType actionType) {
        ActionHookKey key = new ActionHookKey(actionType, actionTarget);
        return this.hookMap.get(key);
    }

    private static class ActionHookKey {
        private final ActionType actionType;
        private final Object actionTarget;
        private final int hashCode;

        ActionHookKey(ActionType actionType, Object actionTarget) {
            this.actionType = actionType;
            this.actionTarget = actionTarget;
            int caclHash = 17;
            caclHash = caclHash * 37 + actionType.hashCode();
            this.hashCode = caclHash = caclHash * 37 + actionTarget.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ActionHookKey)) {
                return false;
            }
            ActionHookKey other = (ActionHookKey)obj;
            return this.actionType.equals((Object)other.actionType) && this.actionTarget.equals(other.actionTarget);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "[" + this.actionType + " " + this.actionTarget + "]";
        }
    }
}

