/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.esito.log.Logger;
import no.g9.client.core.action.ActionHookList;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.Checkable;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.action.ThreadType;
import no.g9.client.core.controller.DialogController;
import no.g9.support.ActionType;
import no.g9.support.action.ActionTarget;

public class CheckableAction<V>
extends G9Action<V> {
    private List<Checkable> checkableHooks = new ArrayList<Checkable>();
    private static Logger log = Logger.getLogger(CheckableAction.class);
    protected Callable<Void> checking = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            if (!CheckableAction.this.CANCELLED) {
                ActionType checkActionType = this.getCheckActionType();
                ActionTask<Boolean> checkActionTask = JVineController.getInstance(CheckableAction.this.getController()).getCheckDialogTask(checkActionType, CheckableAction.this.getActionTarget());
                checkActionTask.FLAG = CheckableAction.this.getFlag();
                Boolean checkResult = (Boolean)checkActionTask.call();
                if (checkResult == null) {
                    checkResult = Boolean.FALSE;
                    log.info((Object)(CheckableAction.this + " check action failed. " + "Using default value false"));
                }
                if (!CheckableAction.this.checked(checkResult).booleanValue()) {
                    CheckableAction.this.cancel();
                }
                log.info((Object)(CheckableAction.this + " checked"));
            }
            return null;
        }

        private ActionType getCheckActionType() {
            switch (CheckableAction.this.getActionType()) {
                case FIND: 
                case FINDALL: 
                case INVOKE: {
                    return ActionType.CHECK_FIND;
                }
                case INSERT: {
                    return ActionType.INSERT;
                }
                case UPDATE: {
                    return ActionType.UPDATE;
                }
                case SAVE: {
                    return ActionType.SAVE;
                }
                case DELETE: {
                    return ActionType.CHECK_DELETE;
                }
                case CLOSE: {
                    return ActionType.CHECK_CLOSE;
                }
                case CLEAR: {
                    return ActionType.CHECK_CLEAR;
                }
                case OPEN: {
                    return ActionType.OPEN;
                }
            }
            return null;
        }
    };

    protected CheckableAction(ActionType actionType, ActionTarget actionTarget, ActionTask<V> actionTask, Class<V> resultClass, DialogController dialogController) {
        super(actionType, actionTarget, actionTask, resultClass, dialogController);
    }

    @Override
    protected void setActionHookList(ActionHookList<V> actionHookList) {
        super.setActionHookList(actionHookList);
        if (actionHookList != null) {
            this.checkableHooks = actionHookList.getCheckableHooks();
        }
    }

    @Override
    List<Checkable> getCheckableHooks() {
        return this.checkableHooks;
    }

    @Override
    public V call() throws Exception {
        log.info((Object)("Starting execution of " + this));
        V result = null;
        try {
            this.checking.call();
        }
        catch (Exception e) {
            this.failed(e);
            log.info((Object)(this + " failed"), (Throwable)e);
        }
        finally {
            this.cleanUpHook();
        }
        return result;
    }

    Boolean checked(final Boolean checkResult) throws Exception {
        if (this.shouldInvokeHook() && !this.getCheckableHooks().isEmpty()) {
            String methodName = "checked";
            Class[] params = new Class[]{Boolean.class};
            ThreadType threadType = this.getThreadType(methodName, params);
            HookMethod<Boolean> checkHook = new HookMethod<Boolean>(methodName){

                @Override
                public Boolean call() throws Exception {
                    Boolean result = checkResult;
                    for (Checkable hook : CheckableAction.this.getCheckableHooks()) {
                        result = hook.checked(result);
                    }
                    return result;
                }
            };
            return hookInvoker.execute(this.getApplicationController(), threadType, checkHook);
        }
        return checkResult;
    }
}

