/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.model.CurrentRoleObject;
import no.esito.jvine.rpc.ActualParameter;
import no.esito.log.Logger;
import no.g9.client.core.action.ActionHookList;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.Displayable;
import no.g9.client.core.action.ObtainableAction;
import no.g9.client.core.action.Parameter;
import no.g9.client.core.action.ParameterBinding;
import no.g9.client.core.action.RemoteServiceTarget;
import no.g9.client.core.action.ThreadType;
import no.g9.client.core.controller.DialogController;
import no.g9.os.AttributeConstant;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.action.ActionTarget;

public class DisplayableAction<V>
extends ObtainableAction<V> {
    private static Logger log = Logger.getLogger(DisplayableAction.class);
    private List<Displayable> displayableHooks = new ArrayList<Displayable>();
    private List<CurrentRoleObject> currentInstanceList;

    protected DisplayableAction(ActionType actionType, ActionTarget actionTarget, ActionTask<V> actionTask, Class<V> resultClass, DialogController dialogController) {
        super(actionType, actionTarget, actionTask, resultClass, dialogController);
    }

    @Override
    protected void setActionHookList(ActionHookList<V> actionHookList) {
        super.setActionHookList(actionHookList);
        if (actionHookList != null) {
            this.displayableHooks = actionHookList.getDisplayableHooks();
        }
    }

    @Override
    List<Displayable> getDisplayableHooks() {
        return this.displayableHooks;
    }

    private void clearRemoteTarget(RemoteServiceTarget target) {
        switch (this.getReturnType(target)) {
            case ATTRIBUTE: {
                AttributeConstant attribute = this.getInvokeReturnAttribute(target);
                this.getController().setFieldValue(attribute, null);
                break;
            }
            case ROLE: {
                RoleConstant role = this.getInvokeReturnRole(target);
                this.getController().clear(role, true);
                break;
            }
        }
    }

    private ActualParameter.ParameterType getReturnType(RemoteServiceTarget target) {
        ParameterBinding returnParameter = target.getReturnParameter();
        Parameter actualParameter = returnParameter.getActualParameter();
        if (actualParameter instanceof ActualParameter) {
            ActualParameter tmp = (ActualParameter)actualParameter;
            return tmp.getParameterType();
        }
        return null;
    }

    private RoleConstant getInvokeReturnRole(RemoteServiceTarget target) {
        ParameterBinding returnParameter = target.getReturnParameter();
        Parameter actualParameter = returnParameter.getActualParameter();
        if (actualParameter instanceof ActualParameter) {
            ActualParameter tmp = (ActualParameter)actualParameter;
            return tmp.getRole();
        }
        return null;
    }

    private AttributeConstant getInvokeReturnAttribute(RemoteServiceTarget target) {
        ParameterBinding returnParameter = target.getReturnParameter();
        Parameter actualParameter = returnParameter.getActualParameter();
        if (actualParameter instanceof ActualParameter) {
            ActualParameter tmp = (ActualParameter)actualParameter;
            return tmp.getAttribute();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        log.info((Object)("Starting execution of " + this));
        V result = null;
        try {
            this.checking.call();
            boolean keepCurrentInfo = this.isSaveAction();
            if (keepCurrentInfo) {
                this.saveCurrentInstances();
            }
            Object obtainResult = this.obtaining.call();
            this.getActionTask().setTaskObject(obtainResult);
            Clear clearing = new Clear();
            clearing.call();
            Display displaying = new Display(this.getActionTask().getTaskObject());
            displaying.call();
        }
        catch (Exception e) {
            this.failed(e);
        }
        finally {
            this.cleanUpHook();
        }
        return result;
    }

    private void restoreCurrentInstances() {
        block0: for (CurrentRoleObject cro : this.currentInstanceList) {
            JVineController controller = JVineController.getInstance(this.getController());
            OSNode node = controller.getOSNode(cro.getRole());
            Collection allInstances = node.getAllInstances();
            for (Object object : allInstances) {
                if (!object.equals(cro.getCurrent())) continue;
                this.getController().setCurrentInstance(cro.getRole(), object);
                continue block0;
            }
        }
    }

    private void saveCurrentInstances() {
        this.currentInstanceList = new ArrayList<CurrentRoleObject>();
        String target = this.getActionTarget().toString();
        Object roleConst = this.getController().getOSConst(target);
        OSNode targetNode = JVineController.getInstance(this.getController()).getOSNode((RoleConstant)roleConst);
        this.currentInstanceList = targetNode.getCurrentObjectList();
    }

    void displayed() throws Exception {
        if (this.shouldInvokeHook() && !this.getDisplayableHooks().isEmpty()) {
            String methodName = "displayed";
            ThreadType threadType = this.getThreadType(methodName, new Class[0]);
            HookMethod<Void> displayHook = new HookMethod<Void>(methodName){

                @Override
                public Void call() throws Exception {
                    for (Displayable hook : DisplayableAction.this.getDisplayableHooks()) {
                        hook.displayed();
                    }
                    return null;
                }
            };
            hookInvoker.execute(this.getApplicationController(), threadType, displayHook);
        }
    }

    void cleared() throws Exception {
        if (this.shouldInvokeHook() && !this.getDisplayableHooks().isEmpty()) {
            String methodName = "cleared";
            ThreadType threadType = this.getThreadType(methodName, new Class[0]);
            HookMethod<Void> clearHook = new HookMethod<Void>(methodName){

                @Override
                public Void call() throws Exception {
                    for (Displayable hook : DisplayableAction.this.getDisplayableHooks()) {
                        hook.cleared();
                    }
                    return null;
                }
            };
            hookInvoker.execute(this.getApplicationController(), threadType, clearHook);
        }
    }

    private class Clear
    implements Callable<Void> {
        private Clear() {
        }

        @Override
        public Void call() throws Exception {
            if (!DisplayableAction.this.CANCELLED) {
                ActionType actionType = DisplayableAction.this.getActionType();
                switch (actionType) {
                    case FIND: 
                    case FINDALL: {
                        DisplayableAction.this.getController().clearKeepKeys((RoleConstant)DisplayableAction.this.getActionTarget());
                        break;
                    }
                    case INVOKE: {
                        DisplayableAction.this.clearRemoteTarget((RemoteServiceTarget)DisplayableAction.this.getActionTarget());
                        break;
                    }
                    case DELETE: {
                        DisplayableAction.this.getController().clear((RoleConstant)DisplayableAction.this.getActionTarget(), true);
                        break;
                    }
                }
            }
            DisplayableAction.this.cleared();
            return null;
        }
    }

    private class Display
    implements Callable<Void> {
        Object toDisplay;

        Display(Object toDisplay) {
            this.toDisplay = toDisplay;
        }

        @Override
        public Void call() throws Exception {
            if (!DisplayableAction.this.CANCELLED) {
                JVineController jVineController = JVineController.getInstance(DisplayableAction.this.getController());
                ActionTask<Void> displayActionTask = jVineController.getDisplayDialogTask(DisplayableAction.this.getActionTarget(), DisplayableAction.this.getActionType());
                displayActionTask.setTaskObject(this.toDisplay);
                displayActionTask.call();
                if (DisplayableAction.this.isSaveAction()) {
                    DisplayableAction.this.restoreCurrentInstances();
                }
                DisplayableAction.this.displayed();
                log.info((Object)(DisplayableAction.this + " displayed"));
            }
            return null;
        }
    }
}

