/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import no.esito.jvine.action.CancelException;
import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineAppController;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.model.CurrentRoleObject;
import no.esito.jvine.view.MessageUtil;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.ActionHook;
import no.g9.client.core.action.ActionHookList;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.Cancelling;
import no.g9.client.core.action.Checkable;
import no.g9.client.core.action.Checking;
import no.g9.client.core.action.Clearing;
import no.g9.client.core.action.Display;
import no.g9.client.core.action.Displayable;
import no.g9.client.core.action.EventContext;
import no.g9.client.core.action.Finishing;
import no.g9.client.core.action.HookInvoker;
import no.g9.client.core.action.Hookable;
import no.g9.client.core.action.Initializing;
import no.g9.client.core.action.Obtainable;
import no.g9.client.core.action.Obtaining;
import no.g9.client.core.action.Performing;
import no.g9.client.core.action.Succeeding;
import no.g9.client.core.action.ThreadInfo;
import no.g9.client.core.action.ThreadType;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogController;
import no.g9.exception.G9BaseException;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.message.ReplySetType;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.ActionTypeInfo;
import no.g9.support.HookType;
import no.g9.support.action.ActionTarget;

public class G9Action<V>
implements Callable<V> {
    final MessageUtil messageUtil = (MessageUtil)ServiceLoader.getService(MessageUtil.class);
    private static Map<String, ThreadType> defaultAnnotations;
    private EventContext event;
    private Object actionSetupValue;
    private Boolean FLAG = Boolean.FALSE;
    protected static final HookInvoker hookInvoker;
    private ActionHookList<V> actionHookList;
    private ActionTarget actionTarget;
    private ActionType actionType;
    protected ActionTask<V> actionTask;
    private static Logger log;
    private Class<V> resultClass;
    private DialogController dialogController;
    ApplicationController applicationController;
    private Message DEFAULT_FAILED_MSG;
    protected volatile boolean CANCELLED = false;
    private List<CurrentRoleObject> currentInstanceList;

    public MessageUtil getMessageUtil() {
        return this.messageUtil;
    }

    public Boolean getFlag() {
        return this.FLAG;
    }

    public void setFlag(Boolean flagValue) {
        this.FLAG = flagValue;
    }

    public EventContext getEvent() {
        return this.event;
    }

    public void setEvent(EventContext event) {
        this.event = event;
    }

    public HookInvoker getHookInvoker() {
        return hookInvoker;
    }

    public static synchronized Logger getLog() {
        return log;
    }

    public static synchronized void setLog(Logger log) {
        G9Action.log = log;
    }

    public Class<V> getResultClas() {
        return this.resultClass;
    }

    public DialogController getDialogController() {
        return this.dialogController;
    }

    protected final boolean isInvokeHooksOn() {
        JVineAppController appCtrl = JVineAppController.getInstance(this.applicationController);
        boolean applicationHooks = appCtrl.isInvokeHooksOn();
        if (log.isDebugEnabled() && !applicationHooks) {
            log.debug((Object)(this + " all hooks are switched off!"));
        }
        if (this.getController() == null) {
            return applicationHooks;
        }
        JVineController dlgCtrl = JVineController.getInstance(this.getController());
        boolean dlgHooks = dlgCtrl.isInvokeHooksOn();
        if (log.isDebugEnabled() && !dlgHooks && applicationHooks) {
            log.debug((Object)(this + " hooks are turned off!"));
        }
        return applicationHooks && dlgHooks;
    }

    protected G9Action(ActionType actionType, ActionTarget actionTarget, ActionTask<V> actionTask, Class<V> resultClass, DialogController dialogController) {
        this(actionType, actionTarget, actionTask, resultClass);
        this.dialogController = dialogController;
        this.applicationController = dialogController.getApplicationController();
    }

    protected G9Action(ActionType actionType, ActionTarget actionTarget, ActionTask<V> actionTask, Class<V> resultClass, ApplicationController applicationController) {
        this(actionType, actionTarget, actionTask, resultClass);
        this.dialogController = null;
        this.applicationController = applicationController;
    }

    private G9Action(ActionType actionType, ActionTarget actionTarget, ActionTask<V> actionTask, Class<V> resultClass) {
        this.actionType = actionType;
        this.actionTarget = actionTarget;
        this.actionTask = actionTask;
        this.resultClass = resultClass;
    }

    synchronized Message getDefaultFailedMessage(Throwable cause) {
        G9BaseException gbe;
        Message errMsg;
        if ((cause = this.unwrap(cause)) instanceof G9BaseException && (errMsg = (gbe = (G9BaseException)cause).getErrMsg()) != null) {
            ReplySetType validReplies = errMsg.getValidReplies();
            if (validReplies == null || validReplies.equals((Object)ReplySetType.REPLSET_NONE)) {
                errMsg.setValidReplies(ReplySetType.REPLSET_OK);
            }
            return errMsg;
        }
        if (this.DEFAULT_FAILED_MSG == null) {
            this.DEFAULT_FAILED_MSG = MessageSystem.getMessageFactory().getMessage("-1524", new Object[]{this});
        }
        return this.DEFAULT_FAILED_MSG;
    }

    public final DialogController getController() {
        return this.dialogController;
    }

    public final ApplicationController getApplicationController() {
        return this.applicationController;
    }

    protected ActionTask<V> getActionTask() {
        return this.actionTask;
    }

    public synchronized boolean isCancelled() {
        return this.CANCELLED;
    }

    public synchronized void cancel() {
        log.info((Object)("Cancelling " + this));
        this.CANCELLED = true;
    }

    public Object getActionSetupValue() {
        return this.actionSetupValue;
    }

    public void setActionSetupValue(Object setupValue) {
        this.actionSetupValue = setupValue;
    }

    List<Checkable> getCheckableHooks() {
        return this.getActionHookList().getCheckableHooks();
    }

    List<Obtainable> getObtainableHooks() {
        return this.getActionHookList().getObtainableHooks();
    }

    List<Displayable> getDisplayableHooks() {
        return this.getActionHookList().getDisplayableHooks();
    }

    boolean isSaveAction() {
        switch (this.getActionType()) {
            case SAVE: 
            case INSERT: 
            case UPDATE: {
                return true;
            }
        }
        return false;
    }

    protected List<CurrentRoleObject> getCurrentInstanceList() {
        return this.currentInstanceList;
    }

    private void saveCurrentInstances() {
        this.currentInstanceList = new ArrayList<CurrentRoleObject>();
        String target = this.getActionTarget().toString();
        Object roleConst = this.getController().getOSConst(target);
        OSNode targetNode = JVineController.getInstance(this.getController()).getOSNode((RoleConstant)roleConst);
        this.currentInstanceList = targetNode.getCurrentObjectList();
    }

    private boolean hasActionType(HookType hook) throws SecurityException, NoSuchFieldException {
        Annotation[] annotations = ActionType.class.getField(this.getActionType().name()).getAnnotations();
        HookType[] val = null;
        for (Annotation an : annotations) {
            if (!(an instanceof ActionTypeInfo)) continue;
            ActionTypeInfo info = (ActionTypeInfo)an;
            for (HookType hookType : val = info.value()) {
                if (hookType != hook) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        log.info((Object)("Starting execution of " + this));
        V result = null;
        try {
            boolean keepCurrentInfo;
            Initializing initializing = new Initializing(this);
            initializing.call();
            if (this.hasActionType(HookType.CHECKABLE) && !this.isCancelled()) {
                Checking checking = new Checking(this);
                checking.call();
            }
            if ((keepCurrentInfo = this.isSaveAction()) && !this.isCancelled()) {
                this.saveCurrentInstances();
            }
            if (this.hasActionType(HookType.OBTAINABLE) && !this.isCancelled()) {
                Obtaining obtaining = new Obtaining(this);
                Object[] obtainResult = obtaining.call();
                this.getActionTask().setTaskObject(obtainResult);
            }
            if (!this.isCancelled()) {
                Performing performing = new Performing(this);
                try {
                    result = performing.call();
                }
                catch (CancelException ce) {
                    log.info((Object)(this + " cancelled while performing."));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Cancel trace:", (Throwable)ce);
                    }
                    this.cancel();
                }
            }
            if (this.hasActionType(HookType.CLEARABLE) && !this.isCancelled()) {
                Clearing clearing = new Clearing(this);
                clearing.call();
            }
            if (this.hasActionType(HookType.DISPLAYABLE) && !this.isCancelled()) {
                Display displaying = new Display(this, this.getActionTask().getTaskObject());
                displaying.call();
            }
            if (!this.isCancelled()) {
                Succeeding succeeding = new Succeeding(this);
                succeeding.call();
            }
            if (this.isCancelled()) {
                Cancelling cancelling = new Cancelling(this);
                cancelling.call();
            }
        }
        catch (Exception e) {
            this.failed(e);
        }
        finally {
            Finishing finishing = new Finishing(this);
            finishing.call();
            this.cleanUpHook();
        }
        return result;
    }

    protected void cleanUpHook() throws InterruptedException {
        if (this.hasHook()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " cleaning up hook"));
            }
            this.getActionHookList().removeCurrentAction(this);
            this.setActionHookList(null);
        }
    }

    public ActionTarget getActionTarget() {
        return this.actionTarget;
    }

    void setActionTarget(ActionTarget actionTarget) {
        this.actionTarget = actionTarget;
    }

    protected ActionHookList<V> getActionHookList() {
        return this.actionHookList;
    }

    protected void setActionHookList(ActionHookList<V> actionHookList) {
        this.actionHookList = actionHookList;
    }

    Void failed(final Throwable cause) throws Exception {
        log.warn((Object)("Failed to execute " + this), cause);
        Message msg = this.getDefaultFailedMessage(cause);
        if (this.shouldInvokeHook()) {
            String methodName = "failed";
            ThreadType threadType = this.getThreadType(methodName, Throwable.class);
            HookMethod<Message> invocation = new HookMethod<Message>(methodName){

                @Override
                public Message call() {
                    Message failed = null;
                    try {
                        for (ActionHook hook : G9Action.this.getActionHookList().getHooks()) {
                            failed = hook.failed(cause, failed);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed hook threw exception. Falling back to default error message", (Throwable)e);
                        failed = G9Action.this.getDefaultFailedMessage(cause);
                    }
                    return failed;
                }
            };
            msg = hookInvoker.execute(this.applicationController, threadType, invocation);
        }
        if (msg != null) {
            this.dialogController.dispatchMessage(msg);
        }
        return null;
    }

    protected ThreadType getThreadType(String methodName, Class ... params) {
        ThreadType type = ThreadType.GUI;
        SecurityException ex = null;
        try {
            ThreadInfo annotation = null;
            if (this.actionHookList != null) {
                annotation = this.actionHookList.getHooks().get(0).getClass().getMethod(methodName, params).getAnnotation(ThreadInfo.class);
            }
            type = annotation == null ? defaultAnnotations.get(methodName) : annotation.value();
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            type = defaultAnnotations.get(methodName);
        }
        if (ex != null) {
            String msg = "Caught exception while trying to infere thread info on hook method";
            throw new G9ClientFrameworkException(msg, (Throwable)ex);
        }
        return type;
    }

    protected boolean hasHook() {
        if (this.actionHookList == null) {
            return false;
        }
        return !this.actionHookList.getHooks().isEmpty();
    }

    protected boolean shouldInvokeHook() {
        return this.isInvokeHooksOn() && this.hasHook();
    }

    public String toString() {
        return this.actionType + " " + this.actionTarget;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    protected Class<V> getResultClass() {
        return this.resultClass;
    }

    private Throwable unwrap(Throwable t) {
        Throwable unwrapped = this.unwrapToG9Base(t);
        if (unwrapped instanceof G9BaseException) {
            return unwrapped;
        }
        return t;
    }

    private Throwable unwrapToG9Base(Throwable t) {
        InvocationTargetException it;
        if (t instanceof G9BaseException) {
            return t;
        }
        if (t.getCause() != null) {
            return this.unwrapToG9Base(t.getCause());
        }
        if (t instanceof InvocationTargetException && (it = (InvocationTargetException)t).getTargetException() != null) {
            return this.unwrapToG9Base(t.getCause());
        }
        return t;
    }

    static {
        Class[] interfaces;
        defaultAnnotations = new HashMap<String, ThreadType>();
        for (Class clazz : interfaces = new Class[]{Hookable.class, Checkable.class, Obtainable.class, Displayable.class}) {
            for (Method m : clazz.getDeclaredMethods()) {
                ThreadInfo annotation = m.getAnnotation(ThreadInfo.class);
                if (annotation == null) continue;
                defaultAnnotations.put(m.getName(), annotation.value());
            }
        }
        hookInvoker = (HookInvoker)ServiceLoader.getService(HookInvoker.class);
        log = Logger.getLogger(G9Action.class);
    }
}

