/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.esito.log.Logger;
import no.g9.client.core.action.ActionHookList;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.CheckableAction;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.action.Obtainable;
import no.g9.client.core.action.ThreadType;
import no.g9.client.core.controller.DialogController;
import no.g9.support.ActionType;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;
import no.g9.support.action.ActionTarget;

public class ObtainableAction<V>
extends CheckableAction<V> {
    private List<Obtainable> obtainableHooks = new ArrayList<Obtainable>();
    private static Logger log = Logger.getLogger(ObtainableAction.class);
    protected Callable<Object[]> obtaining = new Callable<Object[]>(){

        @Override
        public Object[] call() throws Exception {
            ObjectSelection objectSelection = null;
            ClientContext clientContext = null;
            if (!ObtainableAction.this.CANCELLED) {
                JVineController jVineController = JVineController.getInstance(ObtainableAction.this.getController());
                ActionTask<ObjectSelection> obtainActionTask = jVineController.getObtainDialogTask(ObtainableAction.this.getActionTarget(), ObtainableAction.this.getActionType());
                G9Action<ObjectSelection> obtainAction = jVineController.getAction(ActionType.OBTAIN, ObtainableAction.this.getActionTarget(), ObjectSelection.class, obtainActionTask);
                objectSelection = obtainAction.call();
                objectSelection = ObtainableAction.this.obtained(objectSelection);
                clientContext = ObtainableAction.this.getController().getApplicationController().getClientContext();
                clientContext = ObtainableAction.this.contextHook(clientContext);
                log.info((Object)(ObtainableAction.this + " obtained"));
            }
            Object[] returnValue = new Object[]{objectSelection, clientContext};
            return returnValue;
        }
    };

    protected ObtainableAction(ActionType actionType, ActionTarget actionTarget, ActionTask<V> actionTask, Class<V> resultClass, DialogController dialogController) {
        super(actionType, actionTarget, actionTask, resultClass, dialogController);
    }

    @Override
    protected void setActionHookList(ActionHookList<V> actionHookList) {
        super.setActionHookList(actionHookList);
        if (actionHookList != null) {
            this.obtainableHooks = actionHookList.getObtainableHooks();
        }
    }

    @Override
    List<Obtainable> getObtainableHooks() {
        return this.obtainableHooks;
    }

    @Override
    public V call() throws Exception {
        log.info((Object)("Starting execution of " + this));
        V result = null;
        try {
            this.checking.call();
            Object[] obtainResult = this.obtaining.call();
            this.getActionTask().setTaskObject(obtainResult);
        }
        catch (Exception e) {
            this.failed(e);
        }
        finally {
            this.cleanUpHook();
        }
        return result;
    }

    ObjectSelection obtained(final ObjectSelection objectSelection) throws Exception {
        if (this.shouldInvokeHook() && !this.getObtainableHooks().isEmpty()) {
            String methodName = "obtained";
            Class[] params = new Class[]{ObjectSelection.class};
            ThreadType threadType = this.getThreadType(methodName, params);
            HookMethod<ObjectSelection> obtainHook = new HookMethod<ObjectSelection>(methodName){

                @Override
                public ObjectSelection call() throws Exception {
                    ObjectSelection os = objectSelection;
                    for (Obtainable hook : ObtainableAction.this.getObtainableHooks()) {
                        os = hook.obtained(os);
                    }
                    return os;
                }
            };
            return hookInvoker.execute(this.getApplicationController(), threadType, obtainHook);
        }
        return objectSelection;
    }

    ClientContext contextHook(final ClientContext clientContext) throws Exception {
        if (this.shouldInvokeHook() && !this.getObtainableHooks().isEmpty()) {
            String methodName = "contextHook";
            Class[] params = new Class[]{ClientContext.class};
            ThreadType threadType = this.getThreadType(methodName, params);
            HookMethod<ClientContext> contextHook = new HookMethod<ClientContext>(methodName){

                @Override
                public ClientContext call() throws Exception {
                    ClientContext ctx = clientContext;
                    for (Obtainable hook : ObtainableAction.this.getObtainableHooks()) {
                        ctx = hook.contextHook(ctx);
                    }
                    return ctx;
                }
            };
            return hookInvoker.execute(this.getApplicationController(), threadType, contextHook);
        }
        return clientContext;
    }
}

