/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.communication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import no.g9.client.core.communication.SystemMessage;
import no.g9.exception.G9BaseException;

public class CommunicationError {
    public final SystemMessage failingMessage;
    public final Integer statusCode;
    public final String description;

    public CommunicationError(String jsonRepresentation) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tree = mapper.readTree(jsonRepresentation);
            String receiver = tree.findValue("receiver").textValue();
            String port = tree.findValue("port").textValue();
            String payload = tree.findValue("payload").textValue();
            this.failingMessage = new SystemMessage(receiver, port, payload);
            this.statusCode = tree.findValue("statusCode").intValue();
            this.description = tree.findValue("description").textValue();
        }
        catch (IOException e) {
            throw new G9BaseException("IOException when reading the error handler object", (Throwable)e);
        }
    }
}

