/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.communication;

import no.g9.support.ActionType;

public class G9ActionPayload {
    public final ActionType actionType;
    public final String payload;
    public final boolean isValid;

    public G9ActionPayload(String payload) {
        String[] split = payload.split("[\\/\\\\]", 2);
        String action = split.length >= 1 ? split[0] : "";
        supportedActionType supType = supportedActionType.valueOf(action);
        if (supType != supportedActionType.Not_supported) {
            this.actionType = supType.actionType;
            this.isValid = true;
        } else {
            this.actionType = null;
            this.isValid = false;
        }
        this.payload = split.length >= 2 ? split[1] : "";
    }

    public G9ActionPayload(ActionType actionType, String containedPayload) {
        this.actionType = actionType;
        this.payload = containedPayload;
        this.isValid = supportedActionType.Not_supported != supportedActionType.valueOf(actionType);
    }

    public String toString() {
        return this.code();
    }

    public String code() {
        supportedActionType supActionType = supportedActionType.valueOf(this.actionType);
        return (Object)((Object)supActionType) + "/" + this.payload;
    }

    public G9ActionPayload payload(String payload) {
        return new G9ActionPayload(this.actionType, payload);
    }

    private static enum supportedActionType {
        Open(ActionType.OPEN),
        Close(ActionType.CLOSE),
        Show(ActionType.SHOW),
        Hide(ActionType.HIDE),
        Activate(ActionType.ACTIVATE),
        Not_supported(null);

        public final ActionType actionType;

        private supportedActionType(ActionType actionType) {
            this.actionType = actionType;
        }

        public static supportedActionType valueOf(ActionType actionType) {
            switch (actionType) {
                case OPEN: {
                    return Open;
                }
                case CLOSE: {
                    return Close;
                }
                case SHOW: {
                    return Show;
                }
                case HIDE: {
                    return Hide;
                }
                case ACTIVATE: {
                    return Activate;
                }
            }
            return Not_supported;
        }
    }
}

