/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.controller;

import java.util.Collection;
import java.util.HashSet;
import no.esito.jvine.communication.ActionMessageCompilation;
import no.esito.util.StringUtil;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.ViewConstant;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ExternalDialogConstant
implements DialogConstant {
    private final String g9Name;
    private ActionMessageCompilation reactor;

    public ActionMessageCompilation getReactor() {
        return this.reactor;
    }

    public void setReactor(ActionMessageCompilation reactor) {
        this.reactor = reactor;
    }

    public ExternalDialogConstant(String g9Name) {
        Assert.notNull((Object)g9Name, (String)"The G9 name for the dialog cannot be null");
        this.g9Name = g9Name;
    }

    @Override
    public ViewConstant getParent() {
        return null;
    }

    @Override
    public Collection<ViewConstant> getAll() {
        HashSet<ViewConstant> all = new HashSet<ViewConstant>();
        all.add(this);
        return all;
    }

    @Override
    public String name() {
        return StringUtil.unCamelize((String)this.g9Name, (String)"_").toUpperCase();
    }

    @Override
    public String getG9Name() {
        return this.g9Name;
    }

    @Override
    public String getInternalName() {
        return StringUtils.uncapitalize((String)this.g9Name);
    }

    public String toString() {
        return this.getInternalName();
    }

    @Override
    public String getTitle() {
        return StringUtil.unCamelize((String)this.g9Name);
    }

    @Override
    public DialogConstant.WindowType getWindowType() {
        return DialogConstant.WindowType.DOCUMENT_WINDOW;
    }

    @Override
    public int getMaximumNumberOfInstances() {
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.g9Name.hashCode();
        return result;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof ExternalDialogConstant)) {
            return false;
        }
        ExternalDialogConstant that2 = (ExternalDialogConstant)that;
        return this.g9Name.equals(that2.getG9Name());
    }
}

