/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.converter;

import java.util.Date;
import no.esito.log.Logger;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;
import no.g9.support.convert.ConvertException;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;

public class JodaDateTimeConverter<M>
implements AttributeConverter<M, Date> {
    private Class<M> modelType;
    private AttributeConverter<M, BaseDateTime> chainedConverter;
    private static final Logger log = Logger.getLogger(JodaDateTimeConverter.class);

    public JodaDateTimeConverter(Class<M> modelType) {
        this(null, modelType);
    }

    public JodaDateTimeConverter(AttributeConverter<M, BaseDateTime> chainedConverter, Class<M> modelType) {
        if (chainedConverter != null) {
            this.chainedConverter = chainedConverter;
            this.modelType = chainedConverter.getModelType();
        } else {
            if (modelType != DateTime.class && modelType != DateMidnight.class) {
                throw new IllegalArgumentException("The model type must be org.joda.time.DateTime or org.joda.time.DateMidnight");
            }
            this.modelType = modelType;
        }
    }

    public Date fromModel(M value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert from model: " + value));
        }
        if (this.chainedConverter != null) {
            BaseDateTime fromModel = (BaseDateTime)this.chainedConverter.fromModel(value, context);
            if (fromModel == null) {
                return null;
            }
            return fromModel.toDate();
        }
        if (value == null) {
            return null;
        }
        BaseDateTime jodaDate = (BaseDateTime)value;
        return jodaDate.toDate();
    }

    public M toModel(Date value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert to model: " + value));
        }
        BaseDateTime bdt = this.getJodaDate(value);
        if (this.chainedConverter != null) {
            return (M)this.chainedConverter.toModel((Object)bdt, context);
        }
        return (M)bdt;
    }

    private BaseDateTime getJodaDate(Date value) {
        if (value == null) {
            return null;
        }
        if (this.modelType == DateTime.class) {
            return new DateTime((Object)value);
        }
        return new DateMidnight((Object)value);
    }

    public Class<Date> getTargetType() {
        return Date.class;
    }

    public Class<M> getModelType() {
        return this.modelType;
    }
}

