/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.converter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import no.esito.log.Logger;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;
import no.g9.support.convert.ConvertException;

public class LocalDateConverter
implements AttributeConverter<LocalDate, Date> {
    private AttributeConverter<LocalDate, Date> chainedConverter;
    private static final Logger log = Logger.getLogger(LocalDateConverter.class);

    public LocalDateConverter() {
    }

    public LocalDateConverter(AttributeConverter<LocalDate, Date> chainedConverter) {
        if (chainedConverter != null) {
            this.chainedConverter = chainedConverter;
        }
    }

    public Date fromModel(LocalDate value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert from model: " + value));
        }
        if (this.chainedConverter != null) {
            Date fromModel = (Date)this.chainedConverter.fromModel((Object)value, context);
            if (fromModel == null) {
                return null;
            }
            return fromModel;
        }
        if (value == null) {
            return null;
        }
        Instant i = value.atStartOfDay(ZoneId.systemDefault()).toInstant();
        return new Date(i.toEpochMilli());
    }

    public LocalDate toModel(Date value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert to model: " + value));
        }
        if (this.chainedConverter != null) {
            return (LocalDate)this.chainedConverter.toModel((Object)value, context);
        }
        if (value == null) {
            return null;
        }
        Instant i = Instant.ofEpochMilli(value.getTime());
        return LocalDateTime.ofInstant(i, ZoneId.systemDefault()).toLocalDate();
    }

    public Class<Date> getTargetType() {
        return Date.class;
    }

    public Class<LocalDate> getModelType() {
        return LocalDate.class;
    }
}

