/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.converter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import no.esito.log.Logger;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;
import no.g9.support.convert.ConvertException;

public class LocalTimeConverter
implements AttributeConverter<LocalTime, Date> {
    private AttributeConverter<LocalTime, Date> chainedConverter;
    private static final Logger log = Logger.getLogger(LocalTimeConverter.class);
    private static final int A_YEAR = 2000;
    private static final int A_MONTH = 1;
    private static final int A_DAY = 1;

    public LocalTimeConverter() {
    }

    public LocalTimeConverter(AttributeConverter<LocalTime, Date> chainedConverter) {
        if (chainedConverter != null) {
            this.chainedConverter = chainedConverter;
        }
    }

    public Date fromModel(LocalTime value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert from model: " + value));
        }
        if (this.chainedConverter != null) {
            Date fromModel = (Date)this.chainedConverter.fromModel((Object)value, context);
            if (fromModel == null) {
                return null;
            }
            return fromModel;
        }
        if (value == null) {
            return null;
        }
        Instant i = value.atDate(LocalDate.of(2000, 1, 1)).atZone(ZoneId.systemDefault()).toInstant();
        return new Date(i.toEpochMilli());
    }

    public LocalTime toModel(Date value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert to model: " + value));
        }
        if (this.chainedConverter != null) {
            return (LocalTime)this.chainedConverter.toModel((Object)value, context);
        }
        if (value == null) {
            return null;
        }
        Instant i = Instant.ofEpochMilli(value.getTime());
        return LocalDateTime.ofInstant(i, ZoneId.systemDefault()).toLocalTime();
    }

    public Class<Date> getTargetType() {
        return Date.class;
    }

    public Class<LocalTime> getModelType() {
        return LocalTime.class;
    }
}

