/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.converter;

import no.esito.log.Logger;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;
import no.g9.support.convert.ConvertException;

public class NumberConverter<M>
implements AttributeConverter<M, String> {
    private Class<M> modelType;
    private AttributeConverter<M, Number> chainedConverter;
    private static final Logger log = Logger.getLogger(NumberConverter.class);

    public NumberConverter(Class<M> modelType) {
        this(null, modelType);
    }

    public NumberConverter(AttributeConverter<M, Number> chainedConverter, Class<M> modelType) {
        if (chainedConverter != null) {
            this.chainedConverter = chainedConverter;
            this.modelType = chainedConverter.getModelType();
        } else {
            if (modelType != Integer.class && modelType != Long.class) {
                throw new IllegalArgumentException("The model type must be Integer or Long");
            }
            this.modelType = modelType;
        }
    }

    public String fromModel(M value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert from model: " + value));
        }
        if (this.chainedConverter != null) {
            Number fromModel = (Number)this.chainedConverter.fromModel(value, context);
            if (fromModel == null) {
                return null;
            }
            return fromModel.toString();
        }
        if (value == null) {
            return null;
        }
        Number number = (Number)value;
        return number.toString();
    }

    public M toModel(String value, ConvertContext context) throws ConvertException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Convert to model: " + value));
        }
        Number number = this.getNumber(value);
        if (this.chainedConverter != null) {
            return (M)this.chainedConverter.toModel((Object)number, context);
        }
        return (M)number;
    }

    private Number getNumber(String value) {
        if (value == null) {
            return null;
        }
        if (this.modelType == Integer.class) {
            return Integer.valueOf(value);
        }
        return Long.valueOf(value);
    }

    public Class<String> getTargetType() {
        return String.class;
    }

    public Class<M> getModelType() {
        return this.modelType;
    }
}

