/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.util;

import java.util.Collections;
import java.util.List;
import no.esito.jvine.util.ViewConstantHelper;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.DialogObjectType;
import no.g9.client.core.util.TabIndexComparator;

public class DialogObjectConstantHelper {
    public static List<DialogObjectConstant> getTabOrder(DialogObjectConstant windowBlock) {
        if (!DialogObjectType.WindowBlock.equals((Object)windowBlock.getType())) {
            return null;
        }
        List<DialogObjectConstant> descendants = ViewConstantHelper.getDescendants(windowBlock);
        Collections.sort(descendants, new TabIndexComparator());
        return descendants;
    }

    public static boolean isJavaTimeType(DialogObjectConstant field) {
        return field.getAttribute().getAttributeType().getName() == "java.time.LocalDate" || field.getAttribute().getAttributeType().getName() == "java.time.LocalTime" || field.getAttribute().getAttributeType().getName() == "java.time.LocalDateTime";
    }

    public static boolean isLocalDate(DialogObjectConstant field) {
        return field.getAttribute().getAttributeType().getName() == "java.time.LocalDate";
    }

    public static boolean isLocalTime(DialogObjectConstant field) {
        return field.getAttribute().getAttributeType().getName() == "java.time.LocalTime";
    }

    public static boolean isLocalDateTime(DialogObjectConstant field) {
        return field.getAttribute().getAttributeType().getName() == "java.time.LocalDateTime";
    }

    public static boolean isJodaType(DialogObjectConstant field) {
        return field.getAttribute().getAttributeType().getName() == "org.joda.time.DateTime" || field.getAttribute().getAttributeType().getName() == "org.joda.time.DateMidnight";
    }

    public static boolean isAutoCompleteEntry(DialogObjectConstant field) {
        return field.getType() == DialogObjectType.DataComponent && "ace_AutoCompleteEntry".equals(field.getComponentType());
    }

    public static boolean isDateTimeEntry(DialogObjectConstant field) {
        return field.getType() == DialogObjectType.DataComponent && "ace_DateTimeEntry".equals(field.getComponentType());
    }
}

