/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.table;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Observable;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.ListRow;

class TableData<E extends ListRow>
extends Observable
implements List<E> {
    private List<E> list = new ArrayList();
    private boolean rowCheck = false;
    private final List<DialogObjectConstant> columns;
    private String colSep = " | ";

    public TableData(List<DialogObjectConstant> columnDefinition) {
        this.columns = Collections.unmodifiableList(columnDefinition);
    }

    @Override
    public void add(int index, E row) {
        this.checkRow(row);
        this.list.add(index, row);
        this.setChanged();
        this.notifyObservers();
    }

    boolean insert(int rowIndex, E ... row) {
        return this.addAll(rowIndex, Arrays.asList(row));
    }

    boolean insert(int rowIndex, Collection<E> rows) {
        return this.addAll(rowIndex, rows);
    }

    @Override
    public boolean add(E row) {
        this.checkRow(row);
        boolean changed = this.list.add(row);
        if (changed) {
            this.setChanged();
            this.notifyObservers();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends E> rows) {
        this.checkRow(rows);
        boolean changed = this.list.addAll(rows);
        if (changed) {
            this.setChanged();
            this.notifyObservers();
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> rows) {
        this.checkRow(rows);
        boolean changed = this.list.addAll(index, rows);
        if (changed) {
            this.setChanged();
            this.notifyObservers();
        }
        return changed;
    }

    @Override
    public void clear() {
        int currSize = this.size();
        this.list.clear();
        if (this.size() != currSize) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public E get(int index) {
        return (E)((ListRow)this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public E remove(int index) {
        ListRow changed = (ListRow)this.list.remove(index);
        if (changed != null) {
            this.setChanged();
            this.notifyObservers();
        }
        return (E)changed;
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.list.remove(o);
        if (changed) {
            this.setChanged();
            this.notifyObservers();
        }
        return changed;
    }

    boolean remove(E ... row) {
        return this.removeAll(Arrays.asList(row));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.list.removeAll(c);
        if (changed) {
            this.setChanged();
            this.notifyObservers();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.list.retainAll(c);
        if (changed) {
            this.setChanged();
            this.notifyObservers();
        }
        return changed;
    }

    @Override
    public E set(int index, E element) {
        ListRow row = (ListRow)this.list.set(index, element);
        this.setChanged();
        this.notifyObservers();
        return (E)row;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    void checkRow(E row) {
        if (this.rowCheck) {
            return;
        }
        if (row == null) {
            throw new NullPointerException();
        }
        if (!this.columns.containsAll(((ListRow)row).getFields()) && !((ListRow)row).getFields().containsAll(this.columns)) {
            String msg = "Row " + row + " does not match column definition";
            throw new IllegalArgumentException(msg);
        }
        this.rowCheck = true;
    }

    void checkRow(Collection<? extends E> rows) {
        block0: {
            Iterator<E> iterator = rows.iterator();
            if (!iterator.hasNext()) break block0;
            ListRow e = (ListRow)iterator.next();
            this.checkRow(e);
        }
    }

    void checkColumn(DialogObjectConstant columnIdentifier) {
        if (!this.columns.contains(columnIdentifier)) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableData)) {
            return false;
        }
        TableData other = (TableData)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    public String toString() {
        return "TableData size=" + this.size() + " [columns=" + this.columns + "]";
    }

    void printTable(PrintStream out) {
        this.printHeader(out);
        this.printBody(out);
    }

    private void printHeader(PrintStream out) {
        String[] headers = this.getColumns();
        String line = "";
        for (String string : headers) {
            line = line + string + this.colSep;
        }
        line = line.substring(0, line.length() - this.colSep.length());
        out.println(line);
        String lb = "";
        for (int i = 0; i < line.length(); ++i) {
            lb = lb + "-";
        }
        out.println(lb);
    }

    private String[] getColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        for (DialogObjectConstant col : this.columns) {
            cols.add(col.toString());
        }
        return cols.toArray(new String[cols.size()]);
    }

    private void printBody(PrintStream out) {
        for (ListRow row : this.list) {
            String line = "";
            for (DialogObjectConstant column : this.columns) {
                String colHeader = column.toString();
                String value = String.valueOf(row.getValue(column));
                value = this.formatValue(colHeader, value);
                line = line + value + this.colSep;
            }
            line = line.substring(0, line.length() - this.colSep.length());
            out.println(line);
        }
    }

    private String formatValue(String columnName, String cellValue) {
        if (cellValue.length() > columnName.length()) {
            cellValue = columnName.length() <= 3 ? "...".substring(0, columnName.length()) : cellValue.substring(0, columnName.length() - 3) + "...";
        } else {
            for (int i = cellValue.length() - 1; i < columnName.length() - 1; ++i) {
                cellValue = cellValue + " ";
            }
        }
        return cellValue;
    }
}

