/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.tree;

import java.text.Collator;
import java.util.Comparator;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.tree.TreeModel;
import no.g9.client.core.view.tree.TreeNode;

public class TreeNodeComparator
implements Comparator<TreeNode> {
    private TreeModel.Grouping grouping = TreeModel.Grouping.GROUPED;
    private Collator collator = Collator.getInstance();

    public TreeNodeComparator(TreeModel.Grouping grouping) {
        this.grouping = grouping;
        this.collator.setStrength(3);
    }

    @Override
    public int compare(TreeNode node1, TreeNode node2) {
        int retval = 0;
        if (node1 == null) {
            retval = node2 == null ? 0 : -1;
        } else if (node2 == null) {
            retval = 1;
        } else if (this.grouping != TreeModel.Grouping.NONE) {
            String value1 = "";
            for (DialogObjectConstant dialogObjectConstant : ((ListRow)node1.getListRow()).getFields()) {
                value1 = value1 + ((ListRow)node1.getListRow()).getValue(dialogObjectConstant);
            }
            String value2 = "";
            for (DialogObjectConstant field : ((ListRow)node2.getListRow()).getFields()) {
                value2 = value2 + ((ListRow)node2.getListRow()).getValue(field);
            }
            retval = this.collator.compare(value1.toString(), value2.toString());
            if (this.grouping == TreeModel.Grouping.GROUPED) {
                DialogObjectConstant dialogObjectConstant = node1.getNodeConst();
                DialogObjectConstant const2 = node2.getNodeConst();
                int grpval = dialogObjectConstant.toString().compareTo(const2.toString());
                if (grpval != 0) {
                    retval = grpval;
                }
            } else {
                retval *= this.grouping.value;
            }
        }
        return retval;
    }
}

