/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.spreadsheet;

import java.io.File;
import java.io.OutputStream;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.spreadsheet.G9ExcelExporter;
import no.g9.client.spreadsheet.SpreadsheetExporter;
import no.g9.client.spreadsheet.SpreadsheetService;
import no.g9.client.spreadsheet.WorkbookProvider;
import no.g9.support.ClientContext;
import no.g9.support.ObjectFactory;
import no.g9.support.ObjectSelection;
import no.g9.support.Registry;

public class DefaultSpreadsheetService
implements SpreadsheetService {
    private WorkbookProvider.WORKBOOK_FORMAT format = WorkbookProvider.WORKBOOK_FORMAT.XLSX;
    public static final String FORMAT_PARAM = "WorkbookFormat";
    private static final String EXPORTER_SUFFIX = "ExcelExporter";
    private static final String SPREADSHEET_EXPORTER = ".spreadsheetExporter";

    @Override
    public SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, File file) {
        G9ExcelExporter ee = this.getExporter(os, targetDialog);
        ee.createBook(os, file, this.format);
        return ee;
    }

    @Override
    public SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, OutputStream outputStream) {
        G9ExcelExporter ee = this.getExporter(os, targetDialog);
        ee.createBook(os, outputStream, this.format);
        return ee;
    }

    @Override
    public SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, File file, ClientContext ctx) {
        this.parseParams(ctx);
        G9ExcelExporter ee = this.getExporter(os, targetDialog);
        ee.createBook(os, file, this.format);
        return ee;
    }

    @Override
    public SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, OutputStream outputStream, ClientContext ctx) {
        this.parseParams(ctx);
        G9ExcelExporter ee = this.getExporter(os, targetDialog);
        ee.createBook(os, outputStream, this.format);
        return ee;
    }

    @Override
    public String getFileSuffix() {
        return this.format.getSuffix();
    }

    @Override
    public String getMimeType() {
        return this.format.getMimeType();
    }

    protected void parseParams(ClientContext ctx) {
        WorkbookProvider.WORKBOOK_FORMAT ctxFormat;
        if (ctx != null && (ctxFormat = (WorkbookProvider.WORKBOOK_FORMAT)((Object)ctx.getParam((Object)FORMAT_PARAM))) != null) {
            this.format = ctxFormat;
        }
    }

    protected G9ExcelExporter getExporter(ObjectSelection os, DialogConstant targetDialog) {
        String exporterName = this.getExporterName(os, targetDialog);
        return (G9ExcelExporter)ObjectFactory.newObject((String)exporterName);
    }

    private String getExporterName(ObjectSelection os, DialogConstant targetDialog) {
        String dialogName;
        String exporterName = null;
        String propFileName = os.getApplicationName() + SPREADSHEET_EXPORTER;
        Registry reg = Registry.getRegistry();
        exporterName = reg.getApplicationProperty(propFileName, dialogName = targetDialog.getG9Name());
        if (exporterName == null) {
            String propName = "ServiceApplication." + os.getApplicationName() + "." + "DefaultSpreadsheetExporterPackage";
            exporterName = reg.getG9Property(propName) + "." + dialogName.toLowerCase() + "." + dialogName + EXPORTER_SUFFIX;
        }
        return exporterName;
    }
}

