/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.spreadsheet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import no.esito.util.ServiceLoader;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.DialogObjectType;
import no.g9.client.core.view.table.ListRowComparator;
import no.g9.client.spreadsheet.ExportElement;
import no.g9.client.spreadsheet.G9ExcelCell;
import no.g9.client.spreadsheet.SpreadsheetExporter;
import no.g9.client.spreadsheet.TableColumnData;
import no.g9.client.spreadsheet.WorkbookProvider;
import no.g9.os.AttributeConstant;
import no.g9.os.OSRole;
import no.g9.os.RoleConstant;
import no.g9.service.G9Spring;
import no.g9.support.ObjectSelection;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.ss.util.WorkbookUtil;
import org.joda.time.ReadableDateTime;

public abstract class G9ExcelExporter
implements SpreadsheetExporter,
Comparator<Object>,
Serializable {
    protected Map<DialogObjectConstant, ExportElement> elements = new HashMap<DialogObjectConstant, ExportElement>();
    private WorkbookProvider workbookProvider;
    private Workbook workbook;
    private boolean labelAsBold = false;
    private DialogObjectConstant[] listColumns;
    private int[] sortPriority;
    private ListRowComparator.Sorting[] sorting;

    public WorkbookProvider getWorkbookProvider() {
        if (this.workbookProvider == null) {
            this.workbookProvider = (WorkbookProvider)ServiceLoader.getService(WorkbookProvider.class);
        }
        return this.workbookProvider;
    }

    public void setWorkbookProvider(WorkbookProvider workbookProvider) {
        this.workbookProvider = workbookProvider;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    protected void setLabelAsBold(boolean val) {
        this.labelAsBold = val;
    }

    public Workbook createBook(ObjectSelection os, File workbook, WorkbookProvider.WORKBOOK_FORMAT bookFormat) {
        Workbook wb = null;
        try {
            FileOutputStream fileOut = new FileOutputStream(workbook.getPath());
            wb = this.createBook(os, fileOut, bookFormat);
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wb;
    }

    public Workbook createBook(ObjectSelection os, OutputStream workbook, WorkbookProvider.WORKBOOK_FORMAT bookFormat) {
        Workbook wb = this.createBook(os, bookFormat);
        try {
            wb.write(workbook);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wb;
    }

    private Workbook createBook(ObjectSelection os, WorkbookProvider.WORKBOOK_FORMAT bookFormat) {
        this.workbook = this.getWorkbookProvider().createWorkbook(bookFormat);
        this.setAllMapElements();
        Sheet defaultSheet = this.workbook.createSheet(WorkbookUtil.createSafeSheetName((String)this.getSheetName()));
        this.exportDialog(os, defaultSheet);
        return this.workbook;
    }

    protected abstract void exportDialog(ObjectSelection var1, Sheet var2);

    protected abstract void setAllMapElements();

    protected abstract String getSheetName();

    protected abstract boolean getParameterHidden();

    protected abstract String getDialogName();

    protected Cell createCell(DialogObjectConstant dialogElement, Sheet sheet, G9ExcelCell offset, boolean isLabel, short alignment) {
        return this.createCell(dialogElement, sheet, offset, isLabel, -1, null, alignment);
    }

    protected Cell createCell(DialogObjectConstant dialogElement, Sheet sheet, G9ExcelCell offset, boolean isLabel, int colIndex, short alignment) {
        return this.createCell(dialogElement, sheet, offset, isLabel, colIndex, null, alignment);
    }

    protected Cell createCell(DialogObjectConstant dialogElement, Sheet sheet, G9ExcelCell offset, boolean isLabel, int colIndex, String columnTitle, short alignment) {
        int labelColumn;
        ExportElement ee = this.elements.get(dialogElement);
        Row row = G9ExcelExporter.getRow(sheet, ee.getRow(), offset.getRow());
        int column = colIndex == -1 ? ee.getColumn() : colIndex;
        Cell cell = row.createCell(column + offset.getColumn());
        cell.setCellStyle(G9ExcelExporter.createCellStyle(sheet, alignment, isLabel && this.labelAsBold));
        if (isLabel) {
            this.setLabelCellData(cell, dialogElement, columnTitle);
        } else if (G9ExcelExporter.addLabelForCheckButton(dialogElement) && (labelColumn = column + offset.getColumn() - 1) >= 0 && row.getCell(labelColumn) == null) {
            Cell labelCell = row.createCell(labelColumn);
            labelCell.setCellStyle(G9ExcelExporter.createCellStyle(sheet, alignment, this.labelAsBold));
            this.setLabelCellData(labelCell, dialogElement, columnTitle);
        }
        return cell;
    }

    private void setLabelCellData(Cell cell, DialogObjectConstant dialogObject, String columnTitle) {
        String cellData;
        ExportElement ee = this.elements.get(dialogObject);
        if (!ee.isShown() && !this.getParameterHidden() || !ee.isExported()) {
            cellData = "";
        } else {
            try {
                cellData = this.getBundle().getString(dialogObject.getMessageID());
            }
            catch (MissingResourceException mre) {
                cellData = this.getBundle().getString(columnTitle);
            }
        }
        if (cellData != null) {
            cell.setCellValue(cellData);
        }
    }

    private static CellStyle createCellStyle(Sheet sheet, short alignment, boolean asBold) {
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        Font f = sheet.getWorkbook().getFontAt(cellStyle.getFontIndex());
        if (asBold) {
            cellStyle.setFont(G9ExcelExporter.getBoldFont(sheet, f));
        } else {
            cellStyle.setFont(f);
        }
        cellStyle.setAlignment(alignment);
        cellStyle.setVerticalAlignment((short)0);
        return cellStyle;
    }

    private static boolean parentIsTable(DialogObjectConstant dialogObject) {
        DialogObjectConstant parent;
        return dialogObject.getParent() instanceof DialogObjectConstant && (parent = (DialogObjectConstant)dialogObject.getParent()).getType() == DialogObjectType.TableBlock;
    }

    private static Font getBoldFont(Sheet sheet, Font font) {
        short fontColor = font.getColor();
        short fontHeight = font.getFontHeight();
        String fontName = font.getFontName();
        boolean italic = font.getItalic();
        boolean strikeout = font.getStrikeout();
        short typeOffset = font.getTypeOffset();
        byte underline = font.getUnderline();
        Font bf = sheet.getWorkbook().findFont((short)700, fontColor, fontHeight, fontName, italic, strikeout, typeOffset, underline);
        if (bf == null) {
            bf = sheet.getWorkbook().createFont();
            bf.setBoldweight((short)700);
            bf.setColor(fontColor);
            bf.setFontHeight(fontHeight);
            bf.setFontName(fontName);
            bf.setItalic(italic);
            bf.setStrikeout(strikeout);
            bf.setTypeOffset(typeOffset);
            bf.setUnderline(underline);
        }
        return bf;
    }

    protected G9ExcelCell createTable(ObjectSelection os, RoleConstant targetRole, List<TableColumnData> columnDataList, Sheet sheet, G9ExcelCell initialCell, boolean showHeader, DialogObjectConstant doc) {
        int colIndex = 0;
        int rowIndex = initialCell.getRow();
        if (!showHeader) {
            --rowIndex;
        }
        this.setGlobalCompareValues(columnDataList);
        List<Object> targetObjects = this.getSortedTargetObjects(os, targetRole);
        if (targetObjects != null && !targetObjects.isEmpty()) {
            boolean showingHeader = showHeader;
            for (Object targetObject : targetObjects) {
                G9ExcelCell offset = this.addRowData(columnDataList, sheet, initialCell, showingHeader, ++rowIndex, targetObject);
                colIndex = offset.getColumn();
                rowIndex = offset.getRow();
                showingHeader = false;
            }
        } else if (showHeader) {
            for (TableColumnData columnData : columnDataList) {
                this.addColumnHeader(sheet, columnData.getDiaConst(), initialCell, colIndex);
                ++colIndex;
            }
            ++rowIndex;
        }
        return new G9ExcelCell(colIndex, rowIndex);
    }

    private G9ExcelCell addRowData(List<TableColumnData> columnDataList, Sheet sheet, G9ExcelCell initialCell, boolean showHeader, int rowIndex, Object targetObject) {
        int colIndex = 0;
        int newRowIndex = rowIndex;
        for (TableColumnData columnData : columnDataList) {
            DialogObjectConstant column = columnData.getDiaConst();
            if (showHeader) {
                this.addColumnHeader(sheet, column, initialCell, colIndex);
            }
            ExportElement columnEe = this.elements.get(column);
            columnEe.setColumn(colIndex);
            if (targetObject != null && columnEe.isExported()) {
                String methodName = columnData.getBcMethod();
                if (methodName != null && !methodName.equals("")) {
                    G9ExcelCell offset = this.callPlacementMethod(methodName, targetObject, sheet, new G9ExcelCell(initialCell.getColumn() + colIndex, rowIndex));
                    colIndex = offset.getColumn();
                    newRowIndex = offset.getRow();
                } else {
                    Cell cell = this.createCell(column, sheet, new G9ExcelCell(initialCell.getColumn(), rowIndex), false, columnData.getCellAlignment());
                    this.setCellData(column, this.getColumnObject(targetObject, column.getAttribute().getAttributeRole()), cell, columnData.getCellFormat());
                }
            }
            ++colIndex;
        }
        if (colIndex > 0) {
            --colIndex;
        }
        return new G9ExcelCell(colIndex, newRowIndex);
    }

    private void addColumnHeader(Sheet sheet, DialogObjectConstant column, G9ExcelCell offset, int col) {
        DialogObjectConstant label = column.getLabelComponent();
        if (label == null) {
            label = column;
        }
        String columnTitleID = column.getMessageID();
        columnTitleID = columnTitleID.substring(0, columnTitleID.lastIndexOf("title")) + "column_title";
        ExportElement labelEe = this.elements.get(label);
        if ((labelEe.isShown() || this.getParameterHidden()) && labelEe.isExported()) {
            this.createCell(label, sheet, offset, true, col, columnTitleID, (short)1);
        }
    }

    private G9ExcelCell callPlacementMethod(String methodName, Object targetObject, Sheet sheet, G9ExcelCell initialCell) {
        try {
            Method method = this.getClass().getMethod(methodName, Object.class, Sheet.class, G9ExcelCell.class);
            try {
                return (G9ExcelCell)method.invoke((Object)this, targetObject, sheet, initialCell);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                System.err.println("Error when adding block to table: \nCould not access the method \"" + methodName + "\" whit parameters Object, Sheet and G9ExcelCell.");
            }
            catch (ClassCastException e) {
                System.err.println("Error when adding block to table: \nCould not cast return value from " + methodName + " to G9ExcelExporter.");
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            System.err.println("Error when adding block to table: \nCould not find a method \"" + methodName + "\" whit parameters Object, Sheet and G9ExcelCell.");
        }
        return initialCell;
    }

    protected Object getColumnObject(Object targetObject, RoleConstant attributeRole) {
        OSRole<?> role = this.getRoleMap().get(attributeRole);
        if (role == null) {
            return null;
        }
        if (targetObject.getClass().equals(role.createNewInstance().getClass())) {
            return targetObject;
        }
        OSRole parent = role.getParent();
        if (targetObject.getClass().equals(parent.createNewInstance().getClass())) {
            return parent.getRelation(targetObject, attributeRole);
        }
        List children = role.getChildren();
        for (OSRole childRole : children) {
            Object o = this.getColumnObject(role.getRelation(targetObject, childRole.getRoleConstant()), childRole.getRoleConstant());
            if (o == null || !o.getClass().equals(childRole.createNewInstance().getClass())) continue;
            return o;
        }
        return null;
    }

    protected List<Object> getSortedTargetObjects(ObjectSelection os, RoleConstant targetRole) {
        Object rootObj = this.getRootObject(os, targetRole);
        return this.sortTargetObjects(this.getDomainObjectFromParent(rootObj, targetRole));
    }

    private List<Object> sortTargetObjects(Object targetObjects) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (targetObjects instanceof Collection) {
            for (Object targetObject : (Collection)targetObjects) {
                list.add(targetObject);
            }
            Collections.sort(list, this);
            return list;
        }
        return null;
    }

    protected void setCellData(DialogObjectConstant dialogElement, Object domainObject, Cell cell, String dateFormat) {
        AttributeConstant attribute = dialogElement.getAttribute();
        OSRole<?> role = this.getRoleMap().get(attribute.getAttributeRole());
        if (G9ExcelExporter.hookFilterElement(dialogElement, domainObject)) {
            return;
        }
        if (role == null || domainObject == null) {
            cell.setCellValue("");
        } else {
            if (domainObject instanceof Collection) {
                if (!((Collection)domainObject).isEmpty()) {
                    domainObject = ((Collection)domainObject).iterator().next();
                } else {
                    cell.setCellValue("");
                    return;
                }
            }
            Object data = role.getValue(domainObject, attribute);
            String cellData = G9ExcelExporter.formatAttributeData(attribute, data, dateFormat);
            try {
                if (!cellData.equals("")) {
                    cell.setCellValue((double)Integer.parseInt(cellData));
                } else {
                    cell.setCellValue(cellData);
                }
            }
            catch (NumberFormatException nfe) {
                cell.setCellValue(cellData);
            }
        }
    }

    protected Object getTargetObject(ObjectSelection os, RoleConstant targetRole) {
        Object root = this.getRootObject(os, targetRole);
        OSRole<?> role = this.getRoleMap().get(targetRole);
        List<OSRole<?>> roleList = G9ExcelExporter.getRoleHierarchy(role);
        Object result = root;
        for (int i = roleList.size() - 1; i > 0; --i) {
            OSRole<?> childRole = roleList.get(i - 1);
            result = roleList.get(i).isMany() || result instanceof Collection ? G9ExcelExporter.getChildObject(((Collection)result).iterator().next(), roleList.get(i), childRole.getRoleConstant()) : G9ExcelExporter.getChildObject(result, roleList.get(i), childRole.getRoleConstant());
        }
        return result;
    }

    public Object getRootOrTargetObject(ObjectSelection os, RoleConstant targetRole, String compare) {
        Object root = this.getRootObject(os, targetRole);
        if (root == null) {
            return null;
        }
        if (root.toString().equals(compare)) {
            return root;
        }
        return this.getTargetObject(os, targetRole);
    }

    protected static Object getChildObject(Object parent, OSRole<?> parentRole, RoleConstant childRole) {
        return parentRole.getRelation(parent, childRole);
    }

    protected static List<OSRole<?>> getRoleHierarchy(OSRole<?> targetRole) {
        LinkedList roleList = new LinkedList();
        if (targetRole == null) {
            return roleList;
        }
        OSRole parent = targetRole;
        roleList.add(parent);
        while (!parent.isRoot()) {
            parent = parent.getParent();
            roleList.add(parent);
        }
        return roleList;
    }

    static <M, T> T convertToViewInternal(AttributeConstant attribute, M fieldValue) throws ConvertException {
        AttributeConverter converter = (AttributeConverter)G9Spring.getBean(AttributeConverter.class, (String)attribute.getConverterId());
        return (T)converter.fromModel(fieldValue, null);
    }

    private static String formatAttributeData(AttributeConstant attribute, Object attributeValue, String dateFormat) {
        String converterId;
        if (attributeValue == null) {
            return "";
        }
        if (attribute != null && (converterId = attribute.getConverterId()) != null) {
            try {
                attributeValue = G9ExcelExporter.convertToViewInternal(attribute, attributeValue);
                if (attributeValue == null || attributeValue == "") {
                    return "";
                }
            }
            catch (ConvertException convertException) {
                // empty catch block
            }
        }
        if (dateFormat != null && !dateFormat.equals("")) {
            if (attributeValue instanceof ReadableDateTime) {
                return ((ReadableDateTime)attributeValue).toString(dateFormat);
            }
            if (attributeValue instanceof LocalDate) {
                return ((LocalDate)attributeValue).format(DateTimeFormatter.ofPattern(dateFormat));
            }
            if (attributeValue instanceof LocalTime) {
                return ((LocalTime)attributeValue).format(DateTimeFormatter.ofPattern(dateFormat));
            }
            if (attributeValue instanceof LocalDateTime) {
                return ((LocalDateTime)attributeValue).format(DateTimeFormatter.ofPattern(dateFormat));
            }
            return new SimpleDateFormat(dateFormat).format(attributeValue);
        }
        if (attributeValue instanceof Boolean) {
            if (((Boolean)attributeValue).booleanValue()) {
                return G9ExcelExporter.getGeneralBundle().getString("boolean.true.title");
            }
            return G9ExcelExporter.getGeneralBundle().getString("boolean.false.title");
        }
        return attributeValue.toString();
    }

    protected static boolean hookFilterElement(DialogObjectConstant dialogElement, Object domainObject) {
        return false;
    }

    protected static Row getRow(Sheet sheet, int localRow, int offset) {
        int rowNo = localRow + offset;
        if (sheet == null) {
            return null;
        }
        if (sheet.getRow(rowNo) != null) {
            return sheet.getRow(rowNo);
        }
        return sheet.createRow(rowNo);
    }

    private int getMax(DialogObjectConstant[] dialogElements, boolean isRow) {
        if (dialogElements == null) {
            return 0;
        }
        int maxValue = 0;
        for (DialogObjectConstant element : dialogElements) {
            ExportElement ee = this.elements.get(element);
            if (ee == null) continue;
            if (isRow && ee.getRow() > maxValue) {
                maxValue = ee.getRow();
            }
            if (isRow || ee.getColumn() <= maxValue) continue;
            maxValue = ee.getColumn();
        }
        return maxValue;
    }

    protected static G9ExcelCell getMax(G9ExcelCell[] cells) {
        if (cells == null) {
            return new G9ExcelCell(0, 0);
        }
        int maxColumn = 0;
        int maxRow = 0;
        for (G9ExcelCell cell : cells) {
            if (cell == null) continue;
            if (cell.getColumn() > maxColumn) {
                maxColumn = cell.getColumn();
            }
            if (cell.getRow() <= maxRow) continue;
            maxRow = cell.getRow();
        }
        return new G9ExcelCell(maxColumn, maxRow);
    }

    protected static G9ExcelCell getMax(G9ExcelCell offset, G9ExcelCell cell) {
        G9ExcelCell[] cells = new G9ExcelCell[]{offset, cell};
        return G9ExcelExporter.getMax(cells);
    }

    protected G9ExcelCell getMaxCell(DialogObjectConstant[] dialogElements, G9ExcelCell offset) {
        G9ExcelCell localOffset = offset == null ? new G9ExcelCell(0, 0) : offset;
        if (dialogElements == null) {
            return localOffset;
        }
        return new G9ExcelCell(localOffset.getColumn() + this.getMax(dialogElements, false), localOffset.getRow() + this.getMax(dialogElements, true));
    }

    protected Object getRootObject(ObjectSelection os, RoleConstant targetRole) {
        OSRole role = this.getRoleMap().get(targetRole);
        OSRole root = role.isRoot() ? role : role.getRoot();
        List targetObjects = os.getRootObjects(root.getRoleConstant().toString());
        if (targetObjects == null || targetObjects.size() < 1) {
            return new LinkedList();
        }
        if (targetObjects.size() > 1) {
            return targetObjects;
        }
        Iterator it = targetObjects.iterator();
        return it.next();
    }

    protected Object getDomainObjectFromParent(Object parentObject, RoleConstant targetRole) {
        if (parentObject == null) {
            return null;
        }
        OSRole role = this.getRoleMap().get(targetRole);
        if (role.isRoot()) {
            return parentObject;
        }
        LinkedList<OSRole> roleList = new LinkedList<OSRole>();
        OSRole currentRole = role;
        while (currentRole.getParent() != null) {
            roleList.add(currentRole);
            currentRole = currentRole.getParent();
        }
        Object result = parentObject;
        int i = roleList.size() - 1;
        while (currentRole != role && !(result instanceof Collection)) {
            result = currentRole.getRelation(result, ((OSRole)roleList.get(i)).getRoleConstant());
            currentRole = (OSRole)roleList.get(i);
            --i;
        }
        return result;
    }

    protected abstract Map<RoleConstant, OSRole<?>> getRoleMap();

    protected abstract ResourceBundle getBundle();

    protected static ResourceBundle getGeneralBundle() {
        return (ResourceBundle)G9Spring.getBean((String)"g9RuntimeResourceBundle");
    }

    protected G9ExcelCell getNextAvailableCell(DialogObjectConstant[] dialogElements, G9ExcelCell offset) {
        G9ExcelCell localOffset = offset == null ? new G9ExcelCell(0, 0) : offset;
        if (dialogElements == null) {
            return localOffset;
        }
        int maxRow = 0;
        int maxCol = 0;
        for (DialogObjectConstant element : dialogElements) {
            ExportElement ee = this.elements.get(element);
            if (ee == null) continue;
            if (ee.getRow() > maxRow) {
                maxRow = ee.getRow();
                maxCol = ee.getColumn();
                continue;
            }
            if (ee.getRow() != maxRow || ee.getColumn() <= maxCol) continue;
            maxCol = ee.getColumn();
        }
        return new G9ExcelCell(localOffset.getColumn() + maxCol, localOffset.getRow() + maxRow);
    }

    private void setGlobalCompareValues(List<TableColumnData> columnDataList) {
        this.listColumns = new DialogObjectConstant[columnDataList.size()];
        this.sortPriority = new int[columnDataList.size()];
        this.sorting = new ListRowComparator.Sorting[columnDataList.size()];
        int nonSortIndex = columnDataList.size() - 1;
        for (int i = 0; i < columnDataList.size(); ++i) {
            TableColumnData columnData = columnDataList.get(i);
            this.listColumns[i] = columnData.getDiaConst();
            this.sorting[i] = columnData.getSorting();
            int sortIndex = columnData.getSortIndex();
            if (sortIndex == -1) {
                this.sortPriority[i] = nonSortIndex--;
                continue;
            }
            int index = 0;
            for (TableColumnData column : columnDataList) {
                if (column.getSortIndex() == -1 || column.getSortIndex() >= sortIndex) continue;
                ++index;
            }
            this.sortPriority[i] = index;
        }
    }

    @Override
    public int compare(Object o1, Object o2) {
        DialogObjectConstant column = null;
        ListRowComparator.Sorting sortType = null;
        int result = 0;
        for (int sortPriIndex = 0; sortPriIndex < this.sortPriority.length; ++sortPriIndex) {
            for (int i = 0; i < this.sortPriority.length; ++i) {
                if (i != this.sortPriority[sortPriIndex]) continue;
                column = this.listColumns[i];
                sortType = this.sorting[i];
                break;
            }
            if (column == null) {
                System.err.println("An element in the priority queue is not is either less than 0 or greater than " + (this.sortPriority.length - 1));
            } else if (!ListRowComparator.Sorting.NO_SORT.equals(sortType)) {
                AttributeConstant attribute = column.getAttribute();
                OSRole<?> role = this.getRoleMap().get(attribute.getAttributeRole());
                Comparable v1 = (Comparable)role.getValue(this.getColumnObject(o1, column.getAttribute().getAttributeRole()), attribute);
                Comparable v2 = (Comparable)role.getValue(this.getColumnObject(o2, column.getAttribute().getAttributeRole()), attribute);
                result = v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : (ListRowComparator.Sorting.ASCENDING.equals(sortType) ? v1.compareTo(v2) : v2.compareTo(v1)));
            }
            if (result != 0) break;
        }
        return result;
    }

    protected static short getColumns(Sheet sheet) {
        short maxCol = 0;
        for (int r = 0; r <= sheet.getLastRowNum(); r = (int)((short)(r + 1))) {
            Row row = sheet.getRow(r);
            if (row == null || maxCol >= row.getLastCellNum()) continue;
            maxCol = row.getLastCellNum();
        }
        return maxCol;
    }

    protected static void autoResizeAll(Sheet sheet) {
        for (short columnIndex = 0; columnIndex < G9ExcelExporter.getColumns(sheet); columnIndex = (short)(columnIndex + 1)) {
            double width = SheetUtil.getColumnWidth((Sheet)sheet, (int)columnIndex, (boolean)false);
            if (width == -1.0) continue;
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            sheet.setColumnWidth((int)columnIndex, (int)width);
        }
    }

    private static boolean addLabelForCheckButton(DialogObjectConstant dialogElement) {
        return dialogElement.getType() == DialogObjectType.CheckButton && dialogElement.getLabelComponent() == null && !G9ExcelExporter.parentIsTable(dialogElement);
    }
}

