/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.spreadsheet;

import java.io.File;
import java.io.FileNotFoundException;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.spreadsheet.DefaultSpreadsheetService;
import no.g9.client.spreadsheet.WorkbookProvider;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

public class StandaloneSpreadsheetExporter {
    public static void generateSpreadsheet(ObjectSelection os, DialogConstant targetDialog, WorkbookProvider.WORKBOOK_FORMAT format, String outputDir) {
        try {
            File outputFile = StandaloneSpreadsheetExporter.createNewWorkbook(targetDialog, format, outputDir);
            ClientContext ctx = new ClientContext();
            ctx.setParam((Object)"WorkbookFormat", (Object)format);
            DefaultSpreadsheetService spreadsheetService = new DefaultSpreadsheetService();
            spreadsheetService.exportToSpreadsheet(os, targetDialog, outputFile, ctx);
            System.out.println("Generated the following file: \t" + outputFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not create new FileOutputStream - " + e.getMessage());
        }
    }

    private static File createNewWorkbook(DialogConstant targetDialog, WorkbookProvider.WORKBOOK_FORMAT format, String outputDir) throws FileNotFoundException {
        File outputDirectory = new File(outputDir);
        String formatSuffix = format.getSuffix();
        outputDirectory.mkdir();
        String fileName = targetDialog.getG9Name();
        File tempFile = new File(outputDir + "/" + fileName + formatSuffix);
        int counter = 1;
        while (tempFile.exists() && !tempFile.isDirectory()) {
            tempFile = new File(outputDir + "/" + fileName + " (" + ++counter + ")" + formatSuffix);
        }
        if (counter > 1) {
            fileName = fileName + " (" + counter + ")";
        }
        File outputStream = new File(outputDir + "/" + fileName + formatSuffix);
        return outputStream;
    }
}

