/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.action;

import java.util.concurrent.CountDownLatch;
import no.esito.jvine.action.ActionQueue;
import no.esito.log.Logger;
import no.g9.client.core.message.BlockingMessageCallback;
import no.g9.client.core.message.InteractionThreadPolicy;
import no.g9.message.Message;

public class UAMessageCallback
implements BlockingMessageCallback {
    private volatile Message message = null;
    private static final Logger log = Logger.getLogger(UAMessageCallback.class);
    private CountDownLatch latch;
    private ActionQueue guiActionQueue;

    private synchronized CountDownLatch getLatch() {
        if (this.latch == null) {
            this.latch = new CountDownLatch(1);
        }
        return this.latch;
    }

    private synchronized void removeLatch() {
        this.latch = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Message getMessage() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Getting message.");
        }
        this.message = null;
        this.guiActionQueue.release();
        boolean interrupted = false;
        try {
            while (this.message == null) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"No message received yet - going to sleep.");
                    }
                    this.getLatch().await();
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)"Woke up");
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Caught interrupted exception:", (Throwable)e);
                    interrupted = true;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning message " + this.message));
            }
            Message message = this.message;
            return message;
        }
        finally {
            this.removeLatch();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reply(Message msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received message reply " + msg));
        }
        UAMessageCallback uAMessageCallback = this;
        synchronized (uAMessageCallback) {
            this.message = msg;
        }
        this.getLatch().countDown();
        this.guiActionQueue.ready();
    }

    public final void setGuiActionQueue(ActionQueue guiActionQueue) {
        this.guiActionQueue = guiActionQueue;
    }

    @Override
    public InteractionThreadPolicy getInteractionThreadPolicy() {
        return InteractionThreadPolicy.ASYNC_WORKER_POLICY;
    }
}

