/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.Collection;
import java.util.concurrent.Callable;
import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.model.CurrentRoleObject;
import no.g9.client.core.action.ActionStage;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.Displayable;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.action.ThreadType;

class Display<V>
extends ActionStage<V>
implements Callable<Void> {
    Object toDisplay;

    Display(G9Action<V> g9Action, Object toDisplay) {
        super(g9Action);
        this.toDisplay = toDisplay;
    }

    void restoreCurrentInstances() {
        block0: for (CurrentRoleObject cro : this.ga.getCurrentInstanceList()) {
            JVineController controller = JVineController.getInstance(this.ga.getController());
            OSNode node = controller.getOSNode(cro.getRole());
            Collection allInstances = node.getAllInstances();
            for (Object object : allInstances) {
                if (!object.equals(cro.getCurrent())) continue;
                this.ga.getController().setCurrentInstance(cro.getRole(), object);
                continue block0;
            }
        }
    }

    void displayed() throws Exception {
        if (this.ga.shouldInvokeHook() && !this.ga.getDisplayableHooks().isEmpty()) {
            String methodName = "displayed";
            ThreadType threadType = this.ga.getThreadType(methodName, new Class[0]);
            HookMethod<Void> displayHook = new HookMethod<Void>(methodName){

                @Override
                public Void call() throws Exception {
                    for (Displayable hook : Display.this.ga.getDisplayableHooks()) {
                        hook.displayed();
                    }
                    return null;
                }
            };
            this.ga.getHookInvoker().execute(this.ga.getApplicationController(), threadType, displayHook);
        }
    }

    @Override
    public Void call() throws Exception {
        JVineController jVineController = JVineController.getInstance(this.ga.getController());
        ActionTask<Void> displayActionTask = jVineController.getDisplayDialogTask(this.ga.getActionTarget(), this.ga.getActionType());
        displayActionTask.setTaskObject(this.toDisplay);
        displayActionTask.call();
        if (this.ga.isSaveAction()) {
            this.restoreCurrentInstances();
        }
        this.displayed();
        G9Action.getLog().info((Object)(this.ga + " displayed"));
        return null;
    }
}

