/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.util;

import java.util.List;
import no.g9.client.core.controller.DialogController;
import no.g9.os.OSRole;
import no.g9.os.RoleConstant;

public class RoleNameHelper {
    private DialogController dialogController;

    public RoleNameHelper(DialogController dialogController) {
        this.dialogController = dialogController;
    }

    public String getTableName(String rootAttribute) {
        OSRole<?> osRole = this.getRole(rootAttribute);
        Class domainClass = osRole.getDomainClass();
        String tableName = domainClass.getSimpleName();
        return tableName;
    }

    public Object[] getColumnName(String rootAttribute, String roleAttribute) {
        String displayRule;
        OSRole<?> osRole = this.getRole(rootAttribute);
        OSRole<?> childOsRole = this.getRole(roleAttribute);
        Object[] colAndDataType = null;
        String columnName = roleAttribute.substring(roleAttribute.indexOf(".") + 1, roleAttribute.length());
        String dataType = osRole.equals(childOsRole) ? osRole.getAttributeConstant(columnName).getAttributeType().getName() : "";
        String string = displayRule = osRole.equals(childOsRole) ? osRole.getAttributeConstant(columnName).getDisplayRule() : "";
        if (!osRole.equals(childOsRole)) {
            List children = osRole.getChildren();
            String childClass = "";
            for (OSRole child : children) {
                if (!child.getRoleConstant().equals(childOsRole.getRoleConstant())) continue;
                childClass = child.getDomainClass().getSimpleName().toLowerCase() + ".";
                dataType = child.getAttributeConstant(columnName).getAttributeType().getName();
                displayRule = child.getAttributeConstant(columnName).getDisplayRule();
                columnName = childClass + columnName;
            }
        }
        if (columnName.equals("")) {
            throw new IllegalArgumentException("No such role attribute " + roleAttribute);
        }
        displayRule = displayRule.replaceAll("m", "M");
        colAndDataType = new Object[]{columnName, dataType, displayRule};
        return colAndDataType;
    }

    private OSRole<?> getRole(String rootAttribute) {
        String root = rootAttribute.substring(0, rootAttribute.indexOf("."));
        Object osConst = this.dialogController.getOSConst(root);
        if (osConst == null) {
            throw new IllegalArgumentException("No such role.");
        }
        Object osRole = this.dialogController.getOSRole((RoleConstant)osConst);
        return osRole;
    }
}

