/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.g9.client.core.validator.FieldValidator;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationResult;

public class RegexpValidator
implements FieldValidator {
    private Pattern[] patterns;
    private String faileMessageID = "-1523";
    private Object[] failMessageArgs = null;

    public void setPatterns(String[] patterns) {
        this.patterns = new Pattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            this.patterns[i] = Pattern.compile(patterns[i]);
        }
    }

    public void setPattern(String pattern) {
        this.patterns = new Pattern[]{Pattern.compile(pattern)};
    }

    public void setFailMessageNumber(String messageID) {
        this.faileMessageID = messageID;
    }

    public void setFailMessageArgs(Object[] messageArgs) {
        this.failMessageArgs = messageArgs != null ? (Object[])messageArgs.clone() : null;
    }

    @Override
    public ValidationResult validate(Object value, ValidateContext context) {
        if (value == null) {
            return ValidationResult.DEFAULT_OK_RESULT;
        }
        String s = value.toString();
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            return ValidationResult.DEFAULT_OK_RESULT;
        }
        return new ValidationResult(false, this.faileMessageID, this.failMessageArgs);
    }
}

