/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.validator;

import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.converter.FieldConvertContext;
import no.g9.client.core.message.FieldMessageContext;
import no.g9.client.core.view.ListRow;
import no.g9.os.AttributeConstant;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;
import no.g9.support.convert.ConvertException;

public class ValidateContext
implements FieldMessageContext {
    private final DialogController dialogController;
    private final DialogObjectConstant dialogObjectConstant;
    private final ListRow listRow;
    private final ActionType action;

    public ValidateContext(DialogController dCtrl, DialogObjectConstant dObjectConstant) {
        this(dCtrl, null, dObjectConstant, null);
    }

    public ValidateContext(DialogController dCtrl, DialogObjectConstant dialogObject, ActionType actionType) {
        this(dCtrl, null, dialogObject, actionType);
    }

    public ValidateContext(DialogController dCtrl, ListRow lRow, DialogObjectConstant dObjectConstant) {
        this(dCtrl, lRow, dObjectConstant, null);
    }

    public ValidateContext(DialogController dCtrl, ListRow lRow, DialogObjectConstant dObjectConstant, ActionType action) {
        this.dialogController = dCtrl;
        this.listRow = lRow;
        this.dialogObjectConstant = dObjectConstant;
        this.action = action;
    }

    public <M, T> M convertToModel(T value) throws ConvertException {
        AttributeConverter converter = this.dialogController.getViewModel().getConverter(this.dialogObjectConstant);
        if (converter == null) {
            return (M)value;
        }
        FieldConvertContext context = new FieldConvertContext(this.dialogController, this.dialogObjectConstant);
        return (M)converter.toModel(value, (ConvertContext)context);
    }

    public DialogController getDialogController() {
        return this.dialogController;
    }

    public DialogObjectConstant getDialogObjectConstant() {
        return this.dialogObjectConstant;
    }

    public RoleConstant getRole() {
        AttributeConstant attribute;
        RoleConstant role = null;
        if (this.dialogObjectConstant != null && (attribute = this.dialogObjectConstant.getAttribute()) != null) {
            role = attribute.getAttributeRole();
        }
        return role;
    }

    public ListRow getListRow() {
        return this.listRow;
    }

    public ActionType getAction() {
        return this.action;
    }

    @Override
    public DialogObjectConstant getField() {
        return this.dialogObjectConstant;
    }
}

