/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.table;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.Property;
import no.g9.os.AttributeConstant;

public class ListRowComparator<T extends ListRow>
implements Comparator<T>,
Comparable<ListRowComparator<T>> {
    private static final Logger log = Logger.getLogger(ListRowComparator.class);
    private Collator collator = Collator.getInstance();
    private final int initialPriority;
    private final DialogObjectConstant column;
    private Sorting direction = Sorting.ASCENDING;
    private ListRowComparator<T> next;

    final ListRowComparator<T> getNextComparator() {
        return this.next;
    }

    static <U extends ListRow> ListRowComparator<U> chainComparator(List<ListRowComparator<U>> comparators) {
        if (comparators == null || comparators.size() == 0) {
            return null;
        }
        for (int i = 0; i < comparators.size() - 1; ++i) {
            comparators.get((int)i).next = comparators.get(i + 1);
        }
        comparators.get((int)(comparators.size() - 1)).next = null;
        return comparators.get(0);
    }

    public ListRowComparator(DialogObjectConstant column, int initialPriority) {
        this.column = column;
        ListRowComparator.verifyColumn(column);
        this.initialPriority = initialPriority;
        this.collator.setStrength(3);
    }

    public ListRowComparator(DialogObjectConstant column, int initialPriority, Sorting sortDirection) {
        this(column, initialPriority);
        this.setSorting(sortDirection);
    }

    private static void verifyColumn(DialogObjectConstant column) {
        AttributeConstant attribute = column.getAttribute();
        if (attribute == null) {
            return;
        }
        Class attributeType = attribute.getAttributeType();
        if (!Comparable.class.isAssignableFrom(attributeType)) {
            String msg = null;
            msg = "Column " + column + " does not contain java.lang.Comparable values";
            log.error((Object)("Cant create list row comparator for " + column + ":"));
            throw new IllegalArgumentException(msg);
        }
    }

    public void toggleSorting() {
        this.direction = this.getNext();
    }

    private Sorting getNext() {
        switch (this.direction) {
            case NO_SORT: {
                return Sorting.ASCENDING;
            }
            case ASCENDING: {
                return Sorting.DESCENDING;
            }
            case DESCENDING: {
                return Sorting.NO_SORT;
            }
        }
        throw new RuntimeException("Unkonwn sort direction " + this.direction + ". Can't toggle!");
    }

    public Sorting getSorting() {
        return this.direction;
    }

    public void setSorting(Sorting sortDirection) {
        this.direction = sortDirection;
    }

    public DialogObjectConstant getColumn() {
        return this.column;
    }

    @Override
    public int compare(T o1, T o2) {
        int result = 0;
        if (this.direction != Sorting.NO_SORT) {
            Comparable v1 = (Comparable)((ListRow)o1).getValue(this.column);
            Comparable v2 = (Comparable)((ListRow)o2).getValue(this.column);
            result = v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : (v1 instanceof String ? this.collator.compare(v1, v2) : v1.compareTo(v2)));
            result *= this.direction.getDirection();
        }
        if (result == 0 && this.next != null) {
            result = this.next.compare(o1, o2);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.initialPriority;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListRowComparator other = (ListRowComparator)obj;
        return this.initialPriority == other.initialPriority;
    }

    @Override
    public int compareTo(ListRowComparator<T> o) {
        return this.initialPriority - o.initialPriority;
    }

    public String toString() {
        return "ListRowComparator [column=" + this.column + ", direction=" + this.direction + ", next=" + this.next + "]";
    }

    public static enum Sorting implements Property<Enum<Sorting>>
    {
        NO_SORT(0),
        ASCENDING(1),
        DESCENDING(-1);

        private final int dir;
        public static final Sorting DEFAULT;

        private Sorting(int dir) {
            this.dir = dir;
        }

        int getDirection() {
            return this.dir;
        }

        @Override
        public Enum<Sorting> getDefaultValue() {
            return DEFAULT;
        }

        public String toString() {
            return Sorting.class.getSimpleName() + ": " + this.name();
        }

        static {
            DEFAULT = ASCENDING;
        }
    }
}

