/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.print.ejb;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Remote;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

import no.g9.service.print.JasperReportsPrint;
import no.g9.service.print.PrintRemoteService;

@Remote(PrintRemoteService.class)
@Stateless(mappedName="PrintService")
@EJB(name="printEJB", mappedName="printEJB")
public class PrintBean implements PrintRemoteService {

    public PrintBean() {

    }

    JasperReportsPrint helper = new JasperReportsPrint();

    /**
     * Fills the template with the data and prints on the printer specified.
     *
     * @param data          Data as XML string to be printed formed in a file 
     * @param dialogName    The template to be filled and printed
     * @param printerName   The name of the printer
     */
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public void print(String data, String dialogName, String printerName) {
        helper.printReport(data, null, dialogName, printerName);
    }

}
