/**
 * @version 2.6.0
 * 
 * Needs jQuery version 1.8.3, higher versions do not work with jquery.address version 1.5.
 * jQuery 1.9.x and never can be used with jquery.address if jquery.migrate is added.
 * Needs jquery.address version 1.5.
 */

/* Methods for decoding and parsing messages */

function decodeMessage(message) 
{
	var messageSplit = split(message, '[\/\\\\]', 3);
	var decodedMessage = {"receiver" : messageSplit[0], "port" : messageSplit[1], "payload" : messageSplit[2]};
	return decodedMessage;

}

function recodeMessage(decodedMessage) 
{
	var recodedMessage = decodedMessage.receiver + '/' + decodedMessage.port + '/' + decodedMessage.payload;
	return recodedMessage;
}

function split(input, splitter, numberOfSplits) 
{
	if(numberOfSplits <=1)
		return [input];

	var returnValue = [];
	if(input.match(splitter) != null) 
	{
		var i = input.search(splitter);
		var found = input.slice(0, i);
		var rest = input.slice(i + 1);
		returnValue.push(found);
		returnValue = returnValue.concat(split(rest, splitter, numberOfSplits - 1));
	} 
	else
	{
		returnValue.push(input);
	}
	return returnValue;
}


/* Method for finding the message receiver, if the receiver is blank or marked with a dot '.' for current application */
function findMessageReceiver(decodedMessage) 
{
	var returnMessage = decodedMessage;
	if(decodedMessage.receiver == '')
	{
		if(addressBook[decodedMessage.port] != null) {		
			returnMessage.receiver = addressBook[decodedMessage.port];
		}
	}
	else if(decodedMessage.receiver == '.') 
	{
		if(stack.length > 0){
			returnMessage.receiver = stack[stack.length -1].name;
		}
		else {
			log("Tried to send a message to current application, but there is no current application loaded.");
		}
	}
	return returnMessage;
}

/* The variable containing the dialog names and the application they belong to */
var addressBook = {};

/* Method for adding entries to the addressBook */
function addAddressEntries(application, dialogs) 
{
	var i;
	for(i=0; i<dialogs.length; i++) {
		addressBook[(dialogs[i])] = application;
	}
}

/* Method for changing the anchor of the url */
function changeAnchor(anchor) 
{
	_skip_next_anchor_change_value=anchor;
	jQuery.address.hash(anchor);
	jQuery.address.update();
	log("Changed anchor to " + anchor);
}

function anchorChangeCallback(event)
{
	var hash=event.value.split('#').pop();
	if( (typeof _skip_next_anchor_change_value === 'undefined') || _skip_next_anchor_change_value!==hash){
	    if(hash != '') {
	        log("Callback from jQuery.history invoked, message: " + hash);
	        send(hash);
	    }
	}
	_skip_next_anchor_change_value=null;
}

var messageQueue = new Array();

function addMessageToQueue(message) 
{
	if(message.receiver == 'system') {
		send(message);
		return;
	}
	var i = 0;
	for(i = 0; i < messageQueue.length; i++) {
		if(compareMessage(message, messageQueue[i]) == true) {
			log("Failed to add message to messageQueue - message is already added.");
			return;
		}
	}
	messageQueue.push(message);
}

function compareMessage(message1, message2) 
{
	if(message1.receiver == message2.receiver)
		if(message1.port == message2.port)
			if(message1.payload == message2.payload)
				return true;
	return false;
}

var lastSentMessage = '';

/* Method used to send messages via the routingTable */
function send(decodedMessage) 
{
	if(decodedMessage == '' || decodedMessage == undefined) {
		log("Could not send message: '" + decodedMessage + "'.");
	} 
	else {
		if(decodedMessage.receiver == undefined && decodedMessage.port == undefined) {
			log("Tried to send message '" + decodedMessage + "', no receiver or port detected. Decoding and resending.");
			send(decodeMessage(decodedMessage));
		} 
		else {
			decodedMessage = findMessageReceiver(decodedMessage);
			if(decodedMessage.receiver != undefined) {
				if(routingTable[decodedMessage.receiver] != undefined) {
					lastSentMessage = decodedMessage;
					log("Sending message : " + recodeMessage(decodedMessage));
					return routingTable[decodedMessage.receiver](decodedMessage);
				} 
				else if(applicationNames.indexOf(decodedMessage.receiver) != -1) {
					addMessageToQueue(decodedMessage);
				}
				else if(decodedMessage.receiver == '*') {
					log("Broadcasting message: " + recodeMessage(decodedMessage));
					var i = 0;
					for(i = 0; i < applicationNames.length; i++) {
						var broadCastedMessage = decodedMessage;
						broadCastedMessage.receiver = applicationNames[i];
						send(broadCastedMessage);
					}
				}
				else {
					log("Failed to send message. Unknown message receiver: " + JSON.stringify(decodedMessage.receiver));
				}
			}
			else {
				log("Failed to send message " + JSON.stringify(decodedMessage) + ". No message receiver.");
			}
		}
	}
}

/* The variable containing the methods invoked when routing a message to the application or the system */
var routingTable =
{
		"system" : function(decodedMessage) 
		{
			if(decodedMessage.port=='url'){
				changeAnchor(decodedMessage.payload);
			}

			if(decodedMessage.port == 'get_setup') {
				var decodedPayload = decodeMessage(decodedMessage.payload);
				decodedPayload.payload = systemSetupUrl;
				send(decodedPayload);
			}

			if(decodedMessage.port == 'stack_push') {
				var decodedPayload = decodeMessage(decodedMessage.payload);
				var payloadWithReceiver = findMessageReceiver(decodedPayload);
				switchFrame(payloadWithReceiver.receiver);
			}

			if(decodedMessage.port == 'stack_pop') {
				removeElementFromStack();
			}
			if(decodedMessage.port == 'stack_elevate') {
				var decodedPayload = decodeMessage(decodedMessage.payload);
				var payloadWithReceiver = findMessageReceiver(decodedPayload);
				if(applicationTable[payloadWithReceiver.receiver] != undefined) {
					var stackElement = applicationTable[payloadWithReceiver.receiver];
					elevateElementInStack(stackElement);
				}
			}
			if(decodedMessage.port == 'alert') {
				alert(decodedMessage.payload);
			}
			if(decodedMessage.port == 'open') {
				window.open(decodedMessage.payload);
			}
		}
};



/* Methods for adding and removing entries to the routingTable */
function addEntryToRoutingTable(name, value) 
{
	routingTable[name] = value;
}

function removeEntryFromRoutingTable(name) 
{
	delete routingTable[name];
}

/* The url where the system setup parameters is found, + setter for this variable */
var systemSetupUrl = '';

function setSystemSetupUrl(setupUrl) 
{
	document.cookie='setupUrl='+setupUrl;
	systemSetupUrl = setupUrl;
	log("Changed systemSetupUrl to " + setupUrl);
}

function getSystemSetupUrl() 
{
	return systemSetupUrl;
}

/* The variable containing the stack of applications to be showed in the iframes */
var stack = new Array();

/* Functions for adding and removing elements on the stack, and hide/show methods for their iframes */
function addElementToStack(element) {

	var i = 0;
	for(i = 0; i < stack.length; i++) {
		var stackElement = stack[i];
		if(stackElement.name == element.name) {
			if(stackElement.JSESSIONID != element.JSESSIONID) {
				stack.splice(i, 1);
			}
		}
	}

	stack.push(element);
	if(stack.length > 1) {
		var i = stack.length;
		var element1 = stack[i-1];
		var element2 = stack[i-2];
		if(element1.name != element2.name) {
			showElement(element1.name);
			hideElement(element2.name);
		}
	} else {
		showElement(element.name);
	}
}

function removeElementFromStack() {
	var i = stack.length;
	if(i < 1) {
		log("No more applications in the stack");
		return;
	}
	if(i > 1) {
		var element1 = stack[i-1];
		var element2 = stack[i-2];
		if(element1.name != element2.name) {
			hideElement(element1.name);
			showElement(element2.name);
		} 
		stack.pop();
	}
	else {
		hideElement(stack[i-1].name);
		stack.pop();
	}
}

function elevateElementInStack(element) 
{
	var i = 0;
	for(i = stack.length-1 ; i >= 0; i--) {
		var stackElement = stack[i];
		if(stackElement.name == element.name) {
			if(i == stack.length -1) {
				log("The application " + element.name + " is already on top.");
				return;
			}
			stack.splice(i, 1);
			addElementToStack(element);
			log("Elevated element with id " + element.name + " to the top of the viewstack.");
			return;
		}
	}
	log("No element with id " + element.name + " exists in the viewstack. Adding the element to the stack.");
	switchFrame(element.name);
}

function removeApplicationFromStack(element) 
{
	var i = 0;
	for(i = 0; i < stack.length; i++) {
		var stackElement = stack[i];
		if(stackElement.name == element) {
			stack.splice(i, 1);
		}
	}
	log("Removing all occurances of application " + element + " from the view stack, because of reload."); 
	if(stack.length > 0)
		showElement(stack[stack.length - 1].name);
}

function hideElement(element)
{
	log("Hiding iframe " + element);
	document.getElementById(element).className = "hidden";
}

function showElement(element)
{
	log("Showing iframe " + element);
	document.getElementById(element).className = "visible";
}

/* Method for setting the src parameter of an iframe */
function setIFrameSource(frameId, url) 
{
	var iFrame = $('#' + frameId).get(0);
	if(iFrame != null) {
		iFrame.src = url;
	} else {
		log("Could not set iframe source. FrameId: " + frameId + ", source: " + url);
	}
}

function loadFrame(appName) 
{
	log("Loading iframe: " + appName);
	if($('#' + appName).get(0) == null) {
		$($('#' + divId)).append('<iframe id=' + appName + ' scrolling="yes" class="hidden" frameborder="0" ALLOWTRANSPARENCY="true"></iframe>');
		setIFrameSource(appName, applicationTable[appName].url);
	}
	else {
		if(applicationTable[appName].state != 'ready') {
			setIFrameSource(appName, applicationTable[appName].url);
			log("Reloading iframe.");
		}
		else {
			log("Iframe is already loaded.");
		}
	}
}

/* Method for displaying an application on top (switch to application) */
function switchFrame(appName) 
{
	log("Switching to iframe " + appName);
	loadFrame(appName);
	var stackElement = applicationTable[appName];
	addElementToStack(stackElement);
}

/* The id of the div element that holds the iframes */
var divId = '';

/* The variable containing the systems application names and the url where they are found */
var applicationTable = {};

/* Method for adding entries to the applicationTable */ 
function addEntryToApplicationTable(name, value) 
{
	applicationTable[name] = value;
}

var remainingSetupCalls;

var applicationNames = new Array();

/* Method for setting up the applicationTable based on the setupUrl */
function setupApplicationTable() 
{
	log("Setting up the system from " + systemSetupUrl);
	$.getJSON(systemSetupUrl, function(json) {
		if(json) {

			divId = json['view-tag'];
			remainingSetupCalls = (json.parts).length;

			var i = 0;
			for(i=0; i<(json.parts).length; i++) {

				if(json.parts[i].frameId != undefined) {
					var partUrl = json.parts[i].url;
					if(json.parts[i].setupAware == 'true') {
						partUrl = partUrl + '?setupUrl=' + systemSetupUrl;
					}
					setIFrameSource(json.parts[i].frameId, partUrl);
				}

				if(json.parts[i].external != undefined) {
					addEntryToApplicationTable(json.parts[i].external, {"name" : json.parts[i].external, "title" : json.parts[i].external, "url" : json.parts[i].url, "external" : true});
					addEntryToRoutingTable(json.parts[i].external, function(message) {
						loadFrame(message.receiver);
						var element = applicationTable[message.receiver];
						elevateElementInStack(element);
					});
					remainingSetupCalls = remainingSetupCalls - 1;
				}
				else {
					var appUrl = '' + json.parts[i].url + 'resources/application.json';
					jQuery.support.cors = true;
					log("Setting up address table - calling " + appUrl);
					setupAddressTable(appUrl, json, i);
				}
			}
		}
	});
}

function setupAddressTable(setupAppUrl, jsonFromSetup, counter) {

	$.getJSON(setupAppUrl, function(jsonAppInput) {
		if(jsonAppInput) {
			addAddressEntries(jsonAppInput.name, jsonAppInput.ports);
			applicationNames.push(jsonAppInput.name);

			// Frames with given frameId
			if(jsonFromSetup.parts[counter].frameId != undefined) {
				addEntryToApplicationTable(jsonFromSetup.parts[counter].frameId, {"name" : jsonAppInput.name, "title" : jsonAppInput.title, "url" : (jsonFromSetup.parts[counter].url + jsonAppInput.name + '.jsf'), "external" : false, "state" : "notLoaded"});
				displayApplicationState(jsonAppInput.title, "notLoaded");
				addEntryToRoutingTable(jsonAppInput.name, function(message) {
					if(applicationTable[jsonFromSetup.parts[counter].frameId].state != "ready") {
						loadFrame(jsonFromSetup.parts[counter].frameId);
						addMessageToQueue(message);
						log("Added message to messageQueue: " + recodeMessage(message));
					}
					else {
						var iFrame = $('#' + jsonFromSetup.parts[counter].frameId).get(0);
						iFrame.contentWindow.receiveMessageFromSystem(message);
					}
				});
			} 
			// Application without given frameId uses their application name as frameId
			else {
				addEntryToApplicationTable(jsonAppInput.name, {"name" : jsonAppInput.name, "title" : jsonAppInput.title, "url" : (jsonFromSetup.parts[counter].url + jsonAppInput.name + '.jsf'), "external" : false, "state" : "notLoaded"});
				displayApplicationState(jsonAppInput.title, "notLoaded");
				addEntryToRoutingTable(jsonAppInput.name, function(message) {
					if(applicationTable[message.receiver].state != "ready") {
						loadFrame(message.receiver);
						addMessageToQueue(message);
						log("Added message to messageQueue: " + recodeMessage(message));
					}
					else {
						var iFrame = $('#' + message.receiver).get(0);
						iFrame.contentWindow.receiveMessageFromSystem(message);
					}
				});
			}
			
			remainingSetupCalls = remainingSetupCalls - 1;
			if(remainingSetupCalls == 0) {
				setupCallback();
			}
		}
	});
}


function callbackFromFrame(frameId) 
{
	applicationTable[frameId].state = "ready";
	displayApplicationState(applicationTable[frameId].title, applicationTable[frameId].state);

	// Sending messages from the messageQueue 
	var i = 0;
	for(i = 0; i < messageQueue.length; i++) {
		if(messageQueue[i].receiver == applicationTable[frameId].name) {
			send(messageQueue[i]);
			messageQueue.splice(i, 1);
		}
	}

	var cookies = document.getElementById(frameId).contentDocument.cookie.split("; ");
	applicationTable[frameId]["JSESSIONID"] = getCookie("JSESSIONID", cookies);
	var element = applicationTable[frameId];
	// Removing old versions of the application from the stack and hiding them
	var j = 0;
	for(j = 0; j < stack.length; j++) {
		var stackElement = stack[j];
		if(stackElement.name == element.name) {
			if(stackElement.JSESSIONID != element.JSESSIONID) {
				hideElement(element.name);
				stack.splice(j, 1);
			}
		}
	}

	// Showing the top element of the stack
	if(stack.length > 0) {
		var element1 = stack[stack.length-1];
		showElement(element1.name);
	} 
}

var logEnabled = false;

function setLogEnabled(isEnabled) 
{
	if(!window.console && isEnabled == true) {
		alert("Failed to enable logging - no console detected.");
	}
	else {
		logEnabled = isEnabled;
	}
}

function log(logMessage) 
{
	if(logEnabled == true) {
		console.log(logMessage);
	}
}

function setupCallback() {

	var cookies = document.cookie.split("; ");
	if(getCookie('stack', cookies) != null) {
		var stackCookie = JSON.parse(getCookie('stack', cookies));
		log("Setting up the stack, values: " + stackCookie);
		setupStack(stackCookie);
	}

	var i = 0;
	for(i = 0; i < messageQueue.length; i++) {
		if(messageQueue[i].receiver != null) {
			send(messageQueue[i]);
		}
		messageQueue.splice(i, 1);
	}
}

function getURLParam(strParamName){
	var strReturn = "";
	var strHref = window.location.href;
	if ( strHref.indexOf("?") > -1 ){
		var strQueryString = strHref.substr(strHref.indexOf("?")).toLowerCase();
		var aQueryString = strQueryString.split("&");
		for ( var iParam = 0; iParam < aQueryString.length; iParam++ ){
			if ( 
					aQueryString[iParam].indexOf(strParamName.toLowerCase() + "=") > -1 ){
				var aParam = aQueryString[iParam].split("=");
				strReturn = aParam[1];
				break;
			}
		}
	}
	return unescape(strReturn);
}

function initializeSystemSetup(defaultSystemSetupUrl) 
{
	var override=getURLParam('system_setup');
	if(""==override) {
		setSystemSetupUrl(defaultSystemSetupUrl);
	}else {    
		setSystemSetupUrl(override);
	}

	setupApplicationTable();
	jQuery.address.change(anchorChangeCallback);
}

function setupStack(setupStack) 
{
	var i = 0;
	for(i = 0; i < setupStack.length; i++) {
		var stackElement = setupStack[i];
		loadFrame(stackElement.name);
	}
	stack = setupStack;
}

$(window).unload(function() {
	log('Handler for .unload() called.');
	if(stack.length > 0) {
		document.cookie = 'stack=' + JSON.stringify(stack);
	}
	else {
		document.cookie = 'stack=[]';
	}
});

function getCookie(cookieName, cookies) {
	var i = 0;
	for(i = 0; i < cookies.length; i++) {
		var cookie = cookies[i].split("=");
		if( cookie[0] == cookieName) {
			return cookie[1];
		} 
	}
}

var statusElement = undefined;

function setStatusElement(element) 
{
	statusElement = element;
}

function displayApplicationState(application, state)  {
	if(statusElement != undefined) {
		var statusNode = $('#' + statusElement);
		if (statusNode.length>0) {
			// Select all span elements
			var spanNodeId = application + '_state';
			var spanNode = statusNode.find('span#' + spanNodeId );
			if (spanNode.length<1) {
				spanNode = $(document.createElement('span'));
				spanNode.attr("id", spanNodeId);
				statusNode.append(spanNode);
				statusNode.append($(document.createElement('br')));
			}
			spanNode.text(application + ': ' + state);
		}
	}
}
