/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.component;

import java.awt.Component;
import java.awt.event.ActionListener;

import javax.swing.ComboBoxEditor;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;


/**
 * The editor used to edit the selected value of a combo box. The editor
 * component is currently a {@link G9TextField}, but might change in
 * future release. Thus one should not depend on a specific component type
 * being returned by the getEditorComoponent method.
 * 
 */
public class G9ComboBoxEditor implements ComboBoxEditor {
    /** The editor component */
    protected G9TextField editor;
    /** The combo using this editor */
    G9ComboBox comboBox;
    
    /** The object being edited by the editor */
    Object editObject;

    /**
     * Constructs a new editor. The editor is a G9TextField with no border.
     * @param combo the combo box using this editor.
     *
     */
    public G9ComboBoxEditor(G9ComboBox combo) {
        comboBox = combo;
        editor = new G9TextField() {
        	// Add some space to the left
            @Override public void setBorder(Border b) {
            	super.setBorder(new EmptyBorder(1, 2, 1, 1));
            }
        };
        
        
    }
        
    @Override
    public void addActionListener(ActionListener l) {
        editor.addActionListener(l);
    }

    /** Return the component that should be added to the tree hierarchy for
     * this editor. Currently this is a G9TextField, but this might change in
     * future releases. Thus it is advisable not to relay on the component being 
     * of a specific type.
     * @return the component used for editing.
     */
    @Override
    public Component getEditorComponent() {
        return editor;
    }

    @Override
    public Object getItem() {
        return editObject;
    }

    @Override
    public void removeActionListener(ActionListener l) {
        editor.removeActionListener(l);
    }

    @Override
    public void selectAll() {
        editor.selectAll();
    }

    @Override
    public void setItem(Object anObject) {
        editObject = anObject;
        if (anObject instanceof String) {
            anObject = editor.parse((String) anObject);
        } else {
            anObject = comboBox.getDisplayValue(anObject);
        }
        editor.setValue(anObject);
    }
    
    
    
    /**
     * Sets the select all on focus property
     * @param selectAllOnFocus the select all on focus property
     * @see G9TextField#setSelectAllOnFocus(boolean)
     */
    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        editor.setSelectAllOnFocus(selectAllOnFocus);
    }

    

    

}
