/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.component.menu;

import javax.swing.Action;

/**
 * The file menu class
 */
public class G9FileMenu extends G9Menu {

    /** Reference to the default file menu */
    private static G9FileMenu defaultFileMenu;
    
    /**
     * Gets the singleton instance of the default file menu. If the instance is
     * already created, the title parameter is ignored, otherwise the a new
     * default file menu is created using the specified title.
     * 
     * @param title the file menu title
     * @return the default file menu
     */
    public static G9FileMenu getDefaultFileMenu(String title) {
        if (defaultFileMenu == null) {
            defaultFileMenu = new G9FileMenu(title);
        }
        return defaultFileMenu;
    }
    
    
    /**
     * Constructs a new <code>JMenu</code> with no text.
     */
    public G9FileMenu() {
        this("");
    }

    /**
     * Constructs a new <code>JMenu</code> with the supplied string as its text.
     * 
     * @param s the text for the menu label
     */
    public G9FileMenu(String s) {
        super(s, G9Menu.FILE_MENU);
    }

    /**
     * Constructs a new <code>JMenu</code> with the supplied string as its text
     * and specified as a tear-off menu or not.
     * 
     * @param s the text for the menu label
     * @param b can the menu be torn off (not yet implemented)
     */
    public G9FileMenu(String s, boolean b) {
        this(s);
    }

    /**
     * Constructs a new <code>JMenu</code> whose properties are taken from the
     * <code>Action</code> supplied.
     * 
     * @param a the <code>Action</code>
     * @since 1.3
     */
    public G9FileMenu(Action a) {
        this("");
        setAction(a);
    }
}
