/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

/**
 * The value change interface, declaring various methods common to all components capable of 
 * fiering a value changed event.
 */
public interface G9ValueState {

    /**
     * Adds a change listener to this component. The change listener will
     * be notified when a value changed event occurs.
     * @param listener the listener to add
     */
    void addValueChangedListener(G9ValueChangedListener listener);

    /**
     * Forces the currently displayed value to be considered the old value.
     */
    void resetState();

    /**
     * Checks if the currently displayed value is the same as the initial
     * value. The initial value is updated when the component is updated
     * programaticly.
     * 
     * @return <code>true</code> if the displayed value differs from the
     *         initial value.
     */
    boolean isChanged();
    
    /**
     * Updates the displayed value of the component, without 
     * affecting the state of the component.
     * @param o the new value to display
     */
    public void display(Object o);
    
    /**
     * Returns the initial displayed value.
     * @return the initial displayed value
     */
    public Object getInitialValue();
    
    /**
     * Sets the initial value to be the specified value.
     * @param value the (new) initial value.
     */
    public void setInitialValue(Object value);

}
