/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.SwingUtilities;

/**
 * @deprecated This class has now been replaced by {@link DialogBlocker}
 */
@Deprecated
@SuppressWarnings({"unchecked", "rawtypes"})
public class EventBlocker extends EventQueue {

    /** The singleton instance */
    private static EventBlocker instance = null;

    /** map of blocked components */
    private Map blockedComponents = new HashMap();

    /**
     * Connects to the event queue.
     * 
     * @deprecated (missing javadoc)
     */
    @Deprecated
    private void connect() {
        EventQueue sysQ = Toolkit.getDefaultToolkit()
                .getSystemEventQueue();
        sysQ.push(this);
    }

    /**
     * Returns the singleton instance of this blocker.
     * 
     * @return the singleton instance of this event blocker.
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    public static synchronized EventBlocker getInstance() {
        if (instance == null) {
            instance = new EventBlocker();
            instance.connect();
        }
        return instance;
    }

    /**
     * Private constructor, use getInstance
     * 
     * @deprecated (missing javadoc)
     */
    @Deprecated
    private EventBlocker() { /* Not impl. */
    }

    /**
     * Blocks the specified component.
     * 
     * @param f the component to block
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    public synchronized void blockComponent(Component f) {
        dontBlockEvents = false;
        if (!blockedComponents.containsKey(f)) {
            blockedComponents.put(f, Boolean.FALSE);
        }
    }

    /**
     * Blocks the specified component
     * 
     * @param f the component to block
     * @param modalBlock if <code>true</code> blocking occurs because a modal
     *            document window is blocking.
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    public synchronized void blockComponent(Component f, boolean modalBlock) {
        dontBlockEvents = false;
        blockedComponents.put(f, Boolean.valueOf(modalBlock));
    }

    /**
     * Check if a component is blocked.
     * 
     * @param f the possible blocked component
     * @return <code>true</code> if <code>f</code> is blocked.
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    public synchronized boolean isBlocked(Component f) {
        return blockedComponents.containsKey(f);
    }

    /**
     * Unblocks a component
     * 
     * @param f the component to unblock
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    public synchronized void unblockComponent(Component f) {
        Boolean modalBlock = (Boolean) blockedComponents.get(f);
        if (modalBlock == null) {
            return;
        }
        if (!modalBlock.booleanValue()) {
            blockedComponents.remove(f);
            if (blockedComponents.size() == 0) {
                dontBlockEvents = true;
            }
        }
    }

    /**
     * Unblocks a component
     * 
     * @param f the component to unblock
     * @param modalUnblock if <code>true</code> unblock is done as part of a
     *            modal unblock.
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    public synchronized void unblockComponent(Component f, boolean modalUnblock) {
        if (modalUnblock) {
            blockedComponents.remove(f);
        }
        if (blockedComponents.size() == 0) {
            dontBlockEvents = true;
        }

    }

    /**
     * Returns the bottom window of the specified component
     * 
     * @param source the component
     * @return the bottom window
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    private Component getBottomWindow(Component source) {
        while (source != null && !(source instanceof BottomWindow)) {
            source = source.getParent();
        }
        return source;
    }

    /**
     * Returns the dialog source of an event.
     * 
     * @param event the event
     * @return the dialog where the event occured.
     * @deprecated use {@link DialogBlocker}
     */
    @Deprecated
    private Component getSource(AWTEvent event) {
        /*
         * Idea - scroll through parents until we find: - JWindow or
         * JInternalFrame
         */
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent) event;
            Component source = SwingUtilities.getDeepestComponentAt(me
                    .getComponent(), me.getX(), me.getY());
            return getBottomWindow(source);
        } else if (event instanceof KeyEvent) {
            Object source = event.getSource();
            if (source instanceof Component) {
                Component c = SwingUtilities
                        .findFocusOwner((Component) source);
                return getBottomWindow(c);
            }
        }
        return null;
    }

    /** Flag indicating whether events should be blocked or not. */
    private boolean dontBlockEvents = true;

    @Override
    protected synchronized void dispatchEvent(AWTEvent event) {
        /* No block? Keep the events coming */
        if (dontBlockEvents) {
            super.dispatchEvent(event);
            return;
        }
        /* Check - is this an event we want to mess with ? */
        if (event instanceof MouseEvent) {
            switch (event.getID()) {
                // case MouseEvent.MOUSE_DRAGGED:
                case MouseEvent.MOUSE_ENTERED:
                case MouseEvent.MOUSE_EXITED:
                case MouseEvent.MOUSE_MOVED:
                case MouseEvent.MOUSE_RELEASED:
                case MouseEvent.MOUSE_CLICKED:
                case MouseEvent.MOUSE_PRESSED:
                    break;
                default:
                    super.dispatchEvent(event);
                    return;
            }
        } else if (!(event instanceof KeyEvent)) {
            try {
                super.dispatchEvent(event);
            } catch (IndexOutOfBoundsException e) {
                String msg = "Caught the dreaded Swing-exception.\n"
                        + "\nPlease make a copy of the following:"
                        + "\nEvent: " + event + "\nEvent id: "
                        + event.getID() + "\nSource: " + event.getSource();
                System.err.println(msg);
                e.printStackTrace();
                System.err.println("Re-throwing exception");
                throw e;
            }
            return;
        } else { /* Must be a keyevent - allow through CTRL - TAB */
            KeyEvent anEvent = (KeyEvent) event;
            if (anEvent.getKeyCode() == KeyEvent.VK_TAB
                    && anEvent.isControlDown()) {
                super.dispatchEvent(event);
                return;
            }
        }
        Component c = getSource(event);
        if (c == null) {
            super.dispatchEvent(event);
            return;
        }
        for (Iterator i = blockedComponents.keySet().iterator(); i
                .hasNext();) {
            if (i.next() == c) {
                // Toolkit.getDefaultToolkit().beep();
                // System.out.println("Blocked:"+event.toString());
                return;
            }
        }
        super.dispatchEvent(event);
    }
    
}
